/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Flows;

import gov.nih.nlm.nls.lvg.Flows.Transformation;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import gov.nih.nlm.nls.lvg.Lib.LexItem;
import java.util.Vector;

public class ToMetaphone
extends Transformation
implements Cloneable {
    private static final String INFO = "Metaphone";

    public static Vector<LexItem> Mutate(LexItem in, int maxCodeLength, boolean detailsFlag, boolean mutateFlag) {
        String term = ToMetaphone.GetMetaphone(in.GetSourceTerm(), maxCodeLength);
        String details = null;
        String mutate = null;
        if (detailsFlag) {
            details = INFO;
        }
        if (mutateFlag) {
            mutate = Transformation.NO_MUTATE_INFO;
        }
        Vector<LexItem> out = new Vector<LexItem>();
        LexItem temp = ToMetaphone.UpdateLexItem(in, term, 41, -1L, -1L, details, mutate);
        out.addElement(temp);
        return out;
    }

    public static void main(String[] args) {
        Configuration conf = new Configuration("data.config.lvg", true);
        String testStr = ToMetaphone.GetTestStr(args, "neurologist");
        int maxLength = Integer.parseInt(conf.GetConfiguration("MAX_METAPHONE"));
        LexItem in = new LexItem(testStr);
        Vector<LexItem> outs = ToMetaphone.Mutate(in, maxLength, true, true);
        ToMetaphone.PrintResults(in, outs);
    }

    private static String GetMetaphone(String inStr, int maxCodeLength) {
        String outStr = new String();
        String tempStr = new String();
        if (inStr == null || inStr.length() == 0) {
            return tempStr;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < inStr.length(); ++i) {
            if (!Character.isLetter(inStr.charAt(i))) continue;
            buffer.append(inStr.charAt(i));
        }
        tempStr = buffer.toString();
        if (tempStr.length() == 0) {
            return "";
        }
        if (tempStr.length() == 1) {
            return tempStr;
        }
        if ((tempStr = tempStr.toUpperCase()).startsWith("GN") || tempStr.startsWith("KN") || tempStr.startsWith("PN") || tempStr.startsWith("AE") || tempStr.startsWith("WR")) {
            tempStr = tempStr.substring(1);
        } else if (tempStr.startsWith("X")) {
            tempStr = "S" + tempStr.substring(1);
        } else if (tempStr.startsWith("WH")) {
            tempStr = "W" + tempStr.substring(2);
        }
        buffer = new StringBuffer();
        int size = tempStr.length();
        block18: for (int i = 0; i < size; ++i) {
            char curChar = tempStr.charAt(i);
            if (ToMetaphone.GetCharAt(tempStr, i - 1) == curChar && curChar != 'C' || ToMetaphone.IsVowel(curChar) && i != 0) continue;
            switch (curChar) {
                case 'B': {
                    if (i == size - 1 && ToMetaphone.GetCharAt(tempStr, i - 1) == 'M') break;
                    buffer.append(curChar);
                    break;
                }
                case 'C': {
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'I' && ToMetaphone.GetCharAt(tempStr, i + 2) == 'A' || ToMetaphone.GetCharAt(tempStr, i + 1) == 'H' && ToMetaphone.GetCharAt(tempStr, i - 1) != 'S') {
                        buffer.append('X');
                        break;
                    }
                    if (ToMetaphone.IsFrontVowel(ToMetaphone.GetCharAt(tempStr, i + 1))) {
                        if (ToMetaphone.GetCharAt(tempStr, i - 1) == 'S') break;
                        buffer.append('S');
                        break;
                    }
                    buffer.append('K');
                    break;
                }
                case 'D': {
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'G' && ToMetaphone.IsFrontVowel(ToMetaphone.GetCharAt(tempStr, i + 2))) {
                        buffer.append('J');
                        break;
                    }
                    buffer.append('T');
                    break;
                }
                case 'G': {
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'N' || ToMetaphone.GetCharAt(tempStr, i + 1) == 'H' && (i == size - 1 || !ToMetaphone.IsVowel(ToMetaphone.GetCharAt(tempStr, i + 2))) || ToMetaphone.GetCharAt(tempStr, i - 1) == 'D' && ToMetaphone.IsFrontVowel(ToMetaphone.GetCharAt(tempStr, i + 1))) continue block18;
                    if (ToMetaphone.IsFrontVowel(ToMetaphone.GetCharAt(tempStr, i + 1))) {
                        buffer.append('J');
                        break;
                    }
                    buffer.append('K');
                    break;
                }
                case 'H': {
                    if (ToMetaphone.IsVowel(ToMetaphone.GetCharAt(tempStr, i - 1)) || ToMetaphone.IsVarson(ToMetaphone.GetCharAt(tempStr, i - 1)) || !ToMetaphone.IsVowel(ToMetaphone.GetCharAt(tempStr, i + 1))) break;
                    buffer.append('H');
                    break;
                }
                case 'K': {
                    if (ToMetaphone.GetCharAt(tempStr, i - 1) == 'C') break;
                    buffer.append('K');
                    break;
                }
                case 'P': {
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'H') {
                        buffer.append('F');
                        break;
                    }
                    buffer.append('P');
                    break;
                }
                case 'Q': {
                    buffer.append('K');
                    break;
                }
                case 'S': {
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'H' || ToMetaphone.GetCharAt(tempStr, i + 1) == 'I' && (ToMetaphone.GetCharAt(tempStr, i + 2) == 'A' || ToMetaphone.GetCharAt(tempStr, i + 2) == 'O')) {
                        buffer.append('X');
                        break;
                    }
                    buffer.append('S');
                    break;
                }
                case 'T': {
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'I' && (ToMetaphone.GetCharAt(tempStr, i + 2) == 'A' || ToMetaphone.GetCharAt(tempStr, i + 2) == 'O')) {
                        buffer.append('X');
                        break;
                    }
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'H') {
                        buffer.append('0');
                        break;
                    }
                    if (ToMetaphone.GetCharAt(tempStr, i + 1) == 'C' && ToMetaphone.GetCharAt(tempStr, i + 2) == 'H') continue block18;
                    buffer.append('T');
                    break;
                }
                case 'V': {
                    buffer.append('F');
                    break;
                }
                case 'W': {
                    if (!ToMetaphone.IsVowel(ToMetaphone.GetCharAt(tempStr, i + 1))) break;
                    buffer.append('W');
                    break;
                }
                case 'X': {
                    buffer.append("KS");
                    break;
                }
                case 'Y': {
                    if (!ToMetaphone.IsVowel(ToMetaphone.GetCharAt(tempStr, i + 1))) break;
                    buffer.append('Y');
                    break;
                }
                case 'Z': {
                    buffer.append('S');
                    break;
                }
                default: {
                    buffer.append(curChar);
                }
            }
            if ((outStr = buffer.toString()).length() >= maxCodeLength) break;
        }
        return outStr;
    }

    private static char GetCharAt(String str, int index) {
        try {
            return str.charAt(index);
        }
        catch (Exception e) {
            return '?';
        }
    }

    private static boolean IsVarson(char in) {
        return in == 'C' || in == 'G' || in == 'P' || in == 'S' || in == 'T';
    }

    private static boolean IsFrontVowel(char in) {
        return in == 'E' || in == 'I' || in == 'Y';
    }

    private static boolean IsVowel(char in) {
        return in == 'A' || in == 'E' || in == 'I' || in == 'O' || in == 'U';
    }
}

