/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.nlm.nls.lvg.Db;

import gov.nih.nlm.nls.lvg.Db.AntiNormComparator;
import gov.nih.nlm.nls.lvg.Db.AntiNormRecord;
import gov.nih.nlm.nls.lvg.Db.DbBase;
import gov.nih.nlm.nls.lvg.Lib.Configuration;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Vector;

public class DbAntiNorm {
    public static Vector<AntiNormRecord> GetAntiNorms(String normTerm, Connection conn) throws SQLException {
        String query = "SELECT normTerm, inflTerm, termCat, termInfl, eui FROM AntiNorm WHERE normTerm = ?";
        PreparedStatement ps = conn.prepareStatement(query);
        ps.setString(1, normTerm);
        Vector<AntiNormRecord> antiNorms = new Vector<AntiNormRecord>();
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            AntiNormRecord antiNormRecord = new AntiNormRecord();
            antiNormRecord.SetNormalizedTerm(rs.getString(1));
            antiNormRecord.SetInflectedTerm(rs.getString(2));
            antiNormRecord.SetCategory(rs.getInt(3));
            antiNormRecord.SetInflection(rs.getLong(4));
            antiNormRecord.SetEui(rs.getString(5));
            antiNorms.addElement(antiNormRecord);
        }
        rs.close();
        ps.close();
        AntiNormComparator ac = new AntiNormComparator();
        Collections.sort(antiNorms, ac);
        return antiNorms;
    }

    public static void main(String[] args) {
        String testStr = "disease osler rendu";
        if (args.length == 1) {
            testStr = args[0];
        }
        Configuration conf = new Configuration("data.config.lvg", true);
        try {
            Connection conn = DbBase.OpenConnection(conf);
            if (conn != null) {
                Vector<AntiNormRecord> antiNormList = DbAntiNorm.GetAntiNorms(testStr, conn);
                System.out.println("----- Total antiNorm forms found: " + antiNormList.size());
                for (int i = 0; i < antiNormList.size(); ++i) {
                    AntiNormRecord antiNorms = antiNormList.elementAt(i);
                    System.out.println("=== Found AntiNorm ===");
                    System.out.println(antiNorms.GetNormalizedTerm() + "|" + antiNorms.GetInflectedTerm() + "|" + antiNorms.GetCategory() + "|" + antiNorms.GetInflection() + "|" + antiNorms.GetEui());
                }
                DbBase.CloseConnection(conn, conf);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }
}

