/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.opennlp.maxent.encoder;

public class ContextValues {
    private int size;
    private String[] context;
    private float[] values;

    public ContextValues(String[] context, float[] values) {
        if (context.length != values.length) {
            throw new IllegalArgumentException(String.format("invalid lengths: %s != %s", context.length, values.length));
        }
        this.size = context.length;
        this.context = context;
        this.values = values;
    }

    public String[] getContext() {
        return this.context;
    }

    public float[] getValues() {
        return this.values;
    }

    public String toMaxentString() {
        StringBuilder builder = new StringBuilder();
        if (this.size == 0) {
            builder.append("null=0.0");
        }
        for (int i = 0; i < this.size; ++i) {
            if (i > 0) {
                builder.append(' ');
            }
            if (this.values[i] == 1.0f) {
                builder.append(this.context[i]);
                continue;
            }
            builder.append(this.context[i]).append('=').append(this.values[i]);
        }
        return builder.toString();
    }
}

