/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.user;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.component.CellRendererPanel;
import org.apache.ctakes.gui.pipeline.bit.PipeBitPainter;
import org.apache.ctakes.gui.pipeline.bit.user.UserBit;
import org.apache.ctakes.gui.util.IconLoader;

public final class UserBitRenderer
implements ListCellRenderer<Object> {
    private static final Logger LOGGER = Logger.getLogger("UsersRenderer");
    private static final Border SELECTED_BORDER = new LineBorder(Color.DARK_GRAY, 1, true);
    private static final Border UNSELECTED_BORDER = new EmptyBorder(0, 0, 0, 5);
    private final ListCellRenderer<Object> _delegate = new DefaultListCellRenderer();
    private JLabel _upLabel;
    private JLabel _downLabel;
    private JLabel _removeLabel;
    private final JPanel _focusRenderer = new CellRendererPanel(new BorderLayout());
    public static boolean SUSPEND_BUTTONS = false;

    public UserBitRenderer() {
        this._focusRenderer.setBorder(UNSELECTED_BORDER);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 3));
        buttonPanel.setBorder(new EmptyBorder(0, 0, 0, 5));
        buttonPanel.setBackground(null);
        this._upLabel = new JLabel();
        this._downLabel = new JLabel();
        this._removeLabel = new JLabel();
        buttonPanel.add(this._upLabel);
        buttonPanel.add(this._downLabel);
        buttonPanel.add(this._removeLabel);
        this._focusRenderer.add((Component)buttonPanel, "East");
        SwingUtilities.invokeLater(new ButtonIconLoader());
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int hoverIndex;
        Component renderer = this._delegate.getListCellRendererComponent(list, value, index, false, false);
        UserBit userBit = (UserBit)value;
        PipeBitPainter.getInstance().paintObject(renderer, userBit.getPipeBitInfo(), false);
        if (renderer instanceof JLabel) {
            ((JLabel)renderer).setText(userBit.getBitName());
        }
        if (SUSPEND_BUTTONS || userBit.getPipeBitInfo().role() == PipeBitInfo.Role.READER) {
            if (isSelected && renderer instanceof JComponent) {
                ((JComponent)renderer).setBorder(SELECTED_BORDER);
            }
            return renderer;
        }
        Point p = list.getMousePosition();
        if (p != null && (hoverIndex = list.locationToIndex(p)) == index) {
            this._focusRenderer.add(renderer, "Center");
            if (isSelected) {
                this._focusRenderer.setBorder(SELECTED_BORDER);
            } else {
                this._focusRenderer.setBorder(UNSELECTED_BORDER);
            }
            return this._focusRenderer;
        }
        if (isSelected && renderer instanceof JComponent) {
            ((JComponent)renderer).setBorder(SELECTED_BORDER);
        }
        return renderer;
    }

    private final class ButtonIconLoader
    implements Runnable {
        private ButtonIconLoader() {
        }

        @Override
        public void run() {
            String dir = "org/apache/ctakes/gui/pipeline/icon/";
            String upFile = "BlueUp.png";
            String downFile = "BlueDown.png";
            String removeFile = "RedCircleNo.png";
            Icon upIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueUp.png", 20);
            Icon downIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueDown.png", 20);
            Icon removeIcon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/RedCircleNo.png", 20);
            UserBitRenderer.this._upLabel.setIcon(upIcon);
            UserBitRenderer.this._downLabel.setIcon(downIcon);
            UserBitRenderer.this._removeLabel.setIcon(removeIcon);
        }
    }
}

