/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.user;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.gui.pipeline.bit.BitInfoPanel;
import org.apache.ctakes.gui.pipeline.bit.parameter.ParameterInfoPanel;
import org.apache.ctakes.gui.pipeline.bit.user.UserBit;
import org.apache.ctakes.gui.pipeline.bit.user.UserParameterInfoPanel;
import org.apache.log4j.Logger;

public final class UserBitInfoPanel
extends BitInfoPanel {
    private static final Logger LOGGER = Logger.getLogger((String)"UserBitInfoPanel");
    private BitNameListener _bitNameListener = new BitNameListener();

    public void setUserBitList(JList<UserBit> userBitList) {
        userBitList.getSelectionModel().addListSelectionListener(new UserBitListListener(userBitList));
    }

    @Override
    protected String getNameLabelPrefix() {
        return "User";
    }

    @Override
    protected JComponent createNameEditor() {
        this._bitNameListener = new BitNameListener();
        JTextField textField = new JTextField();
        textField.addActionListener(this._bitNameListener);
        return textField;
    }

    @Override
    protected void setBitName(String text, String toolTip) {
        ((JTextComponent)this._name).setText(text);
        this._name.setToolTipText(toolTip);
    }

    @Override
    protected ParameterInfoPanel createParameterInfoPanel() {
        return new UserParameterInfoPanel();
    }

    @Override
    protected void clear() {
        this._bitNameListener.setUserBit(null);
        super.clear();
    }

    private void setUserBit(UserBit userBit) {
        if (userBit == null) {
            this.clear();
            return;
        }
        this._pipeBitInfo = userBit.getPipeBitInfo();
        this._pipeBitClass = userBit.getPipeBitClass();
        this._bitNameListener.setUserBit(null);
        this.setBitName(this._pipeBitInfo.name(), this._pipeBitClass.getName());
        this.setLabelText(this._description, this._pipeBitInfo.description(), this._pipeBitInfo.description());
        String dependencies = Arrays.stream(this._pipeBitInfo.dependencies()).map(PipeBitInfo.TypeProduct::toString).collect(Collectors.joining(", "));
        this.setLabelText(this._dependencies, dependencies, dependencies);
        String usables = Arrays.stream(this._pipeBitInfo.usables()).map(PipeBitInfo.TypeProduct::toString).collect(Collectors.joining(", "));
        this.setLabelText(this._usables, usables, usables);
        String products = Arrays.stream(this._pipeBitInfo.products()).map(PipeBitInfo.TypeProduct::toString).collect(Collectors.joining(", "));
        this.setLabelText(this._products, products, products);
        this._parameterTableModel.setParameterHolder(userBit);
        this._parameterInfoPanel.setParameterHolder(userBit);
        this._bitNameListener.setUserBit(userBit);
    }

    private class BitNameListener
    implements ActionListener {
        private UserBit __userBit;

        private BitNameListener() {
        }

        private void setUserBit(UserBit userBit) {
            this.__userBit = userBit;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (this.__userBit != null) {
                this.__userBit.setBitName(((JTextComponent)UserBitInfoPanel.this._name).getText());
            }
        }
    }

    private class UserBitListListener
    implements ListSelectionListener {
        private final JList<UserBit> __userBitList;

        private UserBitListListener(JList<UserBit> userBitList) {
            this.__userBitList = userBitList;
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            if (event.getValueIsAdjusting()) {
                return;
            }
            UserBit userBit = this.__userBitList.getSelectedValue();
            UserBitInfoPanel.this.setUserBit(userBit);
        }
    }
}

