/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit.available;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.util.logging.Logger;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.apache.ctakes.gui.component.CellRendererPanel;
import org.apache.ctakes.gui.pipeline.bit.PipeBitPainter;
import org.apache.ctakes.gui.util.IconLoader;

public final class AvailablesRenderer
implements ListCellRenderer<Object> {
    private static final Logger LOGGER = Logger.getLogger("AvailablesRenderer");
    private static final Border SELECTED_BORDER = new LineBorder(Color.DARK_GRAY, 1, true);
    private static final Border UNSELECTED_BORDER = new EmptyBorder(0, 0, 0, 5);
    private final ListCellRenderer<Object> _delegate = new DefaultListCellRenderer();
    private JLabel _arrowLabel;
    private final JPanel _focusRenderer = new CellRendererPanel(new BorderLayout());

    public AvailablesRenderer() {
        this._focusRenderer.setBorder(new EmptyBorder(0, 0, 0, 5));
        this._arrowLabel = new JLabel();
        this._focusRenderer.add((Component)this._arrowLabel, "East");
        SwingUtilities.invokeLater(new RightArrowIconLoader());
    }

    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int hoverIndex;
        Component renderer = this._delegate.getListCellRendererComponent(list, value, index, false, false);
        PipeBitPainter.getInstance().paintObject(renderer, value, false);
        Point p = list.getMousePosition();
        if (p != null && (hoverIndex = list.locationToIndex(p)) == index) {
            this._focusRenderer.add(renderer, "Center");
            if (isSelected) {
                this._focusRenderer.setBorder(SELECTED_BORDER);
            } else {
                this._focusRenderer.setBorder(UNSELECTED_BORDER);
            }
            return this._focusRenderer;
        }
        if (isSelected && renderer instanceof JComponent) {
            ((JComponent)renderer).setBorder(SELECTED_BORDER);
        }
        return renderer;
    }

    private final class RightArrowIconLoader
    implements Runnable {
        private RightArrowIconLoader() {
        }

        @Override
        public void run() {
            String dir = "org/apache/ctakes/gui/pipeline/icon/";
            String file = "BlueRightArrow.png";
            Icon icon = IconLoader.loadIcon("org/apache/ctakes/gui/pipeline/icon/BlueRightArrow.png");
            AvailablesRenderer.this._arrowLabel.setIcon(icon);
        }
    }
}

