/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.gui.pipeline.bit;

import io.github.lukehutch.fastclasspathscanner.FastClasspathScanner;
import io.github.lukehutch.fastclasspathscanner.ScanInterruptedException;
import io.github.lukehutch.fastclasspathscanner.matchprocessor.SubclassMatchProcessor;
import io.github.lukehutch.fastclasspathscanner.scanner.ScanResult;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.ctakes.core.util.DotLogger;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_component.Annotator_ImplBase;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.collection.CasConsumer_ImplBase;
import org.apache.uima.collection.CollectionReader_ImplBase;

public enum PipeBitFinder {
    INSTANCE;

    private final Logger LOGGER = Logger.getLogger((String)"PipeBitFinder");
    private final Collection<Class<?>> _pipeBits = new ArrayList();
    private boolean _didScan = false;

    public static PipeBitFinder getInstance() {
        return INSTANCE;
    }

    public synchronized void reset() {
        this._pipeBits.clear();
        this._didScan = false;
    }

    public synchronized Collection<Class<?>> getPipeBits() {
        this.scan();
        return this._pipeBits;
    }

    private static boolean isPipeBit(Class<?> clazz) {
        String className = clazz.getName();
        return !className.startsWith("org.apache.uima.tutorial") && !className.startsWith("org.apache.uima.examples") && !Modifier.isAbstract(clazz.getModifiers()) && clazz.getEnclosingClass() == null;
    }

    public synchronized void scan() {
        if (this._didScan) {
            return;
        }
        SubclassMatchProcessor readerAdder = r -> {
            if (PipeBitFinder.isPipeBit(r)) {
                this._pipeBits.add(r);
            }
        };
        SubclassMatchProcessor annotatorAdder = a -> {
            if (PipeBitFinder.isPipeBit(a)) {
                this._pipeBits.add(a);
            }
        };
        SubclassMatchProcessor writerAdder = w -> {
            if (PipeBitFinder.isPipeBit(w)) {
                this._pipeBits.add(w);
            }
        };
        FastClasspathScanner scanner = new FastClasspathScanner(new String[0]);
        this.LOGGER.info((Object)"Starting Scan for Pipeline Bits");
        try (DotLogger dotter = new DotLogger();){
            scanner.matchSubclassesOf(CollectionReader_ImplBase.class, readerAdder).matchSubclassesOf(Annotator_ImplBase.class, annotatorAdder).matchSubclassesOf(CasConsumer_ImplBase.class, writerAdder);
            ScanResult scanResult = scanner.scan();
        }
        catch (ScanInterruptedException | IOException siE) {
            this.LOGGER.error((Object)siE.getMessage());
        }
        this._pipeBits.remove(CollectionReader_ImplBase.class);
        this._pipeBits.remove(JCasAnnotator_ImplBase.class);
        this._pipeBits.remove(CasConsumer_ImplBase.class);
        this._pipeBits.removeIf(c -> c.getPackage().getName().startsWith("org.cleartk") || c.getPackage().getName().startsWith("org.apache.uima"));
        this.LOGGER.info((Object)"Scan Finished");
        this._didScan = true;
    }
}

