/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex.uima.mapper;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.Collections2;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.SetMultimap;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPOutputStream;
import javax.sql.DataSource;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ctakes.ytex.dao.DBUtil;
import org.apache.ctakes.ytex.uima.mapper.AnnoMappingInfo;
import org.apache.ctakes.ytex.uima.mapper.ColumnMappingInfo;
import org.apache.ctakes.ytex.uima.mapper.DocumentMapperService;
import org.apache.ctakes.ytex.uima.model.Document;
import org.apache.ctakes.ytex.uima.model.DocumentAnnotation;
import org.apache.ctakes.ytex.uima.model.UimaType;
import org.apache.ctakes.ytex.uima.types.DocKey;
import org.apache.ctakes.ytex.uima.types.KeyValuePair;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.XmiCasSerializer;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.util.XMLSerializer;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.dialect.Dialect;
import org.hibernate.jdbc.Work;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DocumentMapperServiceImpl
implements DocumentMapperService,
InitializingBean {
    private static final Log log = LogFactory.getLog(DocumentMapperServiceImpl.class);
    private static Set<Integer> numericTypes = new HashSet<Integer>();
    private static Set<Integer> stringTypes = new HashSet<Integer>();
    private static final ThreadLocal<DateFormat> tlAnalysisBatchDateFormat = new ThreadLocal<DateFormat>(){

        @Override
        public DateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    };
    private Set<AnnoMappingInfo> annoMappingInfos;
    private int batchSize = 100;
    private DataSource dataSource;
    private String dbSchema;
    private String dbType;
    private Dialect dialect;
    private String dialectClassName;
    private CaseInsensitiveMap docTableCols = new CaseInsensitiveMap();
    private String formattedTableName = null;
    private JdbcTemplate jdbcTemplate;
    private Map<String, AnnoMappingInfo> mapAnnoMappingInfo = new HashMap<String, AnnoMappingInfo>();
    private SessionFactory sessionFactory;
    private ThreadLocal<Map<String, AnnoMappingInfo>> tl_mapAnnoMappingInfo = new ThreadLocal<Map<String, AnnoMappingInfo>>(){

        @Override
        protected Map<String, AnnoMappingInfo> initialValue() {
            return new HashMap<String, AnnoMappingInfo>();
        }
    };
    private ThreadLocal<SetMultimap<String, String>> tl_mapFieldInfo = new ThreadLocal<SetMultimap<String, String>>(){

        @Override
        protected SetMultimap<String, String> initialValue() {
            return HashMultimap.create();
        }
    };
    private PlatformTransactionManager transactionManager;
    private Map<String, UimaType> uimaTypeMap = new HashMap<String, UimaType>();
    private Properties ytexProperties;

    private void addAnnoLinks(JCas jcas, BiMap<Annotation, Integer> mapAnnoToId, List<AnnoLink> listAnnoLinks) {
        Collection annoLinkInfos = Collections2.filter(this.getMapAnnoMappingInfo().values(), (Predicate)new Predicate<AnnoMappingInfo>(){

            public boolean apply(AnnoMappingInfo mi) {
                return "anno_link".equalsIgnoreCase(mi.getTableName());
            }
        });
        for (AnnoMappingInfo mi : annoLinkInfos) {
            this.addAnnoLinks(jcas, mapAnnoToId, listAnnoLinks, mi);
        }
    }

    private void addAnnoLinks(JCas jcas, BiMap<Annotation, Integer> mapAnnoToId, List<AnnoLink> listAnnoLinks, AnnoMappingInfo mi) {
        Type t = jcas.getTypeSystem().getType(mi.getAnnoClassName());
        if (t != null) {
            ColumnMappingInfo cip = (ColumnMappingInfo)mi.getMapField().get("parent_anno_base_id");
            ColumnMappingInfo cic = (ColumnMappingInfo)mi.getMapField().get("child_anno_base_id");
            Feature fp = t.getFeatureByBaseName(cip.getAnnoFieldName());
            Feature fc = t.getFeatureByBaseName(cic.getAnnoFieldName());
            FSIterator iter = jcas.getFSIndexRepository().getAllIndexedFS(t);
            while (iter.hasNext()) {
                Integer parentId;
                Object parentAnno;
                FeatureStructure fs = (FeatureStructure)iter.next();
                FeatureStructure fsp = fs.getFeatureValue(fp);
                FeatureStructure fsc = fs.getFeatureValue(fc);
                if (fsp == null || fsc == null || !((parentAnno = this.extractFeature(cip.getJxpath(), fsp)) instanceof Annotation) || (parentId = (Integer)mapAnnoToId.get((Object)((Annotation)parentAnno))) == null) continue;
                if (fsc instanceof FSList || fsc instanceof FSArray) {
                    List<FeatureStructure> children = this.extractList(fsc);
                    for (FeatureStructure child : children) {
                        this.addLink(mapAnnoToId, listAnnoLinks, t.getShortName(), cic.getJxpath(), parentId, child);
                    }
                    continue;
                }
                this.addLink(mapAnnoToId, listAnnoLinks, t.getShortName(), cic.getJxpath(), parentId, fsc);
            }
        }
    }

    private void addLink(BiMap<Annotation, Integer> mapAnnoToId, List<AnnoLink> listAnnoLinks, String linkType, String childJxpath, Integer parentId, FeatureStructure child) {
        Integer childId;
        Object childAnno = this.extractFeature(childJxpath, child);
        if (childAnno instanceof Annotation && (childId = (Integer)mapAnnoToId.get((Object)((Annotation)childAnno))) != null) {
            listAnnoLinks.add(new AnnoLink(parentId, childId, linkType));
        }
    }

    public void afterPropertiesSet() {
        TransactionTemplate txTemplate = new TransactionTemplate(this.getTransactionManager());
        txTemplate.setPropagationBehavior(0);
        txTemplate.execute((TransactionCallback)new TransactionCallback<Object>(){

            public Object doInTransaction(TransactionStatus arg0) {
                Query q = DocumentMapperServiceImpl.this.getSessionFactory().getCurrentSession().getNamedQuery("getUimaTypes");
                List uimaTypes = q.list();
                for (UimaType uimaType : uimaTypes) {
                    DocumentMapperServiceImpl.this.uimaTypeMap.put(uimaType.getUimaTypeName(), uimaType);
                }
                DocumentMapperServiceImpl.this.initDocKeyMapping();
                return null;
            }
        });
    }

    private Document createDocument(JCas jcas, String analysisBatch, boolean bStoreDocText, boolean bStoreCAS) {
        Document doc = new Document();
        if (bStoreDocText) {
            doc.setDocText(jcas.getDocumentText());
        }
        doc.setAnalysisBatch(analysisBatch == null || analysisBatch.length() == 0 ? this.getDefaultAnalysisBatch() : analysisBatch);
        if (this.setUimaDocId(jcas, doc, "org.apache.ctakes.typesystem.type.structured.DocumentID", "documentID") == null) {
            this.setUimaDocId(jcas, doc, "org.apache.uima.examples.SourceDocumentInformation", "uri");
        }
        if (bStoreCAS) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                GZIPOutputStream zipOut = new GZIPOutputStream(out);
                XmiCasSerializer ser = new XmiCasSerializer(jcas.getTypeSystem());
                XMLSerializer xmlSer = new XMLSerializer((OutputStream)zipOut, false);
                ser.serialize(jcas.getCas(), xmlSer.getContentHandler());
                zipOut.close();
                doc.setCas(out.toByteArray());
            }
            catch (Exception saxException) {
                log.error((Object)"error serializing document cas", (Throwable)saxException);
            }
        }
        return doc;
    }

    private void extractAndSaveDocKey(JCas jcas, Document doc) {
        AnnotationIndex idx = jcas.getAnnotationIndex(DocKey.typeIndexID);
        FSIterator annoIterator = idx.iterator();
        if (annoIterator.hasNext()) {
            this.saveDocKey(doc, (DocKey)((Object)annoIterator.next()));
        }
    }

    private Object extractFeature(String jxpath, Object child) {
        return jxpath != null ? JXPathContext.newContext((Object)child).getValue(jxpath) : child;
    }

    private List<FeatureStructure> extractList(FeatureStructure fsc) {
        ArrayList<FeatureStructure> listFS;
        block3: {
            block4: {
                listFS = new ArrayList<FeatureStructure>();
                if (fsc == null) break block3;
                if (!(fsc instanceof FSArray)) break block4;
                FSArray fsa = (FSArray)fsc;
                for (int i = 0; i < fsa.size(); ++i) {
                    FeatureStructure fsElement = fsa.get(i);
                    if (fsElement == null) continue;
                    listFS.add(fsElement);
                }
                break block3;
            }
            if (!(fsc instanceof FSList)) break block3;
            FSList fsl = (FSList)fsc;
            while (fsl instanceof NonEmptyFSList) {
                TOP fsElement = ((NonEmptyFSList)fsl).getHead();
                if (fsElement != null) {
                    listFS.add((FeatureStructure)fsElement);
                }
                fsl = ((NonEmptyFSList)fsl).getTail();
            }
        }
        return listFS;
    }

    public Set<AnnoMappingInfo> getAnnoMappingInfos() {
        return this.annoMappingInfos;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public DataSource getDataSource() {
        return this.jdbcTemplate.getDataSource();
    }

    public String getDbSchema() {
        return this.dbSchema;
    }

    public String getDbType() {
        return this.dbType;
    }

    private String getDefaultAnalysisBatch() {
        return tlAnalysisBatchDateFormat.get().format(new Date());
    }

    public String getDialectClassName() {
        return this.dialectClassName;
    }

    public Map<String, AnnoMappingInfo> getMapAnnoMappingInfo() {
        return this.mapAnnoMappingInfo;
    }

    private AnnoMappingInfo getMapInfo(FeatureStructure fs) {
        Type type = fs.getType();
        String className = type.getName();
        AnnoMappingInfo mapInfo = null;
        if (this.tl_mapAnnoMappingInfo.get().containsKey(className)) {
            mapInfo = this.tl_mapAnnoMappingInfo.get().get(className);
        } else {
            mapInfo = this.initMapInfo(fs);
            this.tl_mapAnnoMappingInfo.get().put(className, mapInfo);
        }
        return mapInfo;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    private String getTablePrefix() {
        String tablePrefix = "";
        if ("mssql".equals(this.dbType)) {
            tablePrefix = this.dbSchema + ".";
        }
        return tablePrefix;
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public Properties getYtexProperties() {
        return this.ytexProperties;
    }

    public void initDocKeyMapping() {
        AbstractEntityPersister cm = (AbstractEntityPersister)this.sessionFactory.getClassMetadata(Document.class);
        String[] propNames = cm.getPropertyNames();
        TreeSet<String> mappedCols = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        for (String prop : propNames) {
            String[] cols = cm.getPropertyColumnNames(prop);
            mappedCols.addAll(Arrays.asList(cols));
        }
        this.formattedTableName = cm.getTableName();
        log.info((Object)("document table name = " + this.formattedTableName));
        String query = "select * from " + this.formattedTableName + " where 1=2";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(query);
            ResultSetMetaData rsmd = rs.getMetaData();
            int nCols = rsmd.getColumnCount();
            for (int i = 1; i <= nCols; ++i) {
                String colName = rsmd.getColumnName(i);
                if (mappedCols.contains(colName)) continue;
                log.info((Object)("document candidate foreign key column: " + colName));
                this.docTableCols.put((Object)colName, (Object)rsmd.getColumnType(i));
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("docTableCols: " + this.docTableCols));
            }
        }
        catch (SQLException e) {
            log.error((Object)"problem determining document table fields", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                if (conn != null) {
                    conn.close();
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private AnnoMappingInfo initMapInfo(final FeatureStructure fs) {
        Type type = fs.getType();
        String annoName = type.getShortName().toLowerCase();
        UimaType ut = this.uimaTypeMap.get(type.getName());
        AnnoMappingInfo mapInfoTmp = this.mapAnnoMappingInfo.containsKey(type.getName()) ? this.mapAnnoMappingInfo.get(type.getName()).deepCopy() : new AnnoMappingInfo();
        final AnnoMappingInfo mapInfo = mapInfoTmp;
        if (ut != null) {
            mapInfo.setUimaTypeId(ut.getUimaTypeID());
        }
        if (Strings.isNullOrEmpty((String)mapInfo.getTableName())) {
            if (ut != null && !Strings.isNullOrEmpty((String)ut.getTableName())) {
                mapInfo.setTableName(ut.getTableName());
            } else {
                mapInfo.setTableName("anno_" + annoName);
            }
        }
        final List features = type.getFeatures();
        for (Feature f : features) {
            if (!f.getRange().isArray() || f.getRange().getComponentType().isPrimitive()) continue;
            this.tl_mapFieldInfo.get().put((Object)type.getName(), (Object)f.getShortName());
        }
        this.sessionFactory.getCurrentSession().doWork(new Work(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void execute(Connection conn) throws SQLException {
                ResultSet rs = null;
                try {
                    DatabaseMetaData dmd = conn.getMetaData();
                    rs = dmd.getColumns(null, "mssql".equals(DocumentMapperServiceImpl.this.dbType) || "hsql".equals(DocumentMapperServiceImpl.this.dbType) ? DocumentMapperServiceImpl.this.dbSchema : null, "orcl".equals(DocumentMapperServiceImpl.this.dbType) || "hsql".equals(DocumentMapperServiceImpl.this.dbType) ? mapInfo.getTableName().toUpperCase() : mapInfo.getTableName(), null);
                    block7: while (rs.next()) {
                        String colName = rs.getString("COLUMN_NAME");
                        int colSize = rs.getInt("COLUMN_SIZE");
                        int dataType = rs.getInt("DATA_TYPE");
                        if ("anno_base_id".equalsIgnoreCase(colName)) continue;
                        if ("uima_type_id".equalsIgnoreCase(colName)) {
                            if (fs instanceof Annotation || !Strings.isNullOrEmpty((String)mapInfo.getUimaTypeIdColumnName())) continue;
                            mapInfo.setUimaTypeIdColumnName(colName);
                            continue;
                        }
                        if ("coveredText".equalsIgnoreCase(colName)) {
                            ColumnMappingInfo coveredTextColumn = new ColumnMappingInfo();
                            coveredTextColumn.setColumnName(colName);
                            mapInfo.setCoveredTextColumn(coveredTextColumn);
                            coveredTextColumn.setSize(colSize);
                            continue;
                        }
                        if (DocumentMapperServiceImpl.this.updateSize(mapInfo, colName, colSize, dataType)) continue;
                        for (Feature f : features) {
                            ColumnMappingInfo fmap;
                            String annoFieldName = f.getShortName();
                            if (f.getRange().isPrimitive() && annoFieldName.equalsIgnoreCase(colName)) {
                                fmap = new ColumnMappingInfo();
                                fmap.setAnnoFieldName(annoFieldName);
                                fmap.setColumnName(colName);
                                fmap.setSize(colSize);
                                fmap.setSqlType(dataType);
                                mapInfo.getMapField().put(colName, fmap);
                                continue block7;
                            }
                            if (f.getRange().isArray() || f.getRange().isPrimitive() || !annoFieldName.equalsIgnoreCase(colName) || dataType != 4 && dataType != 5 && dataType != -5 && dataType != 2 && dataType != 6 && dataType != 8) continue;
                            fmap = new ColumnMappingInfo();
                            fmap.setAnnoFieldName(annoFieldName);
                            fmap.setColumnName(colName);
                            fmap.setSize(colSize);
                            fmap.setSqlType(dataType);
                            mapInfo.getMapField().put(colName, fmap);
                            continue block7;
                        }
                    }
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
        if (mapInfo.getMapField().size() == 0 && mapInfo.getCoveredTextColumn() == null && Strings.isNullOrEmpty((String)mapInfo.getUimaTypeIdColumnName())) {
            return null;
        }
        StringBuilder b = new StringBuilder("insert into ");
        b.append(this.getTablePrefix()).append(mapInfo.getTableName());
        b.append("(anno_base_id");
        if (mapInfo.getCoveredTextColumn() != null) {
            b.append(", coveredText");
        }
        if (mapInfo.getUimaTypeIdColumnName() != null) {
            b.append(", uima_type_id");
        }
        for (Map.Entry<String, ColumnMappingInfo> fieldEntry : mapInfo.getMapField().entrySet()) {
            b.append(", ").append(this.dialect.openQuote()).append(fieldEntry.getValue().getColumnName()).append(this.dialect.closeQuote());
        }
        b.append(") values (?");
        if (mapInfo.getCoveredTextColumn() != null) {
            b.append(", ?");
        }
        if (mapInfo.getUimaTypeIdColumnName() != null) {
            b.append(", ?");
        }
        b.append(Strings.repeat((String)", ?", (int)mapInfo.getMapField().size())).append(")");
        mapInfo.setSql(b.toString());
        if (log.isInfoEnabled()) {
            log.info((Object)("sql insert for type " + type.getName() + ": " + mapInfo.getSql()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("initMapInfo(" + annoName + "): " + mapInfo));
        }
        return mapInfo;
    }

    private void insertAnnotationContainmentLinks(int documentId) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"begin insertAnnotationContainmentLinks");
        }
        Query q = this.sessionFactory.getCurrentSession().getNamedQuery("insertAnnotationContainmentLinks");
        q.setInteger("documentID", documentId);
        q.executeUpdate();
        if (log.isTraceEnabled()) {
            log.trace((Object)"end insertAnnotationContainmentLinks");
        }
    }

    private BiMap<Annotation, Integer> saveAnnoBase(JCas jcas, final Set<String> setTypesToIgnore, final int docId) {
        AnnotationIndex annoIdx = jcas.getAnnotationIndex(Annotation.typeIndexID);
        final ArrayList listAnno = new ArrayList(annoIdx.size());
        HashBiMap mapAnnoToId = HashBiMap.create();
        final FSIterator annoIterator = annoIdx.iterator();
        this.sessionFactory.getCurrentSession().doWork(new Work((BiMap)mapAnnoToId){
            final /* synthetic */ BiMap val$mapAnnoToId;
            {
                this.val$mapAnnoToId = biMap;
            }

            public void execute(Connection conn) throws SQLException {
                Statement ps = null;
                ResultSet rs = null;
                try {
                    ps = conn.prepareStatement("insert into " + DocumentMapperServiceImpl.this.getTablePrefix() + "anno_base (document_id, span_begin, span_end, uima_type_id) values (?, ?, ?, ?)", 1);
                    while (annoIterator.hasNext()) {
                        Annotation anno = (Annotation)annoIterator.next();
                        String annoClass = anno.getClass().getName();
                        if (setTypesToIgnore.contains(annoClass) || !DocumentMapperServiceImpl.this.uimaTypeMap.containsKey(annoClass)) continue;
                        listAnno.add(anno);
                        ps.setInt(1, docId);
                        ps.setInt(2, anno.getBegin());
                        ps.setInt(3, anno.getEnd());
                        ps.setInt(4, ((UimaType)DocumentMapperServiceImpl.this.uimaTypeMap.get(annoClass)).getUimaTypeID());
                        ps.addBatch();
                    }
                    ps.executeBatch();
                    rs = ps.getGeneratedKeys();
                    int annoIndex = 0;
                    while (rs.next()) {
                        this.val$mapAnnoToId.put(listAnno.get(annoIndex), (Object)rs.getInt(1));
                        ++annoIndex;
                    }
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (rs != null) {
                        try {
                            rs.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            }
        });
        return mapAnnoToId;
    }

    private BiMap<Annotation, Integer> saveAnnoBaseHib(JCas jcas, Set<String> setTypesToIgnore, Document doc) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"begin saveAnnoBaseHib");
        }
        AnnotationIndex annoIdx = jcas.getAnnotationIndex(Annotation.typeIndexID);
        ArrayList<Annotation> listAnno = new ArrayList<Annotation>(annoIdx.size());
        HashMap<Annotation, DocumentAnnotation> mapAnnoToHib = new HashMap<Annotation, DocumentAnnotation>();
        FSIterator annoIterator = annoIdx.iterator();
        int count = 0;
        while (annoIterator.hasNext()) {
            Annotation anno = (Annotation)annoIterator.next();
            String annoClass = anno.getClass().getName();
            if (setTypesToIgnore.contains(annoClass) || !this.uimaTypeMap.containsKey(annoClass)) continue;
            listAnno.add(anno);
            DocumentAnnotation hibAnno = new DocumentAnnotation();
            hibAnno.setDocument(doc);
            hibAnno.setBegin(anno.getBegin());
            hibAnno.setEnd(anno.getEnd());
            hibAnno.setUimaType(this.uimaTypeMap.get(annoClass));
            this.sessionFactory.getCurrentSession().save((Object)hibAnno);
            if (++count % this.batchSize == 0) {
                this.sessionFactory.getCurrentSession().flush();
            }
            doc.getDocumentAnnotations().add(hibAnno);
            mapAnnoToHib.put(anno, hibAnno);
        }
        this.sessionFactory.getCurrentSession().flush();
        HashBiMap mapAnnoToId = HashBiMap.create();
        for (Map.Entry e : mapAnnoToHib.entrySet()) {
            mapAnnoToId.put(e.getKey(), (Object)((DocumentAnnotation)e.getValue()).getDocumentAnnotationID());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"end saveAnnoBaseHib");
        }
        return mapAnnoToId;
    }

    private void saveAnnoBindVariables(Type type, AnnoMappingInfo mapInfo, PreparedStatement ps, int annoId, FeatureStructure anno, BiMap<Annotation, Integer> mapAnnoToId) throws SQLException {
        int argIdx = 1;
        ps.setInt(argIdx++, annoId);
        if (mapInfo.getCoveredTextColumn() != null) {
            String trunc = null;
            if (anno instanceof Annotation) {
                trunc = this.truncateString(((Annotation)anno).getCoveredText(), mapInfo.getCoveredTextColumn().getSize());
            }
            ps.setString(argIdx++, trunc);
        }
        if (!Strings.isNullOrEmpty((String)mapInfo.getUimaTypeIdColumnName())) {
            ps.setInt(argIdx++, mapInfo.getUimaTypeId());
        }
        for (Map.Entry<String, ColumnMappingInfo> fieldEntry : mapInfo.getMapField().entrySet()) {
            ColumnMappingInfo fieldMapInfo = fieldEntry.getValue();
            String fieldName = fieldMapInfo.getAnnoFieldName();
            Feature feat = type.getFeatureByBaseName(fieldName);
            if (fieldMapInfo.getConverter() != null) {
                try {
                    String prop = anno.getFeatureValueAsString(feat);
                    ps.setObject(argIdx, fieldMapInfo.getConverter().convert(fieldMapInfo.getTargetType(), (Object)prop));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            } else if (!feat.getRange().isPrimitive()) {
                FeatureStructure fs = anno.getFeatureValue(feat);
                if (fs == null) {
                    ps.setNull(argIdx, fieldMapInfo.getSqlType());
                } else if (fieldMapInfo.getJxpath() != null) {
                    Object o = this.extractFeature(fieldMapInfo.getJxpath(), fs);
                    if (o == null) {
                        ps.setNull(argIdx, fieldMapInfo.getSqlType());
                    } else if (o instanceof String) {
                        String trunc = this.truncateString((String)o, fieldMapInfo.getSize());
                        ps.setString(argIdx, trunc);
                    } else {
                        ps.setObject(argIdx, o);
                    }
                } else {
                    Integer refAnnoId = null;
                    if (fs instanceof Annotation) {
                        refAnnoId = (Integer)mapAnnoToId.get((Object)fs);
                    }
                    if (refAnnoId != null) {
                        ps.setInt(argIdx, refAnnoId);
                    } else {
                        ps.setNull(argIdx, 4);
                    }
                }
            } else if ("uima.cas.Integer".equals(feat.getRange().getName())) {
                ps.setInt(argIdx, anno.getIntValue(feat));
            } else if ("uima.cas.Short".equals(feat.getRange().getName())) {
                ps.setShort(argIdx, anno.getShortValue(feat));
            } else if ("uima.cas.Long".equals(feat.getRange().getName())) {
                ps.setLong(argIdx, anno.getLongValue(feat));
            } else if ("uima.cas.Float".equals(feat.getRange().getName())) {
                ps.setFloat(argIdx, anno.getFloatValue(feat));
            } else if ("uima.cas.Double".equals(feat.getRange().getName())) {
                ps.setDouble(argIdx, anno.getDoubleValue(feat));
            } else if ("uima.cas.Byte".equals(feat.getRange().getName())) {
                ps.setByte(argIdx, anno.getByteValue(feat));
            } else if ("uima.cas.Boolean".equals(feat.getRange().getName())) {
                ps.setBoolean(argIdx, anno.getBooleanValue(feat));
            } else if ("uima.cas.String".equals(feat.getRange().getName())) {
                String trunc = this.truncateString(anno.getStringValue(feat), fieldMapInfo.getSize());
                ps.setString(argIdx, trunc);
            }
            ++argIdx;
        }
    }

    private void saveAnnoFS(List<AnnoFSAttribute> listFSA, final BiMap<Annotation, Integer> mapAnnoToId) {
        if (listFSA.size() == 0) {
            return;
        }
        FeatureStructure fs = listFSA.get(0).getFs();
        final Type type = fs.getType();
        final AnnoMappingInfo mapInfo = this.getMapInfo(fs);
        if (mapInfo == null) {
            return;
        }
        this.chunkedBatchUpdate(mapInfo.getSql(), listFSA, new ChunkPreparedStatementSetter<AnnoFSAttribute>(){

            @Override
            public void setValues(PreparedStatement ps, int idx, AnnoFSAttribute fsa) throws SQLException {
                DocumentMapperServiceImpl.this.saveAnnoBindVariables(type, mapInfo, ps, fsa.getAnnoBaseId(), fsa.getFs(), (BiMap<Annotation, Integer>)mapAnnoToId);
            }
        });
    }

    private <T> void chunkedBatchUpdate(String sql, List<T> l, final ChunkPreparedStatementSetter<T> cpss) {
        int chunks = (int)Math.ceil((double)l.size() / (double)this.batchSize);
        for (int i = 0; i < chunks; ++i) {
            int start = i * this.batchSize;
            int end = (i + 1) * this.batchSize;
            if (end > l.size()) {
                end = l.size();
            }
            final List<T> chunkList = l.subList(start, end);
            this.jdbcTemplate.batchUpdate(sql, new BatchPreparedStatementSetter(){

                public int getBatchSize() {
                    return chunkList.size();
                }

                public void setValues(PreparedStatement ps, int idx) throws SQLException {
                    Object record = chunkList.get(idx);
                    cpss.setValues(ps, idx, record);
                }
            });
        }
    }

    private void saveAnnoLinks(List<AnnoLink> listAnnoLinks) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"begin saveAnnoLinks");
        }
        this.chunkedBatchUpdate("insert into " + this.getTablePrefix() + "anno_link(parent_anno_base_id, child_anno_base_id, feature) values (?, ?, ?)", listAnnoLinks, new ChunkPreparedStatementSetter<AnnoLink>(){

            @Override
            public void setValues(PreparedStatement ps, int idx, AnnoLink l) throws SQLException {
                ps.setInt(1, l.getParentAnnoBaseId());
                ps.setInt(2, l.getChildAnnoBaseId());
                ps.setString(3, l.getFeature());
            }
        });
        if (log.isTraceEnabled()) {
            log.trace((Object)"end saveAnnoLinks");
        }
    }

    private void saveAnnoPrimitive(final BiMap<Annotation, Integer> mapAnnoToId, Set<Integer> annoIds, final List<AnnoLink> listAnnoLinks) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"begin saveAnnoPrimitive");
        }
        final BiMap mapIdToAnno = mapAnnoToId.inverse();
        if (annoIds.size() == 0) {
            return;
        }
        ArrayList<Integer> annoIdList = new ArrayList<Integer>(annoIds);
        TOP t = (TOP)mapIdToAnno.get(annoIdList.get(0));
        final Type type = t.getType();
        final AnnoMappingInfo mapInfo = this.getMapInfo((FeatureStructure)t);
        final Set fsNames = this.tl_mapFieldInfo.get().get((Object)type.getName());
        ArrayListMultimap mapAnnoToFS = ArrayListMultimap.create();
        if (mapInfo == null) {
            return;
        }
        this.chunkedBatchUpdate(mapInfo.getSql(), annoIdList, new ChunkPreparedStatementSetter<Integer>((ListMultimap)mapAnnoToFS){
            final /* synthetic */ ListMultimap val$mapAnnoToFS;
            {
                this.val$mapAnnoToFS = listMultimap;
            }

            @Override
            public void setValues(PreparedStatement ps, int idx, Integer annoId) throws SQLException {
                Annotation anno = (Annotation)mapIdToAnno.get((Object)annoId);
                DocumentMapperServiceImpl.this.saveAnnoBindVariables(type, mapInfo, ps, annoId, (FeatureStructure)anno, (BiMap<Annotation, Integer>)mapAnnoToId);
                for (String fieldName : fsNames) {
                    Feature feat = type.getFeatureByBaseName(fieldName);
                    if (!feat.getRange().isPrimitive()) {
                        FeatureStructure fsCol = anno.getFeatureValue(feat);
                        if (fsCol == null || !(fsCol instanceof FSArray) && !(fsCol instanceof FSList)) continue;
                        List fsList = DocumentMapperServiceImpl.this.extractList(fsCol);
                        int i = 0;
                        for (FeatureStructure fs : fsList) {
                            if (fs instanceof Annotation) {
                                Integer childAnnoId = (Integer)mapAnnoToId.get((Object)fs);
                                if (childAnnoId == null) continue;
                                listAnnoLinks.add(new AnnoLink(annoId, childAnnoId, feat.getShortName()));
                                continue;
                            }
                            this.val$mapAnnoToFS.put((Object)fs.getType().getName(), (Object)new AnnoFSAttribute(annoId, fs, i++));
                        }
                        continue;
                    }
                    this.val$mapAnnoToFS.put((Object)feat.getRange().getName(), (Object)new AnnoFSAttribute(annoId, anno.getFeatureValue(feat), null));
                }
            }
        });
        for (String fsType : mapAnnoToFS.keySet()) {
            this.saveAnnoFS(mapAnnoToFS.get((Object)fsType), mapAnnoToId);
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)"end saveAnnoPrimitive");
        }
    }

    private void saveAnnotationsHib(JCas jcas, boolean bInsertAnnotationContainmentLinks, Set<String> setTypesToIgnore, Document doc) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"begin saveAnnotationsHib");
        }
        BiMap<Annotation, Integer> mapAnnoToId = this.saveAnnoBaseHib(jcas, setTypesToIgnore, doc);
        if (bInsertAnnotationContainmentLinks) {
            this.insertAnnotationContainmentLinks(doc.getDocumentID());
        }
        HashMultimap mapTypeToAnnoId = HashMultimap.create();
        for (Map.Entry annoEntry : mapAnnoToId.entrySet()) {
            mapTypeToAnnoId.put((Object)((Annotation)annoEntry.getKey()).getClass().getName(), annoEntry.getValue());
        }
        ArrayList<AnnoLink> listAnnoLinks = new ArrayList<AnnoLink>();
        for (String annoClass : mapTypeToAnnoId.keySet()) {
            this.saveAnnoPrimitive(mapAnnoToId, mapTypeToAnnoId.get((Object)annoClass), listAnnoLinks);
        }
        this.addAnnoLinks(jcas, mapAnnoToId, listAnnoLinks);
        this.saveAnnoLinks(listAnnoLinks);
        if (log.isTraceEnabled()) {
            log.trace((Object)"end saveAnnotationsHib");
        }
    }

    private void saveDocKey(Document document, DocKey dk) {
        int documentId = document.getDocumentID();
        FSArray fsa = dk.getKeyValuePairs();
        if (fsa == null || fsa.size() == 0) {
            return;
        }
        StringBuilder queryBuilder = new StringBuilder("update ").append(this.formattedTableName).append(" set ");
        ArrayList<Object> args = new ArrayList<Object>();
        boolean bFirstArg = true;
        for (int i = 0; i < fsa.size(); ++i) {
            KeyValuePair kp = (KeyValuePair)fsa.get(i);
            String key = kp.getKey();
            if (key.equalsIgnoreCase("instance_id")) {
                document.setInstanceID(kp.getValueLong());
                continue;
            }
            if (key.equalsIgnoreCase("instance_key")) {
                document.setInstanceKey(kp.getValueString());
                continue;
            }
            if (this.docTableCols.containsKey((Object)key)) {
                boolean badArg = false;
                if (kp.getValueString() != null && stringTypes.contains(this.docTableCols.get((Object)key))) {
                    args.add(kp.getValueString());
                } else if (numericTypes.contains(this.docTableCols.get((Object)key))) {
                    args.add(kp.getValueLong());
                } else {
                    badArg = true;
                    log.warn("document_id: " + documentId + ", bad type for key=" + key + ", value=" + kp.getValueString() == null ? Long.valueOf(kp.getValueLong()) : kp.getValueString());
                }
                if (badArg) continue;
                if (!bFirstArg) {
                    queryBuilder.append(", ");
                }
                queryBuilder.append(DBUtil.formatFieldName((String)key));
                queryBuilder.append("=? ");
                bFirstArg = false;
                continue;
            }
            log.warn((Object)("document_id: " + documentId + ", could not map key attribute " + kp.getKey()));
        }
        if (args.size() > 0) {
            queryBuilder.append(" where document_id = ?");
            args.add(documentId);
            String sql = queryBuilder.toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)sql);
            }
            this.jdbcTemplate.update(sql, args.toArray());
        }
    }

    @Override
    public Integer saveDocument(final JCas jcas, final String analysisBatch, final boolean bStoreDocText, final boolean bStoreCAS, final boolean bInsertAnnotationContainmentLinks, final Set<String> setTypesToIgnore) {
        if (log.isTraceEnabled()) {
            log.trace((Object)"begin saveDocument");
        }
        DefaultTransactionDefinition txDef = new DefaultTransactionDefinition(3);
        txDef.setIsolationLevel("orcl".equals(this.dbType) ? 2 : 1);
        TransactionTemplate txTemplate = new TransactionTemplate(this.getTransactionManager(), (TransactionDefinition)txDef);
        int documentId = (Integer)txTemplate.execute((TransactionCallback)new TransactionCallback<Integer>(){

            public Integer doInTransaction(TransactionStatus arg0) {
                Document doc = DocumentMapperServiceImpl.this.createDocument(jcas, analysisBatch, bStoreDocText, bStoreCAS);
                DocumentMapperServiceImpl.this.sessionFactory.getCurrentSession().save((Object)doc);
                DocumentMapperServiceImpl.this.getSessionFactory().getCurrentSession().flush();
                DocumentMapperServiceImpl.this.saveAnnotationsHib(jcas, bInsertAnnotationContainmentLinks, setTypesToIgnore, doc);
                DocumentMapperServiceImpl.this.extractAndSaveDocKey(jcas, doc);
                return doc.getDocumentID();
            }
        });
        if (log.isTraceEnabled()) {
            log.trace((Object)"end saveDocument");
        }
        return documentId;
    }

    public void setAnnoMappingInfos(Set<AnnoMappingInfo> annoMappingInfos) {
        this.annoMappingInfos = annoMappingInfos;
        for (AnnoMappingInfo mi : annoMappingInfos) {
            this.mapAnnoMappingInfo.put(mi.getAnnoClassName(), mi);
        }
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        this.jdbcTemplate = new JdbcTemplate(dataSource);
    }

    public void setDbSchema(String dbSchema) {
        this.dbSchema = dbSchema;
    }

    public void setDbType(String dbType) {
        this.dbType = dbType;
    }

    public void setDialectClassName(String dialectClassName) {
        this.dialectClassName = dialectClassName;
        try {
            this.dialect = (Dialect)Class.forName(dialectClassName).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setMapAnnoMappingInfo(Map<String, AnnoMappingInfo> mapAnnoMappingInfo) {
        this.mapAnnoMappingInfo = mapAnnoMappingInfo;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void setTransactionManager(PlatformTransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    private String setUimaDocId(JCas jcas, Document doc, String idType, String idFeature) {
        FeatureStructure docId;
        String uimaDocId;
        FSIterator iter;
        Type docIDtype = jcas.getTypeSystem().getType(idType);
        Feature docIDFeature = null;
        if (docIDtype != null) {
            docIDFeature = docIDtype.getFeatureByBaseName(idFeature);
        }
        if (docIDtype != null && docIDFeature != null && (iter = jcas.getFSIndexRepository().getAllIndexedFS(docIDtype)) != null && iter.hasNext() && !Strings.isNullOrEmpty((String)(uimaDocId = (docId = (FeatureStructure)iter.next()).getStringValue(docIDFeature)))) {
            uimaDocId = this.truncateString(uimaDocId, 256);
            doc.setInstanceKey(uimaDocId);
            return uimaDocId;
        }
        return null;
    }

    public void setYtexProperties(Properties ytexProperties) {
        this.ytexProperties = ytexProperties;
    }

    private String truncateString(String val, int size) {
        String trunc = val;
        if (!Strings.isNullOrEmpty((String)val) && val.length() > size) {
            trunc = val.substring(0, size);
        }
        return trunc;
    }

    private boolean updateSize(AnnoMappingInfo mapInfo, String colName, int colSize, int sqlType) {
        ColumnMappingInfo fi = (ColumnMappingInfo)mapInfo.getMapField().get(colName);
        if (fi != null) {
            fi.setSqlType(sqlType);
            if (fi.getSize() <= 0) {
                fi.setSize(colSize);
            }
            return true;
        }
        return false;
    }

    static {
        stringTypes.addAll(Arrays.asList(1, -15, 12, -9));
        numericTypes.addAll(Arrays.asList(-5, -7, 16, -6, 5, 3, 6, 8, 4));
    }

    public static interface ChunkPreparedStatementSetter<T> {
        public void setValues(PreparedStatement var1, int var2, T var3) throws SQLException;
    }

    public static class AnnoLink {
        private int childAnnoBaseId;
        private String feature;
        private int parentAnnoBaseId;

        public AnnoLink(int annoId, int childAnnoId, String feature) {
            this.parentAnnoBaseId = annoId;
            this.childAnnoBaseId = childAnnoId;
            this.feature = feature;
        }

        public int getChildAnnoBaseId() {
            return this.childAnnoBaseId;
        }

        public String getFeature() {
            return this.feature;
        }

        public int getParentAnnoBaseId() {
            return this.parentAnnoBaseId;
        }

        public void setChildAnnoBaseId(int childAnnoBaseId) {
            this.childAnnoBaseId = childAnnoBaseId;
        }

        public void setFeature(String feature) {
            this.feature = feature;
        }

        public void setParentAnnoBaseId(int parentAnnoBaseId) {
            this.parentAnnoBaseId = parentAnnoBaseId;
        }
    }

    public static class AnnoFSAttribute {
        private int annoBaseId;
        private FeatureStructure fs;
        private Integer index;

        public AnnoFSAttribute() {
        }

        public AnnoFSAttribute(int annoBaseId, FeatureStructure fs, Integer index) {
            this.annoBaseId = annoBaseId;
            this.fs = fs;
            this.index = index;
        }

        public int getAnnoBaseId() {
            return this.annoBaseId;
        }

        public FeatureStructure getFs() {
            return this.fs;
        }

        public Integer getIndex() {
            return this.index;
        }

        public void setAnnoBaseId(int annoBaseId) {
            this.annoBaseId = annoBaseId;
        }

        public void setFs(FeatureStructure fs) {
            this.fs = fs;
        }

        public void setIndex(Integer index) {
            this.index = index;
        }
    }
}

