/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.websocket.api.UpgradeResponse;
import org.eclipse.jetty.websocket.api.extensions.ExtensionConfig;

public class ServletUpgradeResponse
extends UpgradeResponse {
    private HttpServletResponse resp;
    private boolean extensionsNegotiated = false;
    private boolean subprotocolNegotiated = false;

    public ServletUpgradeResponse(HttpServletResponse resp) {
        this.resp = resp;
    }

    @Override
    public void addHeader(String name, String value) {
        this.resp.addHeader(name, value);
    }

    @Override
    public int getStatusCode() {
        return this.resp.getStatus();
    }

    @Override
    public String getStatusReason() {
        throw new UnsupportedOperationException("Server cannot get Status Reason Message");
    }

    public boolean isCommitted() {
        return this.resp.isCommitted();
    }

    public boolean isExtensionsNegotiated() {
        return this.extensionsNegotiated;
    }

    public boolean isSubprotocolNegotiated() {
        return this.subprotocolNegotiated;
    }

    public void sendError(int statusCode, String message) throws IOException {
        this.setSuccess(false);
        this.resp.sendError(statusCode, message);
    }

    @Override
    public void sendForbidden(String message) throws IOException {
        this.setSuccess(false);
        this.resp.sendError(403, message);
    }

    @Override
    public void setAcceptedSubProtocol(String protocol) {
        super.setAcceptedSubProtocol(protocol);
        this.subprotocolNegotiated = true;
    }

    @Override
    public void setExtensions(List<ExtensionConfig> extensions) {
        super.setExtensions(extensions);
        this.extensionsNegotiated = true;
    }

    @Override
    public void setHeader(String name, String value) {
        this.resp.setHeader(name, value);
    }

    public void setStatus(int status) {
        this.resp.setStatus(status);
    }
}

