/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.keras;

import com.google.common.annotations.Beta;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.ctakes.temporal.keras.KerasStringOutcomeClassifier;
import org.apache.ctakes.temporal.keras.ScriptStringOutcomeClassifier;
import org.apache.ctakes.temporal.keras.ScriptStringOutcomeClassifierBuilder;
import org.apache.uima.util.Level;
import org.cleartk.ml.encoder.features.FeaturesEncoder;
import org.cleartk.ml.encoder.outcome.OutcomeEncoder;
import org.cleartk.ml.jar.JarStreams;
import org.cleartk.ml.util.featurevector.FeatureVector;

@Beta
public class KerasStringOutcomeClassifierBuilder
extends ScriptStringOutcomeClassifierBuilder<ScriptStringOutcomeClassifier> {
    public void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)"outcome-lookup.txt", (File)new File(dir, "outcome-lookup.txt"));
        int modelNum = 0;
        while (true) {
            File modelArchFile = new File(dir, KerasStringOutcomeClassifierBuilder.getArchFilename(modelNum));
            File modelWeightsFile = new File(dir, KerasStringOutcomeClassifierBuilder.getWeightsFilename(modelNum));
            if (!modelArchFile.exists()) break;
            JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)modelArchFile.getName(), (File)modelArchFile.getAbsoluteFile());
            JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)modelWeightsFile.getName(), (File)modelWeightsFile.getAbsoluteFile());
            ++modelNum;
        }
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        super.unpackageClassifier(modelStream);
        this.modelDir = Files.createTempDir();
        this.scriptDir = new File(modelStream.getManifest().getMainAttributes().getValue(SCRIPT_DIR_PARAM));
        KerasStringOutcomeClassifierBuilder.extractFileToDir(this.modelDir, modelStream, "outcome-lookup.txt");
        int modelNum = 0;
        while (true) {
            String archFn = KerasStringOutcomeClassifierBuilder.getArchFilename(modelNum);
            String wtsFn = KerasStringOutcomeClassifierBuilder.getWeightsFilename(modelNum);
            try {
                KerasStringOutcomeClassifierBuilder.extractFileToDir(this.modelDir, modelStream, archFn);
                KerasStringOutcomeClassifierBuilder.extractFileToDir(this.modelDir, modelStream, wtsFn);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Encountered the following exception: " + e.getMessage());
                break;
            }
            ++modelNum;
        }
    }

    protected KerasStringOutcomeClassifier newClassifier() {
        return new KerasStringOutcomeClassifier((FeaturesEncoder<FeatureVector>)this.featuresEncoder, (OutcomeEncoder<String, Integer>)this.outcomeEncoder, this.modelDir, this.scriptDir);
    }

    private static String getArchFilename(int num) {
        return "model_" + num + ".json";
    }

    private static String getWeightsFilename(int num) {
        return "model_" + num + ".h5";
    }
}

