/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.eval;

import com.google.common.base.Function;
import com.google.common.collect.Ordering;
import com.lexicalscope.jewel.cli.CliFactory;
import com.lexicalscope.jewel.cli.Option;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.ctakes.temporal.ae.THYMEKnowtatorXMLReader;
import org.apache.ctakes.temporal.eval.CommandLine;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.pipeline.JCasIterator;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.util.ViewUriUtil;
import org.cleartk.util.ae.UriToDocumentTextAnnotator;
import org.cleartk.util.cr.UriCollectionReader;

public class PrintRelations {
    private static final Ordering<BinaryTextRelation> BY_RELATION_OFFSETS = Ordering.natural().lexicographical().onResultOf((Function)new Function<BinaryTextRelation, Set<Integer>>(){

        public Set<Integer> apply(BinaryTextRelation relation) {
            Annotation arg1 = relation.getArg1().getArgument();
            Annotation arg2 = relation.getArg2().getArgument();
            return new TreeSet<Integer>(Arrays.asList(arg1.getBegin(), arg2.getBegin()));
        }
    });

    public static void main(String[] args) throws Exception {
        Options options = (Options)CliFactory.parseArguments(Options.class, (String[])args);
        File rawTextDirectory = options.getRawTextDirectory();
        File knowtatorXMLDirectory = options.getKnowtatorXMLDirectory();
        List<Integer> patientSets = options.getPatients().getList();
        ArrayList<File> files = new ArrayList<File>();
        for (Integer set : patientSets) {
            File subDir = new File(rawTextDirectory, "doc" + set);
            files.addAll(Arrays.asList(subDir.listFiles()));
        }
        CollectionReader reader = UriCollectionReader.getCollectionReaderFromFiles(files);
        AggregateBuilder aggregateBuilder = new AggregateBuilder();
        aggregateBuilder.add(UriToDocumentTextAnnotator.getDescription(), new String[0]);
        aggregateBuilder.add(THYMEKnowtatorXMLReader.getDescription(knowtatorXMLDirectory), new String[0]);
        JCasIterator casIter = new JCasIterator(reader, new AnalysisEngine[]{aggregateBuilder.createAggregate()});
        while (casIter.hasNext()) {
            JCas jCas = (JCas)casIter.next();
            System.err.println(ViewUriUtil.getURI((JCas)jCas));
            Collection relations = JCasUtil.select((JCas)jCas, BinaryTextRelation.class);
            ArrayList relationList = new ArrayList(relations);
            Collections.sort(relationList, BY_RELATION_OFFSETS);
            for (IdentifiedAnnotation identifiedAnnotation : JCasUtil.select((JCas)jCas, IdentifiedAnnotation.class)) {
                if (!(identifiedAnnotation instanceof EventMention) && !(identifiedAnnotation instanceof EntityMention)) continue;
                System.err.printf("%s (%s)\n", identifiedAnnotation.getCoveredText(), identifiedAnnotation.getTypeID());
            }
            System.err.println();
        }
    }

    static interface Options {
        @Option(longName={"text"})
        public File getRawTextDirectory();

        @Option(longName={"xml"})
        public File getKnowtatorXMLDirectory();

        @Option(longName={"patients"})
        public CommandLine.IntegerRanges getPatients();
    }
}

