/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.constituency.parser.util.AnnotationTreeUtils;
import org.apache.ctakes.typesystem.type.syntax.TreebankNode;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class ParseSpanFeatureExtractor {
    public List<Feature> extract(JCas jcas, int begin, int end) {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        TreebankNode domNode = AnnotationTreeUtils.annotationNode((JCas)jcas, (int)begin, (int)end);
        if (domNode != null) {
            TreebankNode parent;
            feats.add(new Feature("DominatingTreeCat", (Object)domNode.getNodeType()));
            if (domNode.getNodeTags() != null) {
                for (int ind = 0; ind < domNode.getNodeTags().size(); ++ind) {
                    String tag = domNode.getNodeTags(ind);
                    if (!tag.equals("TMP")) continue;
                    feats.add(new Feature("DominatingTmpTag", (Object)tag));
                }
            }
            if ((parent = domNode.getParent()) != null) {
                feats.add(new Feature("DominatingTreeParent", (Object)parent.getNodeType()));
                do {
                    if (parent.getNodeTags() == null) continue;
                    for (int ind = 0; ind < parent.getNodeTags().size(); ++ind) {
                        String tag = parent.getNodeTags(ind);
                        feats.add(new Feature("DominatingAncestorTmpTag", (Object)tag));
                    }
                } while ((parent = parent.getParent()) != null);
            }
            if (domNode.getLeaf()) {
                feats.add(new Feature((Object)"DominatingIsLeaf"));
            } else {
                StringBuffer buffer = new StringBuffer();
                for (int i = 0; i < domNode.getChildren().size(); ++i) {
                    buffer.append(domNode.getChildren(i).getNodeType());
                    buffer.append("_");
                    feats.add(new Feature((Object)("DominatingChildBag" + domNode.getChildren(i).getNodeType())));
                }
                feats.add(new Feature("DominatingProduction", (Object)buffer.toString()));
            }
            if (domNode.getBegin() == begin && domNode.getEnd() == end) {
                feats.add(new Feature((Object)"DominatingExactMatch"));
            }
        }
        return feats;
    }
}

