/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.typesystem.type.syntax.WordToken;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.cleartk.ml.Feature;

public class NearbyVerbTenseRelationExtractor
implements RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation> {
    public List<Feature> extract(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) throws AnalysisEngineProcessException {
        ArrayList<Feature> feats = new ArrayList<Feature>();
        ArrayList<EventMention> events = new ArrayList<EventMention>();
        if (arg1 instanceof EventMention) {
            events.add((EventMention)arg1);
        } else if (arg2 instanceof EventMention) {
            events.add((EventMention)arg2);
        } else {
            return feats;
        }
        Map coveringMap = JCasUtil.indexCovering((JCas)jcas, EventMention.class, Sentence.class);
        Sentence knowSentence = null;
        String seenVbPattern = null;
        for (EventMention event : events) {
            Collection sentList = (Collection)coveringMap.get(event);
            if (sentList == null || sentList.isEmpty()) continue;
            for (Sentence sent : sentList) {
                String verbTP = "";
                for (WordToken wt : JCasUtil.selectCovered((JCas)jcas, WordToken.class, (AnnotationFS)sent)) {
                    String pos;
                    if (wt == null || !(pos = wt.getPartOfSpeech()).startsWith("VB")) continue;
                    verbTP = verbTP + "_" + pos;
                }
                Feature feature = new Feature("VerbTenseFeature", (Object)verbTP);
                feats.add(feature);
                if (knowSentence == null && !verbTP.equals("")) {
                    knowSentence = sent;
                    seenVbPattern = verbTP;
                    continue;
                }
                if (knowSentence == null || knowSentence == sent || !verbTP.equals(seenVbPattern)) continue;
                feature = new Feature("TwoSentenceShareTheSameVerbPattern", (Object)verbTP);
                feats.add(feature);
            }
        }
        return feats;
    }
}

