/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.temporal.ae.TemporalEntityAnnotator_ImplBase;
import org.apache.ctakes.temporal.ae.feature.ParseSpanFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.TimeWordTypeExtractor;
import org.apache.ctakes.temporal.ae.feature.selection.Chi2FeatureSelection;
import org.apache.ctakes.temporal.ae.feature.selection.FeatureSelection;
import org.apache.ctakes.temporal.utils.SMOTEplus;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.TimeMention;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.chunking.BioChunking;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CombinedExtractor1;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.TypePathExtractor;
import org.cleartk.ml.feature.function.CharacterCategoryPatternFunction;

@PipeBitInfo(name="Time Annotator", description="...", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.BASE_TOKEN}, products={PipeBitInfo.TypeProduct.TIMEX})
public class TimeAnnotator
extends TemporalEntityAnnotator_ImplBase {
    public static final String PARAM_FEATURE_SELECTION_THRESHOLD = "WhetherToDoFeatureSelection";
    @ConfigurationParameter(name="WhetherToDoFeatureSelection", mandatory=false, description="the Chi-squared threshold at which features should be removed")
    protected Float featureSelectionThreshold = Float.valueOf(1.0f);
    public static final String PARAM_FEATURE_SELECTION_URI = "FeatureSelectionURI";
    @ConfigurationParameter(mandatory=false, name="FeatureSelectionURI", description="provides a URI where the feature selection data will be written")
    protected URI featureSelectionURI;
    public static final String PARAM_SMOTE_NUM_NEIGHBORS = "NumOfNeighborForSMOTE";
    @ConfigurationParameter(name="NumOfNeighborForSMOTE", mandatory=false, description="the number of neighbors used for minority instances for SMOTE algorithm")
    protected Float smoteNumOfNeighbors = Float.valueOf(0.0f);
    public static final String PARAM_TIMEX_VIEW = "TimexView";
    @ConfigurationParameter(name="TimexView", mandatory=false, description="View to write timexes to (used for ensemble methods)")
    protected String timexView = "_InitialView";
    protected List<FeatureExtractor1> tokenFeatureExtractors;
    protected List<CleartkExtractor> contextFeatureExtractors;
    protected ParseSpanFeatureExtractor parseExtractor;
    private BioChunking<BaseToken, TimeMention> timeChunking;
    private FeatureSelection<String> featureSelection;
    private static final String FEATURE_SELECTION_NAME = "SelectNeighborFeatures";

    public static AnalysisEngineDescription createDataWriterDescription(Class<?> dataWriterClass, File outputDirectory, float featureSelect, float smoteNeighborNumber) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TimeAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory, PARAM_FEATURE_SELECTION_THRESHOLD, Float.valueOf(featureSelect), PARAM_SMOTE_NUM_NEIGHBORS, Float.valueOf(smoteNeighborNumber)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar"), PARAM_FEATURE_SELECTION_URI, TimeAnnotator.createFeatureSelectionURI(modelDirectory)});
    }

    public static AnalysisEngineDescription createEnsembleDescription(File modelDirectory, String mappedView) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(TimeAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar"), PARAM_TIMEX_VIEW, mappedView, PARAM_FEATURE_SELECTION_URI, TimeAnnotator.createFeatureSelectionURI(modelDirectory)});
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>(FEATURE_SELECTION_NAME, threshold, true);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.timeChunking = new BioChunking(BaseToken.class, TimeMention.class);
        CombinedExtractor1 allExtractors = new CombinedExtractor1((FeatureExtractor1)new CoveredTextExtractor(), (FeatureExtractor1)CharacterCategoryPatternFunction.createExtractor((CharacterCategoryPatternFunction.PatternType)CharacterCategoryPatternFunction.PatternType.REPEATS_MERGED), (FeatureExtractor1)CharacterCategoryPatternFunction.createExtractor((CharacterCategoryPatternFunction.PatternType)CharacterCategoryPatternFunction.PatternType.ONE_PER_CHAR), (FeatureExtractor1)new TypePathExtractor(BaseToken.class, "partOfSpeech"), new TimeWordTypeExtractor());
        this.tokenFeatureExtractors = new ArrayList<FeatureExtractor1>();
        this.tokenFeatureExtractors.add((FeatureExtractor1)allExtractors);
        this.contextFeatureExtractors = new ArrayList<CleartkExtractor>();
        this.contextFeatureExtractors.add(new CleartkExtractor(BaseToken.class, (FeatureExtractor1)allExtractors, new CleartkExtractor.Context[]{new CleartkExtractor.Preceding(3), new CleartkExtractor.Following(3)}));
        this.parseExtractor = new ParseSpanFeatureExtractor();
        if (this.featureSelectionThreshold.floatValue() == 1.0f) {
            this.featureSelection = null;
        } else {
            this.featureSelection = TimeAnnotator.createFeatureSelection(this.featureSelectionThreshold.floatValue());
            if (this.featureSelectionURI != null) {
                try {
                    this.featureSelection.load(this.featureSelectionURI);
                }
                catch (IOException e) {
                    throw new ResourceInitializationException((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(JCas jCas, Segment segment) throws AnalysisEngineProcessException {
        SMOTEplus smote = new SMOTEplus((int)Math.ceil(this.smoteNumOfNeighbors.floatValue()));
        for (Sentence sentence : JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)segment)) {
            JCas timexCas;
            List<Object> outcomes;
            List tokens = JCasUtil.selectCovered((JCas)jCas, BaseToken.class, (AnnotationFS)sentence);
            if (this.isTraining()) {
                List times = JCasUtil.selectCovered((JCas)jCas, TimeMention.class, (AnnotationFS)sentence);
                outcomes = this.timeChunking.createOutcomes(jCas, tokens, times);
            } else {
                outcomes = new ArrayList();
            }
            int tokenIndex = -1;
            for (BaseToken token : tokens) {
                void var13_16;
                String outcome;
                void var13_22;
                int nPreviousClassifications;
                ++tokenIndex;
                List<Feature> features = new ArrayList<Feature>();
                for (FeatureExtractor1 featureExtractor1 : this.tokenFeatureExtractors) {
                    features.addAll(featureExtractor1.extract(jCas, (Annotation)token));
                }
                for (CleartkExtractor cleartkExtractor : this.contextFeatureExtractors) {
                    features.addAll(cleartkExtractor.extractWithin(jCas, (Annotation)token, (Annotation)sentence));
                }
                int n = nPreviousClassifications = 2;
                while (var13_22 > 0) {
                    int index = tokenIndex - var13_22;
                    String previousOutcome = index < 0 ? "O" : (String)outcomes.get(index);
                    features.add(new Feature("PreviousOutcome_" + (int)var13_22, (Object)previousOutcome));
                    --var13_22;
                }
                features.add(new Feature("SegmentID", (Object)segment.getId()));
                BaseToken baseToken = token;
                for (int i = tokenIndex - 1; i >= 0 && !(outcome = (String)outcomes.get(i)).equals("O"); --i) {
                    BaseToken baseToken2 = (BaseToken)tokens.get(i);
                }
                features.addAll(this.parseExtractor.extract(jCas, var13_16.getBegin(), token.getEnd()));
                if (this.featureSelection != null) {
                    features = this.featureSelection.transform(features);
                }
                if (this.isTraining()) {
                    String outcome2 = (String)outcomes.get(tokenIndex);
                    if (outcome2.equals("O")) {
                        this.dataWriter.write(new Instance((Object)outcome2, features));
                        continue;
                    }
                    Instance minorityInst = new Instance((Object)outcome2, features);
                    this.dataWriter.write(minorityInst);
                    smote.addInstance((Instance<String>)minorityInst);
                    continue;
                }
                outcomes.add(this.classifier.classify(features));
            }
            if (this.isTraining()) continue;
            try {
                timexCas = jCas.getView(this.timexView);
            }
            catch (CASException e) {
                throw new AnalysisEngineProcessException((Throwable)e);
            }
            this.timeChunking.createChunks(timexCas, tokens, outcomes);
        }
        if (this.isTraining() && this.smoteNumOfNeighbors.floatValue() >= 1.0f) {
            Iterable<Instance<String>> syntheticInsts = smote.populateMinorityClass();
            for (Instance<String> sytheticInst : syntheticInsts) {
                this.dataWriter.write(sytheticInst);
            }
        }
    }
}

