/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.temporal.ae;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.features.PartOfSpeechFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.CheckSpecialWordRelationExtractor;
import org.apache.ctakes.temporal.ae.feature.EventArgumentPropertyExtractor;
import org.apache.ctakes.temporal.ae.feature.EventPositionRelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.EventTimeRelationFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.NumberOfEventTimeBetweenCandidatesExtractor;
import org.apache.ctakes.temporal.ae.feature.OverlappedHeadFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.SRLRelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.SectionHeaderRelationExtractor;
import org.apache.ctakes.temporal.ae.feature.TimeXRelationFeaturesExtractor;
import org.apache.ctakes.temporal.ae.feature.UmlsFeatureExtractor;
import org.apache.ctakes.temporal.ae.feature.UnexpandedTokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.relation.TemporalTextRelation;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.jcas.tcas.DocumentAnnotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.DataWriter;

@PipeBitInfo(name="E-E Consecutive Sentence TLinker", description="Creates Event - Event TLinks between consecutive sentences.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.EVENT}, products={PipeBitInfo.TypeProduct.TEMPORAL_RELATION})
public class ConsecutiveSentencesEventEventRelationAnnotator
extends RelationExtractorAnnotator {
    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory, double probabilityOfKeepingANegativeExample) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(ConsecutiveSentencesEventEventRelationAnnotator.class, (Object[])new Object[]{"isTraining", true, "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory, "ProbabilityOfKeepingANegativeExample", Float.valueOf((float)probabilityOfKeepingANegativeExample)});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(File modelDirectory) throws ResourceInitializationException {
        return AnalysisEngineFactory.createPrimitiveDescription(ConsecutiveSentencesEventEventRelationAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", new File(modelDirectory, "model.jar")});
    }

    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        return Lists.newArrayList((Object[])new RelationFeaturesExtractor[]{new UnexpandedTokenFeaturesExtractor(), new OverlappedHeadFeaturesExtractor(), new EventArgumentPropertyExtractor(), new PartOfSpeechFeaturesExtractor(), new NumberOfEventTimeBetweenCandidatesExtractor(), new UmlsFeatureExtractor(), new SRLRelationFeaturesExtractor(), new SectionHeaderRelationExtractor(), new TimeXRelationFeaturesExtractor(), new EventPositionRelationFeaturesExtractor(), new CheckSpecialWordRelationExtractor(), new EventTimeRelationFeatureExtractor()});
    }

    protected Class<? extends Annotation> getCoveringClass() {
        return DocumentAnnotation.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jCas, Annotation document) {
        ArrayList pairs = Lists.newArrayList();
        Collection segments = JCasUtil.select((JCas)jCas, Segment.class);
        ArrayList segList = Lists.newArrayList();
        for (Segment seg : segments) {
            if (seg.getId().equals("SIMPLE_SEGMENT")) continue;
            segList.add(seg);
        }
        for (Segment segment : segList) {
            List sentList = JCasUtil.selectCovered((JCas)jCas, Sentence.class, (AnnotationFS)segment);
            int sentListLength = sentList.size();
            if (sentListLength < 2) continue;
            for (int i = 0; i < sentListLength - 1; ++i) {
                int nextSize;
                Sentence currentSent = (Sentence)sentList.get(i);
                Sentence nextSent = (Sentence)sentList.get(i + 1);
                ArrayList<EventMention> currentEvents = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)currentSent);
                ArrayList<EventMention> nextEvents = JCasUtil.selectCovered((JCas)jCas, EventMention.class, (AnnotationFS)nextSent);
                ArrayList<EventMention> realEvents = new ArrayList<EventMention>();
                for (EventMention event : currentEvents) {
                    if (!event.getClass().equals(EventMention.class)) continue;
                    realEvents.add(event);
                }
                currentEvents = realEvents;
                realEvents = new ArrayList();
                for (EventMention event : nextEvents) {
                    if (!event.getClass().equals(EventMention.class)) continue;
                    realEvents.add(event);
                }
                nextEvents = realEvents;
                int currentSize = currentEvents == null ? 0 : currentEvents.size();
                int n = nextSize = nextEvents == null ? 0 : nextEvents.size();
                if (currentSize == 0 || nextSize == 0) continue;
                EventMention currentFirst = null;
                EventMention currentLast = null;
                EventMention nextFirst = null;
                EventMention nextLast = null;
                if (currentSize == 1) {
                    currentFirst = (EventMention)currentEvents.get(0);
                } else if (currentSize > 1) {
                    currentFirst = (EventMention)currentEvents.get(0);
                    currentLast = (EventMention)currentEvents.get(currentSize - 1);
                }
                if (nextSize == 1) {
                    nextFirst = (EventMention)nextEvents.get(0);
                } else if (nextSize > 1) {
                    nextFirst = (EventMention)nextEvents.get(0);
                    nextLast = (EventMention)nextEvents.get(nextSize - 1);
                }
                if (currentFirst != null) {
                    if (nextFirst != null) {
                        pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)nextFirst, (IdentifiedAnnotation)currentFirst));
                    }
                    if (nextLast != null) {
                        pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)nextLast, (IdentifiedAnnotation)currentFirst));
                    }
                }
                if (currentLast == null) continue;
                if (nextFirst != null) {
                    pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)nextFirst, (IdentifiedAnnotation)currentLast));
                }
                if (nextLast == null) continue;
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)nextLast, (IdentifiedAnnotation)currentLast));
            }
        }
        return pairs;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Arg1");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Arg2");
        relArg2.addToIndexes();
        TemporalTextRelation relation = new TemporalTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        relation.addToIndexes();
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        BinaryTextRelation relation = relationLookup.get(Arrays.asList(arg1, arg2));
        String category = null;
        if (relation != null) {
            category = relation.getCategory();
        } else {
            relation = relationLookup.get(Arrays.asList(arg2, arg1));
            if (relation != null) {
                if (relation.getCategory().equals("OVERLAP")) {
                    category = relation.getCategory();
                } else if (relation.getCategory().equals("BEFORE")) {
                    category = "AFTER";
                } else if (relation.getCategory().equals("AFTER")) {
                    category = "BEFORE";
                }
            }
        }
        if (category == null && this.coin.nextDouble() <= this.probabilityOfKeepingANegativeExample) {
            category = "-NONE-";
        }
        return category;
    }
}

