/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.feature.function;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.extractor.CleartkExtractorException;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.function.FeatureFunction;

public class FeatureFunctionExtractor<T extends Annotation>
implements FeatureExtractor1<T> {
    private FeatureExtractor1<T> extractor;
    private FeatureFunction[] featureFunctions;
    private BaseFeatures baseFeatures;

    public FeatureFunctionExtractor(FeatureExtractor1<T> extractor, FeatureFunction ... featureFunctions) {
        this(extractor, BaseFeatures.INCLUDE, featureFunctions);
    }

    public FeatureFunctionExtractor(FeatureExtractor1<T> extractor, BaseFeatures baseFeatures, FeatureFunction ... featureFunctions) {
        this.extractor = extractor;
        this.baseFeatures = baseFeatures;
        this.featureFunctions = featureFunctions;
    }

    @Override
    public List<Feature> extract(JCas jCas, T focusAnnotation) throws CleartkExtractorException {
        ArrayList<Feature> returnValues = new ArrayList<Feature>();
        List<Feature> features = this.extractor.extract(jCas, focusAnnotation);
        if (this.baseFeatures == BaseFeatures.INCLUDE) {
            returnValues.addAll(features);
        }
        for (FeatureFunction featureFunction : this.featureFunctions) {
            returnValues.addAll(FeatureFunctionExtractor.apply(featureFunction, features));
        }
        return returnValues;
    }

    public static List<Feature> apply(Function<Feature, List<Feature>> featureFunction, List<Feature> features) {
        ArrayList<Feature> returnValues = new ArrayList<Feature>();
        for (Feature feature : features) {
            returnValues.addAll((Collection)featureFunction.apply((Object)feature));
        }
        return returnValues;
    }

    public static enum BaseFeatures {
        INCLUDE,
        EXCLUDE;

    }
}

