/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40.values;

import java.io.IOException;
import java.util.Comparator;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.codecs.lucene40.values.FixedDerefBytesImpl;
import org.apache.lucene.codecs.lucene40.values.FixedSortedBytesImpl;
import org.apache.lucene.codecs.lucene40.values.FixedStraightBytesImpl;
import org.apache.lucene.codecs.lucene40.values.VarDerefBytesImpl;
import org.apache.lucene.codecs.lucene40.values.VarSortedBytesImpl;
import org.apache.lucene.codecs.lucene40.values.VarStraightBytesImpl;
import org.apache.lucene.codecs.lucene40.values.Writer;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.packed.PackedInts;

public final class Bytes {
    static final String DV_SEGMENT_SUFFIX = "dv";

    private Bytes() {
    }

    public static DocValuesConsumer getWriter(Directory dir, String id, Mode mode, boolean fixedSize, Comparator<BytesRef> sortComparator, Counter bytesUsed, IOContext context, float acceptableOverheadRatio) {
        if (sortComparator == null) {
            sortComparator = BytesRef.getUTF8SortedAsUnicodeComparator();
        }
        if (fixedSize) {
            if (mode == Mode.STRAIGHT) {
                return new FixedStraightBytesImpl.Writer(dir, id, bytesUsed, context);
            }
            if (mode == Mode.DEREF) {
                return new FixedDerefBytesImpl.Writer(dir, id, bytesUsed, context);
            }
            if (mode == Mode.SORTED) {
                return new FixedSortedBytesImpl.Writer(dir, id, sortComparator, bytesUsed, context, acceptableOverheadRatio);
            }
        } else {
            if (mode == Mode.STRAIGHT) {
                return new VarStraightBytesImpl.Writer(dir, id, bytesUsed, context);
            }
            if (mode == Mode.DEREF) {
                return new VarDerefBytesImpl.Writer(dir, id, bytesUsed, context);
            }
            if (mode == Mode.SORTED) {
                return new VarSortedBytesImpl.Writer(dir, id, sortComparator, bytesUsed, context, acceptableOverheadRatio);
            }
        }
        throw new IllegalArgumentException("");
    }

    public static DocValues getValues(Directory dir, String id, Mode mode, boolean fixedSize, int maxDoc, Comparator<BytesRef> sortComparator, IOContext context) throws IOException {
        if (sortComparator == null) {
            sortComparator = BytesRef.getUTF8SortedAsUnicodeComparator();
        }
        if (fixedSize) {
            if (mode == Mode.STRAIGHT) {
                return new FixedStraightBytesImpl.FixedStraightReader(dir, id, maxDoc, context);
            }
            if (mode == Mode.DEREF) {
                return new FixedDerefBytesImpl.FixedDerefReader(dir, id, maxDoc, context);
            }
            if (mode == Mode.SORTED) {
                return new FixedSortedBytesImpl.Reader(dir, id, maxDoc, context, DocValues.Type.BYTES_FIXED_SORTED, sortComparator);
            }
        } else {
            if (mode == Mode.STRAIGHT) {
                return new VarStraightBytesImpl.VarStraightReader(dir, id, maxDoc, context);
            }
            if (mode == Mode.DEREF) {
                return new VarDerefBytesImpl.VarDerefReader(dir, id, maxDoc, context);
            }
            if (mode == Mode.SORTED) {
                return new VarSortedBytesImpl.Reader(dir, id, maxDoc, context, DocValues.Type.BYTES_VAR_SORTED, sortComparator);
            }
        }
        throw new IllegalArgumentException("Illegal Mode: " + (Object)((Object)mode));
    }

    static abstract class BytesSortedSourceBase
    extends DocValues.SortedSource {
        private final PagedBytes pagedBytes;
        protected final PackedInts.Reader docToOrdIndex;
        protected final PackedInts.Reader ordToOffsetIndex;
        protected final IndexInput datIn;
        protected final IndexInput idxIn;
        protected final BytesRef defaultValue = new BytesRef();
        protected static final int PAGED_BYTES_BITS = 15;
        protected final PagedBytes.Reader data;

        protected BytesSortedSourceBase(IndexInput datIn, IndexInput idxIn, Comparator<BytesRef> comp, long bytesToRead, DocValues.Type type, boolean hasOffsets) throws IOException {
            this(datIn, idxIn, comp, new PagedBytes(15), bytesToRead, type, hasOffsets);
        }

        protected BytesSortedSourceBase(IndexInput datIn, IndexInput idxIn, Comparator<BytesRef> comp, PagedBytes pagedBytes, long bytesToRead, DocValues.Type type, boolean hasOffsets) throws IOException {
            super(type, comp);
            assert (bytesToRead <= datIn.length()) : " file size is less than the expected size diff: " + (bytesToRead - datIn.length()) + " pos: " + datIn.getFilePointer();
            this.datIn = datIn;
            this.pagedBytes = pagedBytes;
            this.pagedBytes.copy(datIn, bytesToRead);
            this.data = pagedBytes.freeze(true);
            this.idxIn = idxIn;
            this.ordToOffsetIndex = hasOffsets ? PackedInts.getReader(idxIn) : null;
            this.docToOrdIndex = PackedInts.getReader(idxIn);
        }

        @Override
        public boolean hasPackedDocToOrd() {
            return true;
        }

        @Override
        public PackedInts.Reader getDocToOrd() {
            return this.docToOrdIndex;
        }

        @Override
        public int ord(int docID) {
            assert (this.docToOrdIndex.get(docID) < (long)this.getValueCount());
            return (int)this.docToOrdIndex.get(docID);
        }

        protected void closeIndexInput() throws IOException {
            IOUtils.close(this.datIn, this.idxIn);
        }
    }

    static abstract class DerefBytesWriterBase
    extends BytesWriterBase {
        protected int size = -1;
        protected int lastDocId = -1;
        protected int[] docToEntry;
        protected final BytesRefHash hash;
        protected final float acceptableOverheadRatio;
        protected long maxBytes = 0L;

        protected DerefBytesWriterBase(Directory dir, String id, String codecNameIdx, String codecNameDat, int codecVersion, Counter bytesUsed, IOContext context, DocValues.Type type) {
            this(dir, id, codecNameIdx, codecNameDat, codecVersion, new ByteBlockPool.DirectTrackingAllocator(32768, bytesUsed), bytesUsed, context, 0.2f, type);
        }

        protected DerefBytesWriterBase(Directory dir, String id, String codecNameIdx, String codecNameDat, int codecVersion, Counter bytesUsed, IOContext context, float acceptableOverheadRatio, DocValues.Type type) {
            this(dir, id, codecNameIdx, codecNameDat, codecVersion, new ByteBlockPool.DirectTrackingAllocator(32768, bytesUsed), bytesUsed, context, acceptableOverheadRatio, type);
        }

        protected DerefBytesWriterBase(Directory dir, String id, String codecNameIdx, String codecNameDat, int codecVersion, ByteBlockPool.Allocator allocator, Counter bytesUsed, IOContext context, float acceptableOverheadRatio, DocValues.Type type) {
            super(dir, id, codecNameIdx, codecNameDat, codecVersion, bytesUsed, context, type);
            this.hash = new BytesRefHash(new ByteBlockPool(allocator), 16, new BytesRefHash.TrackingDirectBytesStartArray(16, bytesUsed));
            this.docToEntry = new int[1];
            bytesUsed.addAndGet(4L);
            this.acceptableOverheadRatio = acceptableOverheadRatio;
        }

        protected static int writePrefixLength(DataOutput datOut, BytesRef bytes) throws IOException {
            if (bytes.length < 128) {
                datOut.writeByte((byte)bytes.length);
                return 1;
            }
            datOut.writeByte((byte)(0x80 | bytes.length >> 8));
            datOut.writeByte((byte)(bytes.length & 0xFF));
            return 2;
        }

        @Override
        public void add(int docID, IndexableField value) throws IOException {
            BytesRef bytes = value.binaryValue();
            assert (bytes != null);
            if (bytes.length == 0) {
                return;
            }
            this.checkSize(bytes);
            this.fillDefault(docID);
            int ord = this.hash.add(bytes);
            if (ord < 0) {
                ord = -ord - 1;
            } else {
                this.maxBytes += (long)bytes.length;
            }
            this.docToEntry[docID] = ord;
            this.lastDocId = docID;
        }

        protected void fillDefault(int docID) {
            if (docID >= this.docToEntry.length) {
                int size = this.docToEntry.length;
                this.docToEntry = ArrayUtil.grow(this.docToEntry, 1 + docID);
                this.bytesUsed.addAndGet((this.docToEntry.length - size) * 4);
            }
            assert (this.size >= 0);
            BytesRef ref = new BytesRef(this.size);
            ref.length = this.size;
            int ord = this.hash.add(ref);
            if (ord < 0) {
                ord = -ord - 1;
            }
            for (int i = this.lastDocId + 1; i < docID; ++i) {
                this.docToEntry[i] = ord;
            }
        }

        protected void checkSize(BytesRef bytes) {
            if (this.size == -1) {
                this.size = bytes.length;
            } else if (bytes.length != this.size) {
                throw new IllegalArgumentException("expected bytes size=" + this.size + " but got " + bytes.length);
            }
        }

        @Override
        public int getValueSize() {
            return this.size;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void finish(int docCount) throws IOException {
            block5: {
                block4: {
                    boolean success = false;
                    try {
                        this.finishInternal(docCount);
                        success = true;
                        this.releaseResources();
                        if (!success) break block4;
                    }
                    catch (Throwable throwable) {
                        this.releaseResources();
                        if (success) {
                            IOUtils.close(this.getIndexOut(), this.getDataOut());
                        } else {
                            IOUtils.closeWhileHandlingException(this.getIndexOut(), this.getDataOut());
                        }
                        throw throwable;
                    }
                    IOUtils.close(this.getIndexOut(), this.getDataOut());
                    break block5;
                }
                IOUtils.closeWhileHandlingException(this.getIndexOut(), this.getDataOut());
            }
        }

        protected abstract void finishInternal(int var1) throws IOException;

        protected void releaseResources() {
            this.hash.close();
            this.bytesUsed.addAndGet(-this.docToEntry.length * 4);
            this.docToEntry = null;
        }

        protected void writeIndex(IndexOutput idxOut, int docCount, long maxValue, int[] toEntry) throws IOException {
            this.writeIndex(idxOut, docCount, maxValue, (int[])null, toEntry);
        }

        protected void writeIndex(IndexOutput idxOut, int docCount, long maxValue, int[] addresses, int[] toEntry) throws IOException {
            int i;
            int limit;
            PackedInts.Writer w = PackedInts.getWriter(idxOut, docCount, PackedInts.bitsRequired(maxValue), this.acceptableOverheadRatio);
            int n = limit = docCount > this.docToEntry.length ? this.docToEntry.length : docCount;
            assert (toEntry.length >= limit - 1);
            if (addresses != null) {
                for (i = 0; i < limit; ++i) {
                    assert (addresses[toEntry[i]] >= 0);
                    w.add(addresses[toEntry[i]]);
                }
            } else {
                for (i = 0; i < limit; ++i) {
                    assert (toEntry[i] >= 0);
                    w.add(toEntry[i]);
                }
            }
            for (i = limit; i < docCount; ++i) {
                w.add(0L);
            }
            w.finish();
        }

        protected void writeIndex(IndexOutput idxOut, int docCount, long maxValue, long[] addresses, int[] toEntry) throws IOException {
            int i;
            int limit;
            PackedInts.Writer w = PackedInts.getWriter(idxOut, docCount, PackedInts.bitsRequired(maxValue), this.acceptableOverheadRatio);
            int n = limit = docCount > this.docToEntry.length ? this.docToEntry.length : docCount;
            assert (toEntry.length >= limit - 1);
            if (addresses != null) {
                for (i = 0; i < limit; ++i) {
                    assert (addresses[toEntry[i]] >= 0L);
                    w.add(addresses[toEntry[i]]);
                }
            } else {
                for (i = 0; i < limit; ++i) {
                    assert (toEntry[i] >= 0);
                    w.add(toEntry[i]);
                }
            }
            for (i = limit; i < docCount; ++i) {
                w.add(0L);
            }
            w.finish();
        }
    }

    static abstract class BytesReaderBase
    extends DocValues {
        protected final IndexInput idxIn;
        protected final IndexInput datIn;
        protected final int version;
        protected final String id;
        protected final DocValues.Type type;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected BytesReaderBase(Directory dir, String id, String codecNameIdx, String codecNameDat, int maxVersion, boolean doIndex, IOContext context, DocValues.Type type) throws IOException {
            IndexInput indexIn;
            IndexInput dataIn;
            block5: {
                dataIn = null;
                indexIn = null;
                boolean success = false;
                try {
                    dataIn = dir.openInput(IndexFileNames.segmentFileName(id, Bytes.DV_SEGMENT_SUFFIX, "dat"), context);
                    this.version = CodecUtil.checkHeader(dataIn, codecNameDat, maxVersion, maxVersion);
                    if (doIndex) {
                        indexIn = dir.openInput(IndexFileNames.segmentFileName(id, Bytes.DV_SEGMENT_SUFFIX, "idx"), context);
                        int version2 = CodecUtil.checkHeader(indexIn, codecNameIdx, maxVersion, maxVersion);
                        assert (this.version == version2);
                    }
                    if (success = true) break block5;
                }
                catch (Throwable throwable) {
                    if (!success) {
                        IOUtils.closeWhileHandlingException(dataIn, indexIn);
                    }
                    throw throwable;
                }
                IOUtils.closeWhileHandlingException(dataIn, indexIn);
            }
            this.datIn = dataIn;
            this.idxIn = indexIn;
            this.type = type;
            this.id = id;
        }

        protected final IndexInput cloneData() {
            assert (this.datIn != null);
            return this.datIn.clone();
        }

        protected final IndexInput cloneIndex() {
            assert (this.idxIn != null);
            return this.idxIn.clone();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                super.close();
            }
            catch (Throwable throwable) {
                IOUtils.close(this.datIn, this.idxIn);
                throw throwable;
            }
            IOUtils.close(this.datIn, this.idxIn);
        }

        @Override
        public DocValues.Type getType() {
            return this.type;
        }
    }

    static abstract class BytesWriterBase
    extends Writer {
        private final String id;
        private IndexOutput idxOut;
        private IndexOutput datOut;
        protected BytesRef bytesRef = new BytesRef();
        private final Directory dir;
        private final String codecNameIdx;
        private final String codecNameDat;
        private final int version;
        private final IOContext context;

        protected BytesWriterBase(Directory dir, String id, String codecNameIdx, String codecNameDat, int version, Counter bytesUsed, IOContext context, DocValues.Type type) {
            super(bytesUsed, type);
            this.id = id;
            this.dir = dir;
            this.codecNameIdx = codecNameIdx;
            this.codecNameDat = codecNameDat;
            this.version = version;
            this.context = context;
            assert (codecNameDat != null || codecNameIdx != null) : "both codec names are null";
            assert (codecNameDat != null && !codecNameDat.equals(codecNameIdx) || codecNameIdx != null && !codecNameIdx.equals(codecNameDat)) : "index and data codec names must not be equal";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected IndexOutput getOrCreateDataOut() throws IOException {
            if (this.datOut != null) return this.datOut;
            boolean success = false;
            assert (this.codecNameDat != null);
            try {
                this.datOut = this.dir.createOutput(IndexFileNames.segmentFileName(this.id, Bytes.DV_SEGMENT_SUFFIX, "dat"), this.context);
                CodecUtil.writeHeader(this.datOut, this.codecNameDat, this.version);
                return this.datOut;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this.datOut);
                throw throwable;
            }
        }

        protected IndexOutput getIndexOut() {
            return this.idxOut;
        }

        protected IndexOutput getDataOut() {
            return this.datOut;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected IndexOutput getOrCreateIndexOut() throws IOException {
            boolean success = false;
            try {
                if (this.idxOut == null) {
                    assert (this.codecNameIdx != null);
                    this.idxOut = this.dir.createOutput(IndexFileNames.segmentFileName(this.id, Bytes.DV_SEGMENT_SUFFIX, "idx"), this.context);
                    CodecUtil.writeHeader(this.idxOut, this.codecNameIdx, this.version);
                }
                if (success = true) return this.idxOut;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                IOUtils.closeWhileHandlingException(this.idxOut);
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.idxOut);
            return this.idxOut;
        }

        @Override
        public abstract void finish(int var1) throws IOException;
    }

    static abstract class BytesSourceBase
    extends DocValues.Source {
        private final PagedBytes pagedBytes;
        protected final IndexInput datIn;
        protected final IndexInput idxIn;
        protected static final int PAGED_BYTES_BITS = 15;
        protected final PagedBytes.Reader data;
        protected final long totalLengthInBytes;

        protected BytesSourceBase(IndexInput datIn, IndexInput idxIn, PagedBytes pagedBytes, long bytesToRead, DocValues.Type type) throws IOException {
            super(type);
            assert (bytesToRead <= datIn.length()) : " file size is less than the expected size diff: " + (bytesToRead - datIn.length()) + " pos: " + datIn.getFilePointer();
            this.datIn = datIn;
            this.totalLengthInBytes = bytesToRead;
            this.pagedBytes = pagedBytes;
            this.pagedBytes.copy(datIn, bytesToRead);
            this.data = pagedBytes.freeze(true);
            this.idxIn = idxIn;
        }
    }

    public static enum Mode {
        STRAIGHT,
        DEREF,
        SORTED;

    }
}

