/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.util.CoreUtils;
import com.icesoft.faces.util.Debug;
import java.io.IOException;
import java.util.Iterator;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIMessage;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class MessageRenderer
extends DomBasicRenderer {
    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String title;
        String lang;
        Boolean visible;
        boolean isVisible;
        MessageRenderer.validateParameters(facesContext, uiComponent, UIMessage.class);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        FacesMessage facesMessage = this.getSingleMessage(facesContext, (UIMessage)uiComponent);
        if ("javax.faces.Message".equals(uiComponent.getRendererType()) && facesMessage == null) {
            domContext.stepOver();
            return;
        }
        if (!domContext.isInitialized()) {
            Element span = domContext.createElement("span");
            domContext.setRootNode(span);
            MessageRenderer.setRootElementId(facesContext, span, uiComponent);
        }
        Element root = (Element)domContext.getRootNode();
        if (!"javax.faces.Message".equals(uiComponent.getRendererType()) && facesMessage == null) {
            domContext.stepOver();
            return;
        }
        if (facesMessage.isRendered() && !((UIMessage)uiComponent).isRedisplay()) {
            return;
        }
        facesMessage.rendered();
        DOMContext.removeChildren(root);
        String[] styleAndStyleClass = MessageRenderer.getStyleAndStyleClass(uiComponent, facesMessage);
        String style = styleAndStyleClass[0];
        String styleClass = styleAndStyleClass[1];
        if (styleClass != null) {
            root.setAttribute("class", styleClass);
        }
        boolean bl = isVisible = (visible = (Boolean)uiComponent.getAttributes().get("visible")) == null || visible != false;
        if (isVisible) {
            if (style != null && style.length() > 0) {
                root.setAttribute("style", style);
            } else {
                root.removeAttribute("style");
            }
        } else {
            if (style == null) {
                style = "";
            } else if (style.trim().length() != 0 && !style.trim().endsWith(";")) {
                style = style + ";";
            }
            style = style + "display:none;";
            root.setAttribute("style", style);
        }
        boolean tooltip = this.getToolTipAttribute(uiComponent);
        String[] summaryAndDetail = this.getSummaryAndDetail(facesMessage);
        String summary = summaryAndDetail[0];
        String detail = summaryAndDetail[1];
        boolean showSummary = ((UIMessage)uiComponent).isShowSummary();
        boolean showDetail = ((UIMessage)uiComponent).isShowDetail();
        String dir = (String)uiComponent.getAttributes().get("dir");
        if (dir != null) {
            root.setAttribute("dir", dir);
        }
        if ((lang = (String)uiComponent.getAttributes().get("lang")) != null) {
            root.setAttribute("lang", lang);
        }
        if ((title = (String)uiComponent.getAttributes().get("title")) == null && tooltip && showSummary) {
            title = summary;
        }
        if (title == null && tooltip && showDetail) {
            title = detail;
        }
        if (title != null) {
            root.setAttribute("title", title);
        }
        if (tooltip && showSummary && showDetail) {
            Text textNode = domContext.createTextNode(detail);
            root.appendChild(textNode);
        } else {
            Text textNode;
            if (showSummary) {
                textNode = domContext.createTextNode(summary);
                root.appendChild(textNode);
            }
            if (showDetail) {
                textNode = domContext.createTextNode(detail);
                root.appendChild(textNode);
            }
        }
        domContext.stepOver();
    }

    private void writeStream(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String sstyle;
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        Element root = domContext.createRootElement("span");
        Text text = domContext.createTextNode("Message goes here");
        Object style = uiComponent.getAttributes().get("style");
        String string = sstyle = style == null ? null : style.toString();
        if (sstyle != null && sstyle.length() > 0) {
            root.setAttribute("style", sstyle);
        } else {
            root.removeAttribute("style");
        }
        root.appendChild(text);
        domContext.stepOver();
    }

    private FacesMessage getSingleMessage(FacesContext facesContext, UIMessage uiMessage) {
        String forComponentId = uiMessage.getFor();
        Debug.assertTrue(forComponentId != null, "For component must not be null");
        Iterator messages = null;
        if (forComponentId.length() == 0) {
            messages = facesContext.getMessages(null);
        } else {
            UIComponent forComponent = MessageRenderer.findForComponent(facesContext, (UIComponent)uiMessage);
            if (forComponent != null) {
                if (messages == null || !messages.hasNext()) {
                    CoreUtils.recoverFacesMessages(facesContext, forComponent);
                }
                messages = facesContext.getMessages(forComponent.getClientId(facesContext));
            }
        }
        if (messages == null || !messages.hasNext()) {
            return null;
        }
        FacesMessage firstMessage = (FacesMessage)messages.next();
        return firstMessage;
    }
}

