/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.renderkit.dom_html_basic;

import com.icesoft.faces.component.AttributeConstants;
import com.icesoft.faces.context.DOMContext;
import com.icesoft.faces.renderkit.dom_html_basic.DomBasicRenderer;
import com.icesoft.faces.renderkit.dom_html_basic.PassThruAttributeRenderer;
import com.icesoft.util.SeamUtilities;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UINamingContainer;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.w3c.dom.Element;

public class FormRenderer
extends DomBasicRenderer {
    private static Logger log = Logger.getLogger("com.icesoft.faces.compat");
    public static final String COMMAND_LINK_HIDDEN_FIELD = "command_link_hidden_field";
    public static final String COMMAND_LINK_HIDDEN_FIELDS_KEY = "com.icesoft.faces.FormRequiredHidden";
    public static final String STATE_SAVING_MARKER = "~com.sun.faces.saveStateFieldMarker~";
    private static final String[] passThruAttributes = AttributeConstants.getAttributes(3);

    public void decode(FacesContext facesContext, UIComponent uiComponent) {
        FormRenderer.validateParameters(facesContext, uiComponent, UIForm.class);
        UIForm uiForm = (UIForm)uiComponent;
        Map requestParameterMap = facesContext.getExternalContext().getRequestParameterMap();
        String formClientId = uiForm.getClientId(facesContext);
        if (requestParameterMap.containsKey(formClientId) || uiComponent.getAttributes().containsKey("fileUploaded")) {
            uiForm.setSubmitted(true);
        } else {
            uiForm.setSubmitted(false);
        }
    }

    public void encodeBegin(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        String userDefinedValue;
        String flowId;
        Element root;
        FormRenderer.validateParameters(facesContext, uiComponent, UIForm.class);
        this.validateNestingForm(uiComponent);
        DOMContext domContext = DOMContext.attachDOMContext(facesContext, uiComponent);
        String formClientId = uiComponent.getClientId(facesContext);
        if (!domContext.isInitialized()) {
            String acceptcharset;
            root = domContext.createElement("form");
            domContext.setRootNode(root);
            root.setAttribute("id", formClientId);
            root.setAttribute("method", "post");
            ExternalContext externalContext = facesContext.getExternalContext();
            root.setAttribute("action", FormRenderer.getAction(facesContext));
            String styleClass = (String)uiComponent.getAttributes().get("styleClass");
            if (styleClass != null) {
                root.setAttribute("class", styleClass);
            }
            if ((acceptcharset = (String)uiComponent.getAttributes().get("acceptcharset")) != null) {
                root.setAttribute("accept-charset", acceptcharset);
            }
            Element formHiddenField = domContext.createElement("input");
            formHiddenField.setAttribute("type", "hidden");
            formHiddenField.setAttribute("name", formClientId);
            formHiddenField.setAttribute("value", formClientId);
            root.appendChild(formHiddenField);
            String viewId = facesContext.getViewRoot().getViewId();
            String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, viewId);
            String encodedActionURL = externalContext.encodeActionURL(actionURL);
            String encodedPartialActionURL = externalContext.encodePartialActionURL(actionURL);
            if (encodedPartialActionURL != null && !encodedPartialActionURL.equals(encodedActionURL)) {
                Element encodedURLField = domContext.createElement("input");
                encodedURLField.setAttribute("type", "hidden");
                encodedURLField.setAttribute("name", "javax.faces.encodedURL");
                encodedURLField.setAttribute("value", encodedPartialActionURL);
                root.appendChild(encodedURLField);
            }
        }
        domContext.getRootNode().appendChild(domContext.createTextNode(STATE_SAVING_MARKER));
        root = (Element)domContext.getRootNode();
        String conversationId = SeamUtilities.getSeamConversationId();
        if (conversationId != null) {
            String conversationParamName = SeamUtilities.getConversationIdParameterName();
            Element conversationIDElement = domContext.createElement("input");
            if (log.isLoggable(Level.FINE)) {
                log.fine("Embedding Seam Param - name: " + conversationParamName + ", value: " + conversationId);
            }
            conversationIDElement.setAttribute("type", "hidden");
            conversationIDElement.setAttribute("name", conversationParamName);
            conversationIDElement.setAttribute("value", conversationId);
            root.appendChild(conversationIDElement);
        }
        if ((flowId = SeamUtilities.getSpringFlowId()) != null) {
            String flowParamName = SeamUtilities.getFlowIdParameterName();
            Element flowIDElement = domContext.createElement("input");
            if (log.isLoggable(Level.FINE)) {
                log.fine("Embedding Spring Param - name: " + flowParamName + ", value: " + flowId);
            }
            String flowParamId = formClientId + UINamingContainer.getSeparatorChar((FacesContext)facesContext) + flowParamName;
            flowIDElement.setAttribute("type", "hidden");
            flowIDElement.setAttribute("name", flowParamName);
            flowIDElement.setAttribute("id", flowParamId);
            flowIDElement.setAttribute("value", flowId);
            root.appendChild(flowIDElement);
        }
        PassThruAttributeRenderer.renderHtmlAttributes(facesContext, uiComponent, passThruAttributes);
        String autoComplete = (String)uiComponent.getAttributes().get("autocomplete");
        if (autoComplete != null && "off".equalsIgnoreCase(autoComplete)) {
            root.setAttribute("autocomplete", "off");
        }
        if ((userDefinedValue = root.getAttribute("onsubmit")) == null || userDefinedValue.equalsIgnoreCase("")) {
            root.setAttribute("onsubmit", "return false;");
        }
        domContext.stepInto(uiComponent);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent uiComponent) {
        FormRenderer.validateParameters(facesContext, uiComponent, UIForm.class);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent uiComponent) throws IOException {
        FormRenderer.validateParameters(facesContext, uiComponent, UIForm.class);
        DOMContext domContext = DOMContext.getDOMContext(facesContext, uiComponent);
        if (uiComponent.getAttributes().get("$ice-msgs$") != null) {
            UIComponent messages = (UIComponent)uiComponent.getAttributes().get("$ice-msgs$");
            messages.encodeBegin(facesContext);
            messages.encodeChildren(facesContext);
            messages.encodeEnd(facesContext);
        }
        domContext.stepOver();
    }

    public static void addHiddenField(FacesContext facesContext, String fieldName) {
        FormRenderer.addHiddenField(facesContext, fieldName, COMMAND_LINK_HIDDEN_FIELD);
    }

    private static void addHiddenField(FacesContext facesContext, String fieldName, String value) {
        Map hiddenFieldMap = FormRenderer.getCommandLinkFields(facesContext);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = FormRenderer.createCommandLinkFieldsOnRequestMap(facesContext);
        }
        if (!hiddenFieldMap.containsKey(fieldName)) {
            hiddenFieldMap.put(fieldName, value);
        }
    }

    private static Map getCommandLinkFields(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap hiddenFieldMap = (HashMap)requestMap.get(COMMAND_LINK_HIDDEN_FIELDS_KEY);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = new HashMap();
            requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, hiddenFieldMap);
        }
        return hiddenFieldMap;
    }

    private static Map createCommandLinkFieldsOnRequestMap(FacesContext facesContext) {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        HashMap hiddenFieldMap = (HashMap)requestMap.get(COMMAND_LINK_HIDDEN_FIELDS_KEY);
        if (hiddenFieldMap == null) {
            hiddenFieldMap = new HashMap();
            requestMap.put(COMMAND_LINK_HIDDEN_FIELDS_KEY, hiddenFieldMap);
        }
        return hiddenFieldMap;
    }

    private void validateNestingForm(UIComponent uiComponent) throws IOException {
        UIComponent parent = uiComponent.getParent();
        if (parent == null) {
            return;
        }
        if (parent instanceof UIForm) {
            throw new FacesException("Nested form found on the page. The form action element can not be nested");
        }
        this.validateNestingForm(parent);
    }

    private static String getAction(FacesContext facesContext) {
        String viewId = facesContext.getViewRoot().getViewId();
        String actionURL = facesContext.getApplication().getViewHandler().getActionURL(facesContext, viewId);
        return facesContext.getExternalContext().encodeActionURL(actionURL);
    }
}

