/*
 * Decompiled with CFR 0.152.
 */
package org.icefaces.impl.application;

import java.util.logging.Logger;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.faces.event.ExceptionQueuedEventContext;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.icefaces.application.SessionExpiredException;
import org.icefaces.util.EnvUtils;
import org.icepush.PushContext;

public class SessionExpiredListener
implements HttpSessionListener {
    private static Logger log = Logger.getLogger(SessionExpiredListener.class.getName());

    public void sessionCreated(HttpSessionEvent httpSessionEvent) {
    }

    public void sessionDestroyed(HttpSessionEvent httpSessionEvent) {
        FacesContext fc = FacesContext.getCurrentInstance();
        if (fc != null) {
            Application app = fc.getApplication();
            if (app == null) {
                ApplicationFactory factory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
                app = factory.getApplication();
            }
            ExceptionQueuedEventContext ctxt = new ExceptionQueuedEventContext(fc, (Throwable)new SessionExpiredException("Session has expired"));
            app.publishEvent(fc, ExceptionQueuedEvent.class, (Object)ctxt);
        }
        if (EnvUtils.isICEpushPresent()) {
            HttpSession session = httpSessionEvent.getSession();
            ServletContext servletContext = session.getServletContext();
            PushContext pushContext = PushContext.getInstance((ServletContext)servletContext);
            pushContext.push(session.getId());
        }
    }
}

