/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.apache.ctakes.coreference.eval.helpers.Span;
import org.apache.ctakes.coreference.eval.helpers.SpanAlignment;
import org.apache.ctakes.coreference.eval.helpers.SpanOffsetComparator;
import org.apache.ctakes.coreference.type.Markable;
import org.apache.ctakes.coreference.util.ParentPtrTree;
import org.apache.uima.jcas.tcas.Annotation;

public class GoldStandardLabeler {
    private String dir = null;
    private String docName = null;
    Vector<Span> sysSpans = null;
    Vector<Span> goldSpans = null;
    Hashtable<String, Integer> goldSpan2id = null;
    Hashtable<String, Integer> sysSpan2id = null;
    Hashtable<Integer, Integer> sysId2AlignId = null;
    Hashtable<Integer, Integer> goldId2AlignId = null;
    Hashtable<Integer, Integer> alignId2GoldId = null;
    int[] goldEqvCls;
    ParentPtrTree ppt;

    public GoldStandardLabeler(String dir, String doc, List<Annotation> lm) {
        int i;
        this.dir = dir;
        this.docName = doc;
        this.goldSpan2id = new Hashtable();
        this.sysSpan2id = new Hashtable();
        this.sysId2AlignId = new Hashtable();
        this.goldId2AlignId = new Hashtable();
        this.alignId2GoldId = new Hashtable();
        this.sysSpans = new Vector();
        this.goldSpans = new Vector();
        this.loadGoldStandard();
        this.loadSystemPairs(lm);
        SpanAlignment sa = new SpanAlignment(this.goldSpans.toArray(new Span[this.goldSpans.size()]), this.sysSpans.toArray(new Span[this.sysSpans.size()]));
        int[] id = sa.get1();
        for (i = 0; i < id.length; ++i) {
            this.alignId2GoldId.put(id[i], this.goldSpan2id.get(this.goldSpans.get(i).toString()));
            this.goldId2AlignId.put(this.goldSpan2id.get(this.goldSpans.get(i).toString()), id[i]);
        }
        id = sa.get2();
        for (i = 0; i < id.length; ++i) {
            this.sysId2AlignId.put(this.sysSpan2id.get(this.sysSpans.get(i).toString()), id[i]);
        }
    }

    public boolean isGoldPair(Annotation ann1, Annotation ann2) {
        if (!this.sysSpan2id.containsKey(ann1.getBegin() + "-" + ann1.getEnd())) {
            return false;
        }
        int sysId1 = this.sysSpan2id.get(ann1.getBegin() + "-" + ann1.getEnd());
        if (!this.sysSpan2id.containsKey(ann2.getBegin() + "-" + ann2.getEnd())) {
            return false;
        }
        int sysId2 = this.sysSpan2id.get(ann2.getBegin() + "-" + ann2.getEnd());
        int newId1 = this.sysId2AlignId.get(sysId1);
        int newId2 = this.sysId2AlignId.get(sysId2);
        if (!this.alignId2GoldId.containsKey(newId1)) {
            return false;
        }
        int goldId1 = this.alignId2GoldId.get(newId1);
        if (!this.alignId2GoldId.containsKey(newId2)) {
            return false;
        }
        int goldId2 = this.alignId2GoldId.get(newId2);
        return this.goldEqvCls[goldId1 - 1] == this.goldEqvCls[goldId2 - 1];
    }

    private void loadGoldStandard() {
        File f = new File(this.dir + File.separator + this.docName);
        Vector<int[]> goldPairs = new Vector<int[]>();
        int id = 0;
        try {
            String l;
            BufferedReader br = new BufferedReader(new FileReader(f));
            while ((l = br.readLine()) != null) {
                int i;
                int[] a;
                String[] s;
                String[] p = l.split("\\t");
                if (!this.goldSpan2id.containsKey(p[0])) {
                    this.goldSpan2id.put(p[0], ++id);
                    s = p[0].split("[-:]");
                    a = new int[s.length];
                    for (i = 0; i < s.length; ++i) {
                        a[i] = Integer.parseInt(s[i]);
                    }
                    this.goldSpans.add(new Span(a));
                }
                if (!this.goldSpan2id.containsKey(p[1])) {
                    this.goldSpan2id.put(p[1], ++id);
                    s = p[1].split("[-:]");
                    a = new int[s.length];
                    for (i = 0; i < s.length; ++i) {
                        a[i] = Integer.parseInt(s[i]);
                    }
                    this.goldSpans.add(new Span(a));
                }
                goldPairs.add(new int[]{this.goldSpan2id.get(p[0]), this.goldSpan2id.get(p[1])});
            }
            br.close();
            Collections.sort(this.goldSpans, new SpanOffsetComparator());
            this.ppt = new ParentPtrTree((int[][])goldPairs.toArray((T[])new int[0][]));
            this.goldEqvCls = new int[this.ppt.getSize()];
            this.ppt.equivCls(this.goldEqvCls);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void loadSystemPairs(List<Annotation> lm) {
        Vector<int[]> sysPairs = new Vector<int[]>();
        for (int p = 1; p < lm.size(); ++p) {
            Markable m1 = (Markable)lm.get(p);
            int id1 = m1.getId();
            if (!this.sysSpan2id.containsKey(m1.getBegin() + "-" + m1.getEnd())) {
                this.sysSpan2id.put(m1.getBegin() + "-" + m1.getEnd(), id1);
                this.sysSpans.add(new Span(new int[]{m1.getBegin(), m1.getEnd()}));
            }
            for (int q = p - 1; q >= 0; --q) {
                Markable m2 = (Markable)lm.get(q);
                int id2 = m2.getId();
                if (!this.sysSpan2id.containsKey(m2.getBegin() + "-" + m2.getEnd())) {
                    this.sysSpan2id.put(m2.getBegin() + "-" + m2.getEnd(), id2);
                    this.sysSpans.add(new Span(new int[]{m2.getBegin(), m2.getEnd()}));
                }
                sysPairs.add(new int[]{id1, id2});
            }
        }
        Collections.sort(this.sysSpans, new SpanOffsetComparator());
    }
}

