/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.coreference.ae;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.coreference.ae.features.AttributeFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.CorefSyntaxFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.DistSemFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.SalienceFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.SectionFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.StringMatchingFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.TemporalFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.TokenFeatureExtractor;
import org.apache.ctakes.coreference.ae.features.UMLSFeatureExtractor;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.relationextractor.ae.features.DependencyTreeFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.PartOfSpeechFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.PhraseChunkingExtractor;
import org.apache.ctakes.relationextractor.ae.features.RelationFeaturesExtractor;
import org.apache.ctakes.relationextractor.ae.features.TokenFeaturesExtractor;
import org.apache.ctakes.typesystem.type.relation.BinaryTextRelation;
import org.apache.ctakes.typesystem.type.relation.CollectionTextRelation;
import org.apache.ctakes.typesystem.type.relation.CoreferenceRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Markable;
import org.apache.ctakes.typesystem.type.textsem.MedicationEventMention;
import org.apache.ctakes.typesystem.type.textspan.Paragraph;
import org.apache.ctakes.typesystem.type.textspan.Segment;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.descriptor.ConfigurationParameter;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.EmptyFSList;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.jcas.cas.FSList;
import org.apache.uima.jcas.cas.FloatArray;
import org.apache.uima.jcas.cas.NonEmptyFSList;
import org.apache.uima.jcas.cas.TOP;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkProcessingException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.Feature;

@PipeBitInfo(name="Event Coreference Annotator", description="Annotates Event Coreferences.", dependencies={PipeBitInfo.TypeProduct.SECTION, PipeBitInfo.TypeProduct.DEPENDENCY_NODE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.MARKABLE}, products={PipeBitInfo.TypeProduct.COREFERENCE_RELATION})
public class EventCoreferenceAnnotator
extends RelationExtractorAnnotator {
    public static final String IDENTITY_RELATION = "Identity";
    public static final int DEFAULT_SENT_DIST = 5;
    public static final String PARAM_SENT_DIST = "SentenceDistance";
    @ConfigurationParameter(name="SentenceDistance", mandatory=false, description="Number of sentences allowed between coreferent mentions")
    private int maxSentDist = 5;
    public static final double DEFAULT_PAR_SIM = 0.5;
    public static final String PARAM_PAR_SIM = "PararaphSimilarity";
    @ConfigurationParameter(name="PararaphSimilarity", mandatory=false, description="Similarity required to pair paragraphs for coreference")
    private double simThreshold = 0.5;
    public static final boolean DEFAULT_SCORE_ALL = false;
    public static final String PARAM_SCORE_ALL = "ScoreAllPairs";
    @ConfigurationParameter(name="ScoreAllPairs", mandatory=false, description="Whether to score all pairs (as in a feature detector")
    private boolean scoreAll = false;
    private Map<ConllDependencyNode, Collection<IdentifiedAnnotation>> nodeEntMap = null;
    private Map<Markable, Set<String>> markableEnts = null;
    private List<Markable> markablesByConfidence = null;
    private Map<Annotation, NonEmptyFSList> chains = null;
    private double lastScore;
    private Logger logger = Logger.getLogger(EventCoreferenceAnnotator.class);
    protected HashSet<IdentifiedAnnotation> foundAnaphors = new HashSet();
    int numClassifications = 0;

    public static AnalysisEngineDescription createDataWriterDescription(Class<? extends DataWriter<String>> dataWriterClass, File outputDirectory, float downsamplingRate) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventCoreferenceAnnotator.class, (Object[])new Object[]{"isTraining", true, "ProbabilityOfKeepingANegativeExample", Float.valueOf(downsamplingRate), "dataWriterClassName", dataWriterClass, "outputDirectory", outputDirectory});
    }

    public static AnalysisEngineDescription createAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventCoreferenceAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath});
    }

    public static AnalysisEngineDescription createScoringAnnotatorDescription(String modelPath) throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(EventCoreferenceAnnotator.class, (Object[])new Object[]{"isTraining", false, "classifierJarPath", modelPath, PARAM_SCORE_ALL, true});
    }

    protected List<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> getFeatureExtractors() {
        ArrayList<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>> featureExtractorList = new ArrayList<RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>>();
        featureExtractorList.add((RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>)new TokenFeaturesExtractor());
        featureExtractorList.add((RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>)new PartOfSpeechFeaturesExtractor());
        featureExtractorList.add((RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>)new PhraseChunkingExtractor());
        featureExtractorList.add((RelationFeaturesExtractor<IdentifiedAnnotation, IdentifiedAnnotation>)new DependencyTreeFeaturesExtractor());
        featureExtractorList.add(new StringMatchingFeatureExtractor());
        featureExtractorList.add(new TokenFeatureExtractor());
        featureExtractorList.add(new SectionFeatureExtractor());
        featureExtractorList.add(new UMLSFeatureExtractor());
        featureExtractorList.add(new CorefSyntaxFeatureExtractor());
        featureExtractorList.add(new TemporalFeatureExtractor());
        featureExtractorList.add(new SalienceFeatureExtractor());
        featureExtractorList.add(new AttributeFeatureExtractor());
        try {
            featureExtractorList.add(new DistSemFeatureExtractor());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return featureExtractorList;
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        if (this.isTraining() && JCasUtil.select((JCas)jCas, CoreferenceRelation.class).size() == 0) {
            this.logger.debug((Object)"Skipping document with no gold standard coreference relations.");
            return;
        }
        this.numClassifications = 0;
        this.nodeEntMap = JCasUtil.indexCovering((JCas)jCas, ConllDependencyNode.class, IdentifiedAnnotation.class);
        this.markableEnts = new HashMap<Markable, Set<String>>();
        this.chains = new HashMap<Annotation, NonEmptyFSList>();
        this.markablesByConfidence = new ArrayList<Markable>(JCasUtil.select((JCas)jCas, Markable.class));
        Collections.sort(this.markablesByConfidence, new MarkableConfidenceComparator());
        for (Markable m : this.markablesByConfidence) {
            this.markableEnts.put(m, this.getBestEnt(jCas, m));
        }
        super.process(jCas);
        if (!this.isTraining() && !this.scoreAll) {
            for (NonEmptyFSList chainHead : new HashSet<NonEmptyFSList>(this.chains.values())) {
                CollectionTextRelation chain = new CollectionTextRelation(jCas);
                chain.setMembers((FSList)chainHead);
                NonEmptyFSList cur = chainHead;
                while (cur.getTail() != null) {
                    cur = (NonEmptyFSList)cur.getTail();
                }
                EmptyFSList tail = new EmptyFSList(jCas);
                tail.addToIndexes();
                cur.setTail((FSList)tail);
                chain.addToIndexes();
            }
        }
        this.logger.debug((Object)("This document had : " + this.numClassifications + " pair classifications"));
        this.foundAnaphors.clear();
        this.chains.clear();
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        super.collectionProcessComplete();
    }

    protected Iterable<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas jcas, Annotation segment) {
        return new PairIterable(jcas, segment);
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getClosePairs(JCas jcas, Annotation segment, double confidence) {
        ArrayList markables = new ArrayList(JCasUtil.select((JCas)jcas, Markable.class));
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        block0: for (int i = 1; i < markables.size(); ++i) {
            Markable ana = (Markable)markables.get(i);
            if (!EventCoreferenceAnnotator.dominates(segment, (Annotation)ana)) continue;
            Set<String> bestAnaTypes = this.getBestEnt(jcas, ana);
            for (int j = i - 1; j >= 0; --j) {
                int sentdist;
                Markable ante = (Markable)markables.get(j);
                if ((double)ante.getConfidence() < confidence) continue;
                if (!bestAnaTypes.contains(AnatomicalSiteMention.class.getSimpleName()) && !bestAnaTypes.contains(MedicationEventMention.class.getSimpleName()) && (sentdist = EventCoreferenceAnnotator.sentDist(jcas, (IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana)) > this.maxSentDist) continue block0;
                Set<String> bestAnteTypes = this.getBestEnt(jcas, ante);
                if (bestAnaTypes.size() > 0 && bestAnteTypes.size() > 0) {
                    boolean overlap = false;
                    for (String semType : bestAnaTypes) {
                        if (!bestAnteTypes.contains(semType)) continue;
                        overlap = true;
                    }
                    if (!overlap) continue;
                }
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana));
            }
        }
        return pairs;
    }

    public Set<String> getBestEnt(JCas jcas, Markable markable) {
        if (this.markableEnts.containsKey(markable)) {
            return this.markableEnts.get(markable);
        }
        HashSet<String> bestEnts = new HashSet<String>();
        Object bestEnt = null;
        HashSet<IdentifiedAnnotation> otherBestEnts = new HashSet<IdentifiedAnnotation>();
        ConllDependencyNode head = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)markable);
        Collection<IdentifiedAnnotation> coveringEnts = this.nodeEntMap.get(head);
        for (IdentifiedAnnotation ent : coveringEnts) {
            ConllDependencyNode entHead;
            if (ent.getOntologyConceptArr() == null || (entHead = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)ent)) != head) continue;
            if (bestEnt == null) {
                bestEnt = ent;
                continue;
            }
            if (ent.getEnd() - ent.getBegin() > bestEnt.getEnd() - bestEnt.getBegin()) {
                bestEnt = ent;
                otherBestEnts = new HashSet();
                continue;
            }
            if (ent.getEnd() - ent.getBegin() != bestEnt.getEnd() - bestEnt.getBegin()) continue;
            otherBestEnts.add(ent);
        }
        if (bestEnt != null) {
            bestEnts.add(bestEnt.getClass().getSimpleName());
            for (IdentifiedAnnotation other : otherBestEnts) {
                bestEnts.add(other.getClass().getSimpleName());
            }
        }
        return bestEnts;
    }

    public static boolean dominates(Annotation arg1, Annotation arg2) {
        return arg1.getBegin() <= arg2.getBegin() && arg1.getEnd() >= arg2.getEnd();
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getParagraphPairs(JCas jcas, Annotation segment) {
        int i;
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        ArrayList pars = new ArrayList(JCasUtil.select((JCas)jcas, Paragraph.class));
        double[][] sims = new double[pars.size()][pars.size()];
        for (i = 0; i < sims.length; ++i) {
            Arrays.fill(sims[i], 0.0);
        }
        for (i = 0; i < pars.size(); ++i) {
            List curParMarkables = JCasUtil.selectCovered(Markable.class, (AnnotationFS)((AnnotationFS)pars.get(i)));
            block2: for (int anaId = 1; anaId < curParMarkables.size(); ++anaId) {
                for (int anteId = anaId - 1; anteId >= 0; --anteId) {
                    Markable ana = (Markable)curParMarkables.get(anaId);
                    Markable ante = (Markable)curParMarkables.get(anteId);
                    int sentdist = EventCoreferenceAnnotator.sentDist(jcas, (IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana);
                    if (sentdist > this.maxSentDist) continue block2;
                    pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana));
                }
            }
        }
        return pairs;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getSimilarPairs(JCas jcas, Annotation segment) {
        int i;
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        FSArray parVecs = (FSArray)JCasUtil.selectSingle((JCas)jcas, FSArray.class);
        ArrayList pars = new ArrayList(JCasUtil.select((JCas)jcas, Paragraph.class));
        double[][] sims = new double[pars.size()][pars.size()];
        for (i = 0; i < sims.length; ++i) {
            Arrays.fill(sims[i], 0.0);
        }
        for (i = 0; i < pars.size(); ++i) {
            List curParMarkables = JCasUtil.selectCovered(Markable.class, (AnnotationFS)((AnnotationFS)pars.get(i)));
            FloatArray parVec = (FloatArray)parVecs.get(i);
            for (int j = i - 1; j >= 0; --j) {
                if (sims[i][j] == 0.0) {
                    FloatArray prevParVec = (FloatArray)parVecs.get(j);
                    sims[i][j] = EventCoreferenceAnnotator.calculateSimilarity(parVec, prevParVec);
                }
                if (!(sims[i][j] > this.simThreshold)) continue;
                List prevParMarkables = JCasUtil.selectCovered(Markable.class, (AnnotationFS)((AnnotationFS)pars.get(j)));
                block3: for (int anaId = 0; anaId < curParMarkables.size(); ++anaId) {
                    for (int anteId = prevParMarkables.size() - 1; anteId >= 0; --anteId) {
                        Markable ana = (Markable)curParMarkables.get(anaId);
                        Markable ante = (Markable)prevParMarkables.get(anteId);
                        int sentdist = EventCoreferenceAnnotator.sentDist(jcas, (IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana);
                        if (sentdist > this.maxSentDist) continue block3;
                        pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana));
                    }
                }
            }
        }
        return pairs;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getConfidentPairs(JCas jcas, Annotation segment, double threshold) {
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        List anas = JCasUtil.selectCovered(Markable.class, (AnnotationFS)segment);
        for (Markable ana : anas) {
            for (Markable ante : this.markablesByConfidence) {
                if ((double)ante.getConfidence() < threshold) break;
                if (ante.getBegin() > ana.getBegin() && ante.getEnd() > ante.getEnd()) continue;
                boolean match = false;
                if (this.markableEnts.get(ana).size() > 0) {
                    if (this.markableEnts.get(ante).size() == 0) {
                        match = true;
                    } else {
                        for (String semType : this.markableEnts.get(ana)) {
                            if (!this.markableEnts.get(ante).contains(semType)) continue;
                            match = true;
                            break;
                        }
                    }
                } else {
                    match = true;
                }
                if (!match) continue;
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana));
            }
        }
        return pairs;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getSectionHeaderPairs(JCas jcas, Annotation segment, double confidence) {
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        List markables = JCasUtil.selectCovered((JCas)jcas, Markable.class, (AnnotationFS)segment);
        for (int i = 0; i < markables.size(); ++i) {
            IdentifiedAnnotation ana = (IdentifiedAnnotation)markables.get(i);
            List pars = JCasUtil.selectCovered((JCas)jcas, Paragraph.class, (int)0, (int)ana.getBegin());
            for (int j = 0; j < pars.size(); ++j) {
                Paragraph par = (Paragraph)pars.get(j);
                List coveredSents = JCasUtil.selectCovered((JCas)jcas, Sentence.class, (AnnotationFS)par);
                if (coveredSents == null || coveredSents.size() != 1) continue;
                for (Markable anteCandidate : JCasUtil.selectCovered((JCas)jcas, Markable.class, (AnnotationFS)par)) {
                    if (!((double)anteCandidate.getConfidence() > confidence)) continue;
                    pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)anteCandidate, ana));
                }
            }
        }
        return pairs;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getAlreadyLinkedPairs(JCas jcas, Annotation segment) {
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        ArrayList segMarkables = new ArrayList(JCasUtil.selectCovered((JCas)jcas, Markable.class, (AnnotationFS)segment));
        for (int i = 0; i < segMarkables.size(); ++i) {
            Markable ana = (Markable)segMarkables.get(i);
            for (CollectionTextRelation chain : JCasUtil.select((JCas)jcas, CollectionTextRelation.class)) {
                Markable m;
                FSList head = chain.getMembers();
                Markable last = null;
                while (head instanceof NonEmptyFSList && (m = (Markable)((NonEmptyFSList)head).getHead()) != null && m.getEnd() <= ana.getEnd()) {
                    if (m.getBegin() != ana.getBegin() || m.getEnd() != ana.getEnd()) {
                        last = m;
                    }
                    head = ((NonEmptyFSList)head).getTail();
                }
                if (last == null) continue;
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair(last, (IdentifiedAnnotation)ana));
            }
        }
        return pairs;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getHeadwordMatchingPairs(JCas jcas, Annotation segment) {
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        ArrayList segMarkables = new ArrayList(JCasUtil.selectCovered((JCas)jcas, Markable.class, (AnnotationFS)segment));
        for (int i = 0; i < segMarkables.size(); ++i) {
            Markable ana = (Markable)segMarkables.get(i);
            ConllDependencyNode headNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)ana);
            String headword = null;
            if (headNode == null) continue;
            headword = headNode.getCoveredText().toLowerCase();
            List previousMarkables = JCasUtil.selectCovered((JCas)jcas, Markable.class, (int)0, (int)ana.getBegin());
            for (int j = 0; j < previousMarkables.size(); ++j) {
                String anteHeadword;
                Markable ante = (Markable)previousMarkables.get(j);
                ConllDependencyNode anteNode = DependencyUtility.getNominalHeadNode((JCas)jcas, (Annotation)ante);
                if (anteNode == null || !headword.equals(anteHeadword = anteNode.getCoveredText().toLowerCase())) continue;
                pairs.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)ante, (IdentifiedAnnotation)ana));
            }
        }
        return pairs;
    }

    protected String classify(List<Feature> features) throws CleartkProcessingException {
        ++this.numClassifications;
        String category = (String)this.classifier.classify(features);
        if (this.scoreAll) {
            Map scores = this.classifier.score(features);
            this.lastScore = (Double)scores.get(IDENTITY_RELATION);
            category = IDENTITY_RELATION;
        }
        return category;
    }

    protected Class<? extends Annotation> getCoveringClass() {
        return Segment.class;
    }

    protected Class<? extends BinaryTextRelation> getRelationClass() {
        return CoreferenceRelation.class;
    }

    protected void createRelation(JCas jCas, IdentifiedAnnotation ante, IdentifiedAnnotation ana, String predictedCategory) {
        if (this.scoreAll) {
            CoreferenceRelation relation = this.buildRelation(jCas, (Annotation)ante, (Annotation)ana, predictedCategory);
            relation.setConfidence(this.lastScore);
            relation.addToIndexes();
        } else if (!this.foundAnaphors.contains(ana)) {
            CoreferenceRelation relation = this.buildRelation(jCas, (Annotation)ante, (Annotation)ana, predictedCategory);
            relation.addToIndexes();
            this.foundAnaphors.add(ana);
            if (!this.chains.containsKey(ante)) {
                NonEmptyFSList anteEl = new NonEmptyFSList(jCas);
                NonEmptyFSList anaEl = new NonEmptyFSList(jCas);
                anteEl.setHead((TOP)ante);
                anaEl.setHead((TOP)ana);
                anteEl.setTail((FSList)anaEl);
                anaEl.setTail(null);
                this.chains.put((Annotation)ante, anteEl);
                this.chains.put((Annotation)ana, anteEl);
                anaEl.addToIndexes();
                anteEl.addToIndexes();
            } else {
                NonEmptyFSList oldChain;
                NonEmptyFSList chainEnd = oldChain = this.chains.get(ante);
                NonEmptyFSList anaEl = new NonEmptyFSList(jCas);
                anaEl.setHead((TOP)ana);
                anaEl.setTail(null);
                while (chainEnd.getTail() != null) {
                    chainEnd = (NonEmptyFSList)chainEnd.getTail();
                }
                chainEnd.setTail((FSList)anaEl);
                this.chains.put((Annotation)ana, oldChain);
                anaEl.addToIndexes();
            }
        } else {
            this.logger.error((Object)"Greedy coreference resolution violated -- anaphor linked to two candidate antecedents!");
        }
    }

    private CoreferenceRelation buildRelation(JCas jCas, Annotation ante, Annotation ana, String predictedCategory) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument(ante);
        relArg1.setRole("Antecedent");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument(ana);
        relArg2.setRole("Anaphor");
        relArg2.addToIndexes();
        CoreferenceRelation relation = new CoreferenceRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory(predictedCategory);
        return relation;
    }

    protected String getRelationCategory(Map<List<Annotation>, BinaryTextRelation> relationLookup, IdentifiedAnnotation ante, IdentifiedAnnotation ana) {
        String cat = super.getRelationCategory(relationLookup, ante, ana);
        int dist = EventCoreferenceAnnotator.sentsBetween(ante, ana);
        if (cat != null && !cat.equals("-NONE-")) {
            this.foundAnaphors.add(ana);
            this.logger.info((Object)String.format("DISTSALIENCE: (%d,%f,1)\n", dist, Float.valueOf(ante.getConfidence())));
        } else if (Math.random() < 0.1) {
            this.logger.info((Object)String.format("DISTSALIENCE: (%d,%f,0)\n", dist, Float.valueOf(ante.getConfidence())));
        }
        return cat;
    }

    public static int sentDist(JCas jcas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        return JCasUtil.selectCovered((JCas)jcas, Sentence.class, (int)arg1.getBegin(), (int)arg2.getEnd()).size();
    }

    public static int sentsBetween(IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        List sents = JCasUtil.selectBetween(Sentence.class, (AnnotationFS)arg1, (AnnotationFS)arg2);
        return sents.size();
    }

    private static double calculateSimilarity(FloatArray f1, FloatArray f2) {
        double sim = 0.0;
        double f1len = 0.0;
        double f2len = 0.0;
        for (int i = 0; i < f1.size(); ++i) {
            sim += (double)(f1.get(i) * f2.get(i));
            f1len += (double)(f1.get(i) * f1.get(i));
            f2len += (double)(f2.get(i) * f2.get(i));
        }
        f1len = Math.sqrt(f1len);
        f2len = Math.sqrt(f2len);
        return sim /= f1len * f2len;
    }

    private class AnnotationComparator
    implements Comparator<Annotation> {
        @Override
        public int compare(Annotation o1, Annotation o2) {
            if (o1.getBegin() < o2.getBegin()) {
                return -1;
            }
            if (o1.getBegin() == o2.getBegin() && o1.getEnd() < o2.getEnd()) {
                return -1;
            }
            if (o1.getBegin() == o2.getBegin() && o1.getEnd() > o2.getEnd()) {
                return 1;
            }
            if (o2.getBegin() < o1.getBegin()) {
                return 1;
            }
            return 0;
        }
    }

    public class IdentifiedAnnotationPairComparator
    implements Comparator<RelationExtractorAnnotator.IdentifiedAnnotationPair> {
        @Override
        public int compare(RelationExtractorAnnotator.IdentifiedAnnotationPair o1, RelationExtractorAnnotator.IdentifiedAnnotationPair o2) {
            if (o1 == o2) {
                return 0;
            }
            IdentifiedAnnotation ante1 = o1.getArg1();
            IdentifiedAnnotation ante2 = o2.getArg1();
            IdentifiedAnnotation ana1 = o1.getArg2();
            IdentifiedAnnotation ana2 = o2.getArg2();
            int sim = ana1.getBegin() != ana2.getBegin() ? (ana1.getBegin() - ana2.getBegin() > 0 ? 1 : -1) : (ana1.getEnd() != ana2.getEnd() ? (ana1.getEnd() - ana2.getEnd() > 0 ? 1 : -1) : (ante1.getBegin() != ante2.getBegin() ? (ante1.getBegin() - ante2.getBegin() > 0 ? 1 : -1) : (ante1.getEnd() != ante2.getEnd() ? (ante1.getEnd() - ante2.getEnd() > 0 ? 1 : -1) : 0)));
            return sim;
        }
    }

    public class MarkableConfidenceComparator
    implements Comparator<Markable> {
        @Override
        public int compare(Markable m1, Markable m2) {
            if (m1 == m2) {
                return 0;
            }
            if (m1.getConfidence() > m2.getConfidence()) {
                return -1;
            }
            if (m1.getConfidence() < m2.getConfidence()) {
                return 1;
            }
            return 0;
        }
    }

    public class MarkablePairConfidenceComparator
    implements Comparator<RelationExtractorAnnotator.IdentifiedAnnotationPair> {
        @Override
        public int compare(RelationExtractorAnnotator.IdentifiedAnnotationPair o1, RelationExtractorAnnotator.IdentifiedAnnotationPair o2) {
            if (o1 == o2) {
                return 0;
            }
            IdentifiedAnnotation ante1 = o1.getArg1();
            IdentifiedAnnotation ante2 = o2.getArg1();
            IdentifiedAnnotation ana1 = o1.getArg2();
            IdentifiedAnnotation ana2 = o2.getArg2();
            int sim = ana1.getBegin() != ana2.getBegin() ? (ana1.getBegin() - ana2.getBegin() > 0 ? 1 : -1) : (ana1.getEnd() != ana2.getEnd() ? (ana1.getEnd() - ana2.getEnd() > 0 ? 1 : -1) : (ante1.getConfidence() > ante2.getConfidence() ? -1 : (ante1.getConfidence() < ante2.getConfidence() ? 1 : 0)));
            return sim;
        }
    }

    class PairIterator
    implements Iterator<RelationExtractorAnnotator.IdentifiedAnnotationPair> {
        JCas jcas = null;
        Annotation segment = null;
        List<RelationExtractorAnnotator.IdentifiedAnnotationPair> pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        List<RelationExtractorAnnotator.IdentifiedAnnotationPair> pass2Pairs = null;
        RelationExtractorAnnotator.IdentifiedAnnotationPair next = null;

        public PairIterator(JCas jcas, Annotation segment) {
            this.jcas = jcas;
            this.segment = segment;
            this.pairs.addAll(EventCoreferenceAnnotator.this.getClosePairs(jcas, segment, 0.0));
            this.pairs.addAll(EventCoreferenceAnnotator.this.getSectionHeaderPairs(jcas, segment, 0.0));
            this.pairs.addAll(EventCoreferenceAnnotator.this.getAlreadyLinkedPairs(jcas, segment));
            this.pairs.addAll(EventCoreferenceAnnotator.this.getHeadwordMatchingPairs(jcas, segment));
        }

        @Override
        public boolean hasNext() {
            IdentifiedAnnotation ana;
            IdentifiedAnnotation ante;
            while (this.pairs.size() > 0) {
                this.next = this.pairs.remove(0);
                ante = this.next.getArg1();
                if (EventCoreferenceAnnotator.dominates((Annotation)ante, (Annotation)(ana = this.next.getArg2())) || EventCoreferenceAnnotator.dominates((Annotation)ana, (Annotation)ante) || EventCoreferenceAnnotator.this.foundAnaphors.contains(ana)) continue;
                return true;
            }
            if (this.pass2Pairs == null) {
                this.pass2Pairs = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
            }
            while (this.pass2Pairs.size() > 0) {
                this.next = this.pass2Pairs.remove(0);
                ante = this.next.getArg1();
                if (EventCoreferenceAnnotator.dominates((Annotation)ante, (Annotation)(ana = this.next.getArg2())) || EventCoreferenceAnnotator.dominates((Annotation)ana, (Annotation)ante) || EventCoreferenceAnnotator.this.foundAnaphors.contains(ana)) continue;
                return true;
            }
            return false;
        }

        @Override
        public RelationExtractorAnnotator.IdentifiedAnnotationPair next() {
            ++EventCoreferenceAnnotator.this.numClassifications;
            return this.next;
        }

        @Override
        public void remove() {
        }
    }

    class PairIterable
    implements Iterable<RelationExtractorAnnotator.IdentifiedAnnotationPair> {
        PairIterator iter = null;

        public PairIterable(JCas jcas, Annotation segment) {
            this.iter = new PairIterator(jcas, segment);
        }

        @Override
        public Iterator<RelationExtractorAnnotator.IdentifiedAnnotationPair> iterator() {
            return this.iter;
        }
    }
}

