/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.ytex;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.ctakes.ytex.kernel.tree.InstanceTreeBuilder;
import org.apache.ctakes.ytex.kernel.tree.TreeMappingInfo;
import org.springframework.context.ApplicationContext;
import org.springframework.context.access.ContextSingletonBeanFactoryLocator;
import org.springframework.context.support.FileSystemXmlApplicationContext;

public class KernelLauncher {
    private static Options initOptions() {
        OptionBuilder.withArgName((String)"instanceMap.obj");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"store the instanceMap.  Use prior to running the kernel evaluations in parallel.");
        Option oStoreInstanceMap = OptionBuilder.create((String)"storeInstanceMap");
        OptionBuilder.withDescription((String)"evaluate kernel specified in application context on the instances. If instanceMap is specified, load instance from file system, else from db.");
        Option oEvaluateKernel = OptionBuilder.create((String)"evalKernel");
        OptionBuilder.withDescription((String)"exportBagOfWords.  Must specify property file");
        OptionBuilder.hasArg();
        Option exportBagOfWords = OptionBuilder.create((String)"exportBagOfWords");
        OptionBuilder.withDescription((String)"exportType.  either libsvm or weka");
        OptionBuilder.hasArg();
        Option exportType = OptionBuilder.create((String)"exportType");
        OptionBuilder.withArgName((String)"instanceMap.obj");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"load instanceMap from file system instead of from db.  Use after storing instance map.");
        Option oLoadInstanceMap = OptionBuilder.create((String)"loadInstanceMap");
        OptionBuilder.withDescription((String)"for parallelization, split the instances into mod slices");
        OptionBuilder.hasArg();
        Option oEvalMod = OptionBuilder.create((String)"mod");
        OptionBuilder.withDescription((String)"for parallelization, parameter that determines which slice we work on.  If this is not specified, nMod threads will be started to evaluate all slices in parallel.");
        OptionBuilder.hasArg();
        Option oEvalSlice = OptionBuilder.create((String)"slice");
        OptionBuilder.withArgName((String)"classpath*:simSvcBeanRefContext.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use specified beanRefContext.xml, default classpath*:simSvcBeanRefContext.xml");
        Option oBeanref = OptionBuilder.create((String)"beanref");
        OptionBuilder.withArgName((String)"kernelApplicationContext");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use specified applicationContext, default kernelApplicationContext");
        Option oAppctx = OptionBuilder.create((String)"appctx");
        OptionBuilder.withArgName((String)"beans-corpus.xml");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"use specified beans.xml, no default.  This file is typically required.");
        Option oBeans = OptionBuilder.create((String)"beans");
        Option oHelp = new Option("help", "print this message");
        Options options = new Options();
        OptionGroup og = new OptionGroup();
        og.addOption(oStoreInstanceMap);
        og.addOption(oEvaluateKernel);
        og.addOption(exportBagOfWords);
        options.addOptionGroup(og);
        options.addOption(oEvaluateKernel);
        options.addOption(exportType);
        options.addOption(oLoadInstanceMap);
        options.addOption(oEvalMod);
        options.addOption(oEvalSlice);
        options.addOption(oBeanref);
        options.addOption(oAppctx);
        options.addOption(oBeans);
        options.addOption(oHelp);
        return options;
    }

    private static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("java org.apache.ctakes.ytex.kernel.evaluator.CorpusKernelEvaluatorImpl\n Main Options: -storeInstanceMap or -evalKernel", options);
    }

    public static void main(String[] args) throws Exception {
        Options options = KernelLauncher.initOptions();
        if (args.length == 0) {
            KernelLauncher.printHelp(options);
        } else {
            GnuParser parser = new GnuParser();
            try {
                CommandLine line = parser.parse(options, args);
                String storeInstanceMap = line.getOptionValue("storeInstanceMap");
                boolean evalKernel = line.hasOption("evalKernel");
                String exportBagOfWords = line.getOptionValue("exportBagOfWords");
                if (!evalKernel && storeInstanceMap == null && exportBagOfWords == null) {
                    System.out.println("specify either -evalKernel, -storeInstanceMap, or -exportBagOfWords");
                    KernelLauncher.printHelp(options);
                } else {
                    ApplicationContext appCtx;
                    String beanRefContext = line.getOptionValue("beanref", evalKernel ? "classpath*:org/apache/ctakes/ytex/simSvcBeanRefContext.xml" : "classpath*:org/apache/ctakes/ytex/kernelBeanRefContext.xml");
                    String contextName = line.getOptionValue("appctx", "kernelApplicationContext");
                    String beans = line.getOptionValue("beans");
                    ApplicationContext appCtxSource = appCtx = (ApplicationContext)ContextSingletonBeanFactoryLocator.getInstance((String)beanRefContext).useBeanFactory(contextName).getFactory();
                    if (beans != null) {
                        appCtxSource = new FileSystemXmlApplicationContext(new String[]{beans}, appCtx);
                    }
                    if (storeInstanceMap != null) {
                        KernelLauncher.storeInstanceMap(appCtxSource, storeInstanceMap, line);
                    }
                }
            }
            catch (ParseException e) {
                KernelLauncher.printHelp(options);
                throw e;
            }
        }
    }

    private static void storeInstanceMap(ApplicationContext appCtxSource, String storeInstanceMap, CommandLine line) throws Exception {
        InstanceTreeBuilder builder = (InstanceTreeBuilder)appCtxSource.getBean("instanceTreeBuilder", InstanceTreeBuilder.class);
        builder.serializeInstanceTrees((TreeMappingInfo)appCtxSource.getBean("treeMappingInfo", TreeMappingInfo.class), storeInstanceMap);
    }
}

