/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.jdl.data.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.xml.sax.SAXException;

public final class SchemaUtil {
    private SchemaUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Schema srcToSchema(String srcXsd) {
        Schema schema;
        block7: {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            File f = new File(srcXsd);
            if (f.exists()) {
                return factory.newSchema(new File(srcXsd));
            }
            InputStream is = null;
            try {
                is = SchemaUtil.class.getClassLoader().getResourceAsStream(srcXsd);
                schema = factory.newSchema(new StreamSource(is));
                if (is == null) break block7;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        is.close();
                    }
                    throw throwable;
                }
                catch (IOException | SAXException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            is.close();
        }
        return schema;
    }

    public static Schema urlToSchema(URL url) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return factory.newSchema(url);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Schema strToSchema(String strXsd) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            return factory.newSchema(new StreamSource(new StringReader(strXsd)));
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
    }
}

