/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.core.resource;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.ctakes.core.resource.StringIntegerMapResource;
import org.apache.log4j.Logger;
import org.apache.uima.resource.DataResource;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.SharedResourceObject;

public class StringIntegerMapResourceImpl
implements StringIntegerMapResource,
SharedResourceObject {
    private Logger iv_logger = Logger.getLogger((String)this.getClass().getName());
    private final String DELIMITER = "|";
    Map<String, Integer> iv_map = new HashMap<String, Integer>();

    public void load(DataResource dr) throws ResourceInitializationException {
        this.iv_logger.info((Object)("Loading resource: " + dr.getUrl()));
        try {
            InputStream inStream = dr.getInputStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(inStream));
            int lineCount = 0;
            String line = br.readLine();
            while (line != null) {
                ++lineCount;
                StringTokenizer st = new StringTokenizer(line, "|");
                if (st.countTokens() == 2) {
                    String key = st.nextToken();
                    try {
                        Integer value = new Integer(st.nextToken());
                        this.iv_map.put(key, value);
                    }
                    catch (NumberFormatException nfe) {
                        this.iv_logger.warn((Object)("Invalid resource line, expected integer: " + line));
                    }
                } else {
                    this.iv_logger.warn((Object)"Invalid resource line, expected 2 tokens only.");
                }
                line = br.readLine();
            }
            br.close();
            this.iv_logger.info((Object)("Loaded resource, # lines=" + lineCount));
        }
        catch (IOException ioe) {
            throw new ResourceInitializationException((Throwable)ioe);
        }
    }

    public Map getMap() {
        return this.iv_map;
    }
}

