/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup.ae;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.ctakes.dictionary.lookup.ae.LookupConsumer;
import org.apache.ctakes.dictionary.lookup.vo.LookupHit;

public abstract class BaseLookupConsumerImpl
implements LookupConsumer {
    protected static Iterator<Set<LookupHit>> organizeByOffset(Iterator<LookupHit> lookupHitIterator) {
        Map<LookupHitKey, Set<LookupHit>> lookupHitMap = BaseLookupConsumerImpl.createLookupHitMap(lookupHitIterator);
        return lookupHitMap.values().iterator();
    }

    protected static Map<LookupHitKey, Set<LookupHit>> createLookupHitMap(Iterator<LookupHit> lookupHitIterator) {
        HashMap<LookupHitKey, Set<LookupHit>> lookupHitMap = new HashMap<LookupHitKey, Set<LookupHit>>();
        while (lookupHitIterator.hasNext()) {
            LookupHit lookupHit = lookupHitIterator.next();
            LookupHitKey key = new LookupHitKey(lookupHit);
            HashSet<LookupHit> lookupHits = (HashSet<LookupHit>)lookupHitMap.get(key);
            if (lookupHits == null) {
                lookupHits = new HashSet<LookupHit>();
                lookupHitMap.put(key, lookupHits);
            }
            lookupHits.add(lookupHit);
        }
        return lookupHitMap;
    }

    protected static class LookupHitKey {
        protected final int __start;
        protected final int __end;
        private final int __hashCode;

        private LookupHitKey(LookupHit lookupHit) {
            this.__start = lookupHit.getStartOffset();
            this.__end = lookupHit.getEndOffset();
            this.__hashCode = 1000 * this.__end + this.__start;
        }

        public int hashCode() {
            return this.__hashCode;
        }

        public boolean equals(Object object) {
            return object instanceof LookupHitKey && this.__start == ((LookupHitKey)object).__start && this.__end == ((LookupHitKey)object).__end;
        }
    }
}

