/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.metastasis;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.relation.LocationOfTextRelation;
import org.apache.ctakes.typesystem.type.relation.RelationArgument;
import org.apache.ctakes.typesystem.type.textsem.AnatomicalSiteMention;
import org.apache.ctakes.typesystem.type.textsem.DiseaseDisorderMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.log4j.Logger;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.util.ViewUriUtil;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;

@PipeBitInfo(name="Anafora XML Reader (Metastasis)", description="Reads annotations from DeepPhe schema Anafora XML files in a directory.", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION, PipeBitInfo.TypeProduct.LOCATION_RELATION})
public class MetastasisAnaforaXMLReader
extends JCasAnnotator_ImplBase {
    private static Logger LOGGER = Logger.getLogger(MetastasisAnaforaXMLReader.class);

    public static AnalysisEngineDescription getDescription() throws ResourceInitializationException {
        return AnalysisEngineFactory.createEngineDescription(MetastasisAnaforaXMLReader.class, (Object[])new Object[0]);
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        String textFileName = ViewUriUtil.getURI((JCas)jCas).getPath();
        String xmlFileNameAlternative1 = textFileName + ".UmlsDeepPhe.dave.completed.xml";
        String xmlFileNameAlternative2 = textFileName + ".UmlsDeepPhe.dave.inprogress.xml";
        File xmlFileAlternative1 = new File(xmlFileNameAlternative1);
        File xmlFileAlternative2 = new File(xmlFileNameAlternative2);
        if (xmlFileAlternative1.exists()) {
            LOGGER.info((Object)("processing xml file: " + xmlFileNameAlternative1));
            MetastasisAnaforaXMLReader.processXmlFile(jCas, xmlFileAlternative1);
        } else if (xmlFileAlternative2.exists()) {
            LOGGER.info((Object)("processing xml file: " + xmlFileNameAlternative2));
            MetastasisAnaforaXMLReader.processXmlFile(jCas, xmlFileAlternative2);
        } else {
            throw new IllegalArgumentException("no Anafora XML file found for " + textFileName);
        }
    }

    private static void processXmlFile(JCas jCas, File xmlFile) throws AnalysisEngineProcessException {
        Element dataElem;
        try {
            dataElem = new SAXBuilder().build(xmlFile.toURI().toURL()).getRootElement();
        }
        catch (MalformedURLException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (JDOMException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        catch (IOException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
        for (Element annotationsElem : dataElem.getChildren("annotations")) {
            HashMap idToAnnotation = Maps.newHashMap();
            HashMap diseaseDisorderToAnatomicalSites = Maps.newHashMap();
            for (Element entityElem : annotationsElem.getChildren("entity")) {
                String annotationId = MetastasisAnaforaXMLReader.removeSingleChildText(entityElem, "id", null);
                Element spanElem = MetastasisAnaforaXMLReader.removeSingleChild(entityElem, "span", annotationId);
                String type = MetastasisAnaforaXMLReader.removeSingleChildText(entityElem, "type", annotationId);
                Element propertiesElem = MetastasisAnaforaXMLReader.removeSingleChild(entityElem, "properties", annotationId);
                int begin = Integer.MAX_VALUE;
                int end = Integer.MIN_VALUE;
                for (String spanString : spanElem.getText().split(";")) {
                    String[] beginEndStrings = spanString.split(",");
                    if (beginEndStrings.length != 2) {
                        MetastasisAnaforaXMLReader.error("span not of the format 'number,number'", annotationId);
                    }
                    int spanBegin = Integer.parseInt(beginEndStrings[0]);
                    int spanEnd = Integer.parseInt(beginEndStrings[1]);
                    if (spanBegin < begin) {
                        begin = spanBegin;
                    }
                    if (spanEnd <= end) continue;
                    end = spanEnd;
                }
                if (type.equals("Disease_Disorder") || type.equals("Metastasis")) {
                    DiseaseDisorderMention diseaseDisorderMention = new DiseaseDisorderMention(jCas, begin, end);
                    diseaseDisorderMention.setTypeID(2);
                    diseaseDisorderMention.addToIndexes();
                    idToAnnotation.put(annotationId, diseaseDisorderMention);
                    ArrayList anatomicalSiteIds = Lists.newArrayList();
                    for (Element child : propertiesElem.getChildren("body_location")) {
                        String bodyLocationId = child.getText();
                        if (bodyLocationId.equals("")) continue;
                        anatomicalSiteIds.add(bodyLocationId);
                    }
                    diseaseDisorderToAnatomicalSites.put(annotationId, anatomicalSiteIds);
                    continue;
                }
                if (!type.equals("Anatomical_site")) continue;
                AnatomicalSiteMention anatomicalSiteMention = new AnatomicalSiteMention(jCas, begin, end);
                anatomicalSiteMention.setTypeID(6);
                anatomicalSiteMention.addToIndexes();
                idToAnnotation.put(annotationId, anatomicalSiteMention);
            }
            for (String diseaseDisorderId : diseaseDisorderToAnatomicalSites.keySet()) {
                IdentifiedAnnotation diseaseDisorderMention = (IdentifiedAnnotation)idToAnnotation.get(diseaseDisorderId);
                for (String anatomicalSiteId : (List)diseaseDisorderToAnatomicalSites.get(diseaseDisorderId)) {
                    IdentifiedAnnotation anatomicalSiteMention = (IdentifiedAnnotation)idToAnnotation.get(anatomicalSiteId);
                    MetastasisAnaforaXMLReader.createLocationOfRelation(jCas, diseaseDisorderMention, anatomicalSiteMention);
                }
            }
        }
    }

    private static Element getSingleChild(Element elem, String elemName, String causeID) {
        List children = elem.getChildren(elemName);
        if (children.size() != 1) {
            MetastasisAnaforaXMLReader.error(String.format("not exactly one '%s' child", elemName), causeID);
        }
        return children.size() > 0 ? (Element)children.get(0) : null;
    }

    private static Element removeSingleChild(Element elem, String elemName, String causeID) {
        Element child = MetastasisAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        elem.removeChildren(elemName);
        return child;
    }

    private static String removeSingleChildText(Element elem, String elemName, String causeID) {
        Element child = MetastasisAnaforaXMLReader.getSingleChild(elem, elemName, causeID);
        String text = child.getText();
        if (text.isEmpty()) {
            MetastasisAnaforaXMLReader.error(String.format("an empty '%s' child", elemName), causeID);
            text = null;
        }
        elem.removeChildren(elemName);
        return text;
    }

    private static void error(String found, String id) {
        LOGGER.error((Object)String.format("found %s in annotation with ID %s", found, id));
    }

    private static void createLocationOfRelation(JCas jCas, IdentifiedAnnotation arg1, IdentifiedAnnotation arg2) {
        RelationArgument relArg1 = new RelationArgument(jCas);
        relArg1.setArgument((Annotation)arg1);
        relArg1.setRole("Argument");
        relArg1.addToIndexes();
        RelationArgument relArg2 = new RelationArgument(jCas);
        relArg2.setArgument((Annotation)arg2);
        relArg2.setRole("Related_to");
        relArg2.addToIndexes();
        LocationOfTextRelation relation = new LocationOfTextRelation(jCas);
        relation.setArg1(relArg1);
        relation.setArg2(relArg2);
        relation.setCategory("location_of");
        relation.addToIndexes();
    }
}

