/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.data;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.ctakes.relationextractor.data.GoldAnnotationStatsCalculator;
import org.apache.ctakes.relationextractor.eval.XMIReader;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.collection.CollectionReader;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class GoldAnnotationAnalysisPipeline {
    public static void main(String[] args) throws Exception {
        Options options = new Options();
        CmdLineParser parser = new CmdLineParser((Object)options);
        parser.parseArgument(args);
        List<File> trainFiles = Arrays.asList(options.inputDirectory.listFiles());
        CollectionReader collectionReader = GoldAnnotationAnalysisPipeline.getCollectionReader(trainFiles);
        AnalysisEngine goldAnnotationStatsCalculator = AnalysisEngineFactory.createEngine(GoldAnnotationStatsCalculator.class, (Object[])new Object[0]);
        SimplePipeline.runPipeline((CollectionReader)collectionReader, (AnalysisEngine[])new AnalysisEngine[]{goldAnnotationStatsCalculator});
    }

    private static CollectionReader getCollectionReader(List<File> items) throws Exception {
        String[] paths = new String[items.size()];
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = items.get(i).getPath();
        }
        return CollectionReaderFactory.createReader(XMIReader.class, (Object[])new Object[]{"files", paths});
    }

    public static class Options {
        @Option(name="--input-dir", usage="specify the path to the directory containing the clinical notes to be processed", required=true)
        public File inputDirectory;
    }
}

