/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.relationextractor.ae.baselines;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Ordering;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.relationextractor.ae.RelationExtractorAnnotator;
import org.apache.ctakes.typesystem.type.syntax.BaseToken;
import org.apache.ctakes.typesystem.type.textsem.EntityMention;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textsem.Modifier;
import org.apache.ctakes.typesystem.type.textspan.Sentence;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.Feature;

@PipeBitInfo(name="Degree of Annotator 3", description="Annotates Degree Of relations between two shortest-distance entities in sentences as long as there is no intervening modifier.", role=PipeBitInfo.Role.ANNOTATOR, dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION}, products={PipeBitInfo.TypeProduct.DEGREE_RELATION})
public class Baseline3DegreeOfRelationExtractorAnnotator
extends RelationExtractorAnnotator {
    @Override
    public Class<? extends Annotation> getCoveringClass() {
        return Sentence.class;
    }

    public List<RelationExtractorAnnotator.IdentifiedAnnotationPair> getCandidateRelationArgumentPairs(JCas identifiedAnnotationView, Annotation sentence) {
        List entityMentions = JCasUtil.selectCovered((JCas)identifiedAnnotationView, EntityMention.class, (AnnotationFS)sentence);
        List modifiers = JCasUtil.selectCovered((JCas)identifiedAnnotationView, Modifier.class, (AnnotationFS)sentence);
        List<EntityMention> entitiesSuitableForDegreeOf = Baseline3DegreeOfRelationExtractorAnnotator.getEntitiesSuitableForDegreeOf(entityMentions);
        if (entitiesSuitableForDegreeOf.size() < 1 || modifiers.size() < 1) {
            return new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        }
        ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair> result = new ArrayList<RelationExtractorAnnotator.IdentifiedAnnotationPair>();
        HashSet<EntityMention> alreadyLinked = new HashSet<EntityMention>();
        for (Modifier modifier : modifiers) {
            EntityMention nearestEntity;
            if (Baseline3DegreeOfRelationExtractorAnnotator.checkForModifierBetween(identifiedAnnotationView, modifier, nearestEntity = Baseline3DegreeOfRelationExtractorAnnotator.getNearestEntity(identifiedAnnotationView, modifier, entitiesSuitableForDegreeOf)) || alreadyLinked.contains(nearestEntity)) continue;
            result.add(new RelationExtractorAnnotator.IdentifiedAnnotationPair((IdentifiedAnnotation)nearestEntity, (IdentifiedAnnotation)modifier));
            alreadyLinked.add(nearestEntity);
        }
        return result;
    }

    private static List<EntityMention> getEntitiesSuitableForDegreeOf(List<EntityMention> entityMentions) {
        HashSet<Integer> okArg1Types = new HashSet<Integer>(Arrays.asList(2, 3));
        ArrayList<EntityMention> suitableEntities = new ArrayList<EntityMention>();
        for (EntityMention entityMention : entityMentions) {
            if (!okArg1Types.contains(entityMention.getTypeID())) continue;
            suitableEntities.add(entityMention);
        }
        return suitableEntities;
    }

    private static EntityMention getNearestEntity(JCas jCas, Modifier modifier, List<EntityMention> entityMentions) {
        HashMap<EntityMention, Integer> distanceToEntities = new HashMap<EntityMention, Integer>();
        for (EntityMention entityMention : entityMentions) {
            List baseTokens = JCasUtil.selectBetween((JCas)jCas, BaseToken.class, (AnnotationFS)modifier, (AnnotationFS)entityMention);
            distanceToEntities.put(entityMention, baseTokens.size());
        }
        ArrayList sortedEntityMentions = new ArrayList(distanceToEntities.keySet());
        Function getValue = Functions.forMap(distanceToEntities);
        Collections.sort(sortedEntityMentions, Ordering.natural().onResultOf(getValue));
        return (EntityMention)sortedEntityMentions.get(0);
    }

    private static boolean checkForModifierBetween(JCas jCas, Modifier modifier, EntityMention entity) {
        List modifiers = JCasUtil.selectBetween((JCas)jCas, Modifier.class, (AnnotationFS)modifier, (AnnotationFS)entity);
        return modifiers.size() > 0;
    }

    @Override
    public String classify(List<Feature> features) {
        return "degree_of";
    }
}

