/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.util.counter;

import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.util.FailSafeTimer;
import net.sf.ehcache.util.counter.Counter;
import net.sf.ehcache.util.counter.CounterConfig;
import net.sf.ehcache.util.counter.CounterManager;
import net.sf.ehcache.util.counter.sampled.SampledCounter;
import net.sf.ehcache.util.counter.sampled.SampledCounterImpl;

public class CounterManagerImpl
implements CounterManager {
    private FailSafeTimer timer;
    private boolean shutdown;
    private List<Counter> counters = new ArrayList<Counter>();

    public CounterManagerImpl(FailSafeTimer timer) {
        if (timer == null) {
            throw new IllegalArgumentException("Timer cannot be null");
        }
        this.timer = timer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown() {
        if (this.shutdown) {
            return;
        }
        try {
            for (Counter counter : this.counters) {
                if (!(counter instanceof SampledCounter)) continue;
                ((SampledCounter)counter).shutdown();
            }
        }
        finally {
            this.shutdown = true;
        }
    }

    public synchronized Counter createCounter(CounterConfig config) {
        if (this.shutdown) {
            throw new IllegalStateException("counter manager is shutdown");
        }
        if (config == null) {
            throw new NullPointerException("config cannot be null");
        }
        Counter counter = config.createCounter();
        if (counter instanceof SampledCounterImpl) {
            SampledCounterImpl sampledCounter = (SampledCounterImpl)counter;
            this.timer.schedule(sampledCounter.getTimerTask(), sampledCounter.getIntervalMillis(), sampledCounter.getIntervalMillis());
        }
        this.counters.add(counter);
        return counter;
    }

    public void shutdownCounter(Counter counter) {
        if (counter instanceof SampledCounter) {
            SampledCounter sc = (SampledCounter)counter;
            sc.shutdown();
        }
    }
}

