/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.clinicalpipeline;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.ctakes.assertion.medfacts.cleartk.ConditionalCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.GenericCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.HistoryCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.PolarityCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.SubjectCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.UncertaintyCleartkAnalysisEngine;
import org.apache.ctakes.chunker.ae.Chunker;
import org.apache.ctakes.chunker.ae.adjuster.ChunkAdjuster;
import org.apache.ctakes.constituency.parser.ae.ConstituencyParser;
import org.apache.ctakes.contexttokenizer.ae.ContextDependentTokenizerAnnotator;
import org.apache.ctakes.core.ae.SentenceDetector;
import org.apache.ctakes.core.ae.SimpleSegmentAnnotator;
import org.apache.ctakes.core.ae.TokenizerAnnotatorPTB;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.coreference.factory.CoreferenceAnnotatorFactory;
import org.apache.ctakes.dependency.parser.ae.ClearNLPDependencyParserAE;
import org.apache.ctakes.dictionary.lookup.ae.UmlsDictionaryLookupAnnotator;
import org.apache.ctakes.dictionary.lookup2.ae.DefaultJCasTermAnnotator;
import org.apache.ctakes.lvg.ae.LvgAnnotator;
import org.apache.ctakes.postagger.POSTagger;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.ctakes.typesystem.type.syntax.Chunk;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.ctakes.typesystem.type.textspan.LookupWindowAnnotation;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.fit.component.JCasAnnotator_ImplBase;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.JCasFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;
import org.apache.uima.resource.ResourceInitializationException;
import org.xml.sax.SAXException;

public final class ClinicalPipelineFactory {
    private ClinicalPipelineFactory() {
    }

    public static AnalysisEngineDescription getDefaultPipeline() throws ResourceInitializationException, MalformedURLException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(ClinicalPipelineFactory.getTokenProcessingPipeline(), new String[0]);
        builder.add(ClinicalPipelineFactory.getNpChunkerPipeline(), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(ConstituencyParser.class, (Object[])new Object[0]), new String[0]);
        builder.add(UmlsDictionaryLookupAnnotator.createAnnotatorDescription(), new String[0]);
        builder.add(ClearNLPDependencyParserAE.createAnnotatorDescription(), new String[0]);
        builder.add(PolarityCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(UncertaintyCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(HistoryCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(ConditionalCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(GenericCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(SubjectCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        return builder.createAggregateDescription();
    }

    public static AnalysisEngineDescription getFastPipeline() throws ResourceInitializationException, MalformedURLException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(ClinicalPipelineFactory.getTokenProcessingPipeline(), new String[0]);
        builder.add(DefaultJCasTermAnnotator.createAnnotatorDescription(), new String[0]);
        builder.add(ClearNLPDependencyParserAE.createAnnotatorDescription(), new String[0]);
        builder.add(PolarityCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(UncertaintyCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(HistoryCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(ConditionalCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(GenericCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        builder.add(SubjectCleartkAnalysisEngine.createAnnotatorDescription(), new String[0]);
        return builder.createAggregateDescription();
    }

    public static AnalysisEngineDescription getParsingPipeline() throws ResourceInitializationException, MalformedURLException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(ClinicalPipelineFactory.getTokenProcessingPipeline(), new String[0]);
        builder.add(ClearNLPDependencyParserAE.createAnnotatorDescription(), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(ConstituencyParser.class, (Object[])new Object[0]), new String[0]);
        return builder.createAggregateDescription();
    }

    public static AnalysisEngineDescription getTokenProcessingPipeline() throws ResourceInitializationException, MalformedURLException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(SimpleSegmentAnnotator.createAnnotatorDescription(), new String[0]);
        builder.add(SentenceDetector.createAnnotatorDescription(), new String[0]);
        builder.add(TokenizerAnnotatorPTB.createAnnotatorDescription(), new String[0]);
        builder.add(LvgAnnotator.createAnnotatorDescription(), new String[0]);
        builder.add(ContextDependentTokenizerAnnotator.createAnnotatorDescription(), new String[0]);
        builder.add(POSTagger.createAnnotatorDescription(), new String[0]);
        return builder.createAggregateDescription();
    }

    public static AnalysisEngineDescription getNpChunkerPipeline() throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(Chunker.createAnnotatorDescription(), new String[0]);
        builder.add(ClinicalPipelineFactory.getStandardChunkAdjusterAnnotator(), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(CopyNPChunksToLookupWindowAnnotations.class, (Object[])new Object[0]), new String[0]);
        builder.add(AnalysisEngineFactory.createEngineDescription(RemoveEnclosedLookupWindows.class, (Object[])new Object[0]), new String[0]);
        return builder.createAggregateDescription();
    }

    public static AnalysisEngineDescription getStandardChunkAdjusterAnnotator() throws ResourceInitializationException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(ChunkAdjuster.createAnnotatorDescription((String[])new String[]{"NP", "NP"}, (int)1), new String[0]);
        builder.add(ChunkAdjuster.createAnnotatorDescription((String[])new String[]{"NP", "PP", "NP"}, (int)2), new String[0]);
        return builder.createAggregateDescription();
    }

    public static AnalysisEngineDescription getCoreferencePipeline() throws ResourceInitializationException, MalformedURLException {
        AggregateBuilder builder = new AggregateBuilder();
        builder.add(ClinicalPipelineFactory.getFastPipeline(), new String[0]);
        builder.add(ConstituencyParser.createAnnotatorDescription(), new String[0]);
        builder.add(CoreferenceAnnotatorFactory.getDefaultCoreferencePipeline(), new String[0]);
        return builder.createAggregateDescription();
    }

    public static void main(String ... args) throws IOException, UIMAException, SAXException {
        String note = "History of diabetes and hypertension. Mother had breast cancer. Sister with multiple sclerosis. The patient is suffering from extreme pain due to shark bite. Recommend continuing use of aspirin, oxycodone, and coumadin. Continue exercise for obesity and hypertension. Patient denies smoking and chest pain. Patient has no cancer. There is no sign of multiple sclerosis. Mass is suspicious for breast cancer. Possible breast cancer. Cannot exclude stenosis. Some degree of focal pancreatitis is also possible. Discussed surgery and chemotherapy. Will return if pain continues.";
        JCas jcas = JCasFactory.createJCas();
        jcas.setDocumentText("History of diabetes and hypertension. Mother had breast cancer. Sister with multiple sclerosis. The patient is suffering from extreme pain due to shark bite. Recommend continuing use of aspirin, oxycodone, and coumadin. Continue exercise for obesity and hypertension. Patient denies smoking and chest pain. Patient has no cancer. There is no sign of multiple sclerosis. Mass is suspicious for breast cancer. Possible breast cancer. Cannot exclude stenosis. Some degree of focal pancreatitis is also possible. Discussed surgery and chemotherapy. Will return if pain continues.");
        AnalysisEngineDescription aed = ClinicalPipelineFactory.getDefaultPipeline();
        SimplePipeline.runPipeline((JCas)jcas, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aed});
        boolean printCuis = Arrays.asList(args).contains("cuis");
        ArrayList<String> codes = new ArrayList<String>();
        for (IdentifiedAnnotation entity : JCasUtil.select((JCas)jcas, IdentifiedAnnotation.class)) {
            System.out.println("Entity: " + entity.getCoveredText() + " === Polarity: " + entity.getPolarity() + " === Uncertain? " + (entity.getUncertainty() == 1) + " === Subject: " + entity.getSubject() + " === Generic? " + entity.getGeneric() + " === Conditional? " + entity.getConditional() + " === History? " + (entity.getHistoryOf() == 1));
            if (!printCuis) continue;
            codes.clear();
            codes.addAll(ClinicalPipelineFactory.getCUIs(entity));
            for (String cui : codes) {
                System.out.print(cui + " ");
            }
            System.out.println();
        }
        if (args.length > 0) {
            aed.toXML((Writer)new FileWriter(args[0]));
        }
    }

    private static Collection<String> getCUIs(IdentifiedAnnotation identifiedAnnotation) {
        FSArray fsArray = identifiedAnnotation.getOntologyConceptArr();
        if (fsArray == null) {
            return Collections.emptySet();
        }
        FeatureStructure[] featureStructures = fsArray.toArray();
        ArrayList<String> cuis = new ArrayList<String>(featureStructures.length);
        for (FeatureStructure featureStructure : featureStructures) {
            if (!(featureStructure instanceof UmlsConcept)) continue;
            UmlsConcept umlsConcept = (UmlsConcept)featureStructure;
            String cui = umlsConcept.getCui();
            String tui = umlsConcept.getTui();
            if (tui != null && !tui.isEmpty()) {
                cuis.add(cui + "_" + tui);
                continue;
            }
            cuis.add(cui);
        }
        return cuis;
    }

    @PipeBitInfo(name="Overlap Lookup Window Remover", description="Removes Lookup Windows that are within larger Lookup Windows.", role=PipeBitInfo.Role.SPECIAL)
    public static class RemoveEnclosedLookupWindows
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            ArrayList lws = new ArrayList(JCasUtil.select((JCas)jCas, LookupWindowAnnotation.class));
            for (int i = lws.size() - 2; i >= 0; --i) {
                LookupWindowAnnotation lw1 = (LookupWindowAnnotation)lws.get(i);
                LookupWindowAnnotation lw2 = (LookupWindowAnnotation)lws.get(i + 1);
                if (lw1.getBegin() > lw2.getBegin() || lw1.getEnd() < lw2.getEnd()) continue;
                lws.remove(i + 1);
                lw2.removeFromIndexes();
            }
        }
    }

    @PipeBitInfo(name="NP Lookup Window Creator", description="Creates a Lookup Window from Noun Phrase Chunks.", role=PipeBitInfo.Role.SPECIAL, dependencies={PipeBitInfo.TypeProduct.CHUNK})
    public static class CopyNPChunksToLookupWindowAnnotations
    extends JCasAnnotator_ImplBase {
        public void process(JCas jCas) throws AnalysisEngineProcessException {
            for (Chunk chunk : JCasUtil.select((JCas)jCas, Chunk.class)) {
                if (!chunk.getChunkType().equals("NP")) continue;
                new LookupWindowAnnotation(jCas, chunk.getBegin(), chunk.getEnd()).addToIndexes();
            }
        }
    }
}

