/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.util;

import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.ResourceCreationSpecifierFactory;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.DataWriter;
import org.cleartk.ml.SequenceDataWriter;
import org.cleartk.ml.jar.JarClassifierBuilder;

public abstract class CleartkInternalModelFactory {
    public abstract AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException;

    public abstract Class<?> getAnnotatorClass();

    public abstract Class<?> getDataWriterClass();

    public File getTrainingDirectory() {
        String path = this.getAnnotatorClass().getName().toLowerCase().replace('.', '/');
        return new File("src/main/resources/" + path);
    }

    public URL getClassifierJarURL() {
        String dirName = this.getAnnotatorClass().getSimpleName().toLowerCase();
        File resourceFile = JarClassifierBuilder.getModelJarFile((String)dirName);
        String resourceName = resourceFile.getPath().replaceAll("\\\\", "/");
        URL url = this.getAnnotatorClass().getResource(resourceName);
        if (url == null) {
            String className = this.getAnnotatorClass().getName();
            String format = "No classifier jar found at \"%s\" for class %s";
            String message = String.format(format, resourceName, className);
            throw new MissingResourceException(message, className, resourceName);
        }
        return url;
    }

    public AnalysisEngineDescription getWriterDescription(File outputDirectory) throws ResourceInitializationException {
        String paramName;
        Class<?> dataWriterClass = this.getDataWriterClass();
        if (SequenceDataWriter.class.isAssignableFrom(dataWriterClass)) {
            paramName = "dataWriterClassName";
        } else if (DataWriter.class.isAssignableFrom(dataWriterClass)) {
            paramName = "dataWriterClassName";
        } else {
            throw new RuntimeException("Invalid data writer class: " + dataWriterClass);
        }
        AnalysisEngineDescription desc = this.getBaseDescription();
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)desc, (Object[])new Object[]{"outputDirectory", outputDirectory.getPath(), paramName, dataWriterClass.getName()});
        return desc;
    }

    public AnalysisEngineDescription getWriterDescription() throws ResourceInitializationException {
        return this.getWriterDescription(this.getTrainingDirectory());
    }

    public AnalysisEngineDescription getAnnotatorDescription(String modelFileName) throws ResourceInitializationException {
        AnalysisEngineDescription desc = this.getBaseDescription();
        ResourceCreationSpecifierFactory.setConfigurationParameters((ResourceCreationSpecifier)desc, (Object[])new Object[]{"classifierJarPath", modelFileName});
        return desc;
    }

    public AnalysisEngineDescription getAnnotatorDescription() throws ResourceInitializationException {
        return this.getAnnotatorDescription(this.getClassifierJarURL().toString());
    }
}

