/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.timeml.time;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.CleartkAnnotator;
import org.cleartk.ml.Feature;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.CleartkExtractor;
import org.cleartk.ml.feature.extractor.CoveredTextExtractor;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.extractor.NamedFeatureExtractor1;
import org.cleartk.ml.feature.function.CharacterCategoryPatternFunction;
import org.cleartk.ml.liblinear.LibLinearStringOutcomeDataWriter;
import org.cleartk.timeml.type.Time;
import org.cleartk.timeml.util.CleartkInternalModelFactory;
import org.cleartk.timeml.util.TimeWordsExtractor;
import org.cleartk.token.type.Token;

public class TimeTypeAnnotator
extends CleartkAnnotator<String> {
    public static final CleartkInternalModelFactory FACTORY = new CleartkInternalModelFactory(){

        @Override
        public Class<?> getAnnotatorClass() {
            return TimeTypeAnnotator.class;
        }

        @Override
        public Class<?> getDataWriterClass() {
            return LibLinearStringOutcomeDataWriter.class;
        }

        @Override
        public AnalysisEngineDescription getBaseDescription() throws ResourceInitializationException {
            return AnalysisEngineFactory.createEngineDescription(TimeTypeAnnotator.class, (Object[])new Object[0]);
        }
    };
    private List<FeatureExtractor1<Time>> featuresExtractors;

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.featuresExtractors = Lists.newArrayList();
        this.featuresExtractors.add((FeatureExtractor1<Time>)new LastWordExtractor());
        NamedFeatureExtractor1 ex = CharacterCategoryPatternFunction.createExtractor();
        this.featuresExtractors.add((FeatureExtractor1<Time>)ex);
        this.featuresExtractors.add((FeatureExtractor1<Time>)new TimeWordsExtractor());
        this.featuresExtractors.add((FeatureExtractor1<Time>)new CleartkExtractor(Token.class, (FeatureExtractor1)new CoveredTextExtractor(), new CleartkExtractor.Context[]{new CleartkExtractor.Bag(new CleartkExtractor.Context[]{new CleartkExtractor.Covered()})}));
    }

    public void process(JCas jCas) throws AnalysisEngineProcessException {
        for (Time time : JCasUtil.select((JCas)jCas, Time.class)) {
            ArrayList features = new ArrayList();
            for (FeatureExtractor1<Time> extractor : this.featuresExtractors) {
                features.addAll(extractor.extract(jCas, (Annotation)time));
            }
            if (this.isTraining()) {
                this.dataWriter.write(new Instance((Object)time.getTimeType(), features));
                continue;
            }
            time.setTimeType((String)this.classifier.classify(features));
        }
    }

    private static class LastWordExtractor<T extends Annotation>
    implements NamedFeatureExtractor1<T> {
        private String featureName = "LastWord";

        public String getFeatureName() {
            return this.featureName;
        }

        public List<Feature> extract(JCas view, T focusAnnotation) {
            String[] words = focusAnnotation.getCoveredText().split("\\W+");
            return Arrays.asList(new Feature(this.featureName, (Object)words[words.length - 1]));
        }
    }
}

