/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.dictionary.lookup2.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.ctakes.core.util.collection.CollectionMap;
import org.apache.ctakes.dictionary.lookup2.dictionary.MemRareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordDictionary;
import org.apache.ctakes.dictionary.lookup2.dictionary.RareWordTermMapCreator;
import org.apache.ctakes.dictionary.lookup2.term.RareWordTerm;
import org.apache.ctakes.dictionary.lookup2.util.FastLookupToken;
import org.apache.ctakes.dictionary.lookup2.util.LookupUtil;
import org.apache.log4j.Logger;
import org.apache.uima.UimaContext;

public final class BsvRareWordDictionary
implements RareWordDictionary {
    private static final Logger LOGGER = Logger.getLogger((String)"BsvRareWordDictionary");
    private static final String BSV_FILE_PATH = "bsvPath";
    private final RareWordDictionary _delegateDictionary;

    public BsvRareWordDictionary(String name, UimaContext uimaContext, Properties properties) {
        this(name, properties.getProperty(BSV_FILE_PATH));
    }

    public BsvRareWordDictionary(String name, String bsvFilePath) {
        Collection<RareWordTermMapCreator.CuiTerm> cuiTerms = BsvRareWordDictionary.parseBsvFile(bsvFilePath);
        CollectionMap<String, RareWordTerm, List<RareWordTerm>> rareWordTermMap = RareWordTermMapCreator.createRareWordTermMap(cuiTerms);
        this._delegateDictionary = new MemRareWordDictionary(name, rareWordTermMap);
    }

    @Override
    public String getName() {
        return this._delegateDictionary.getName();
    }

    @Override
    public Collection<RareWordTerm> getRareWordHits(FastLookupToken fastLookupToken) {
        return this._delegateDictionary.getRareWordHits(fastLookupToken);
    }

    @Override
    public Collection<RareWordTerm> getRareWordHits(String rareWordText) {
        return this._delegateDictionary.getRareWordHits(rareWordText);
    }

    private static Collection<RareWordTermMapCreator.CuiTerm> parseBsvFile(String bsvFilePath) {
        ArrayList<RareWordTermMapCreator.CuiTerm> cuiTerms = new ArrayList<RareWordTermMapCreator.CuiTerm>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(FileLocator.getAsStream((String)bsvFilePath)));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith("//") || line.startsWith("#")) {
                    line = reader.readLine();
                    continue;
                }
                String[] columns = LookupUtil.fastSplit(line, '|');
                RareWordTermMapCreator.CuiTerm cuiTerm = BsvRareWordDictionary.createCuiTuiTerm(columns);
                if (cuiTerm != null) {
                    cuiTerms.add(cuiTerm);
                } else {
                    LOGGER.warn((Object)("Bad BSV line " + line + " in " + bsvFilePath));
                }
                line = reader.readLine();
            }
        }
        catch (IOException ioE) {
            LOGGER.error((Object)ioE.getMessage());
        }
        return cuiTerms;
    }

    private static RareWordTermMapCreator.CuiTerm createCuiTuiTerm(String ... columns) {
        if (columns.length < 2) {
            return null;
        }
        boolean cuiIndex = false;
        int termIndex = 1;
        if (columns.length >= 3) {
            termIndex = 2;
        }
        if (columns[0].trim().isEmpty() || columns[termIndex].trim().isEmpty()) {
            return null;
        }
        String cui = columns[0];
        String term = columns[termIndex].trim().toLowerCase();
        return new RareWordTermMapCreator.CuiTerm(cui, term);
    }
}

