/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.ctakes.assertion.util.NegationDepRegex;
import org.apache.ctakes.dependency.parser.util.DependencyPath;
import org.apache.ctakes.dependency.parser.util.DependencyUtility;
import org.apache.ctakes.typesystem.type.syntax.ConllDependencyNode;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.jcas.tcas.Annotation;

public class NegationManualDepContextAnalyzer {
    private NegationDepRegex regexes = new NegationDepRegex();

    public boolean isBoundary(Annotation contextAnnotation, int scopeOrientation) throws AnalysisEngineProcessException {
        String lcText = contextAnnotation.getCoveredText().toLowerCase();
        return this.regexes._boundaryWordSet.contains(lcText);
    }

    public boolean[] findNegationContext(List<ConllDependencyNode> nodes, ConllDependencyNode focus) throws Exception {
        ArrayList hits = new ArrayList();
        boolean[] feats = new boolean[this.regexes.regexSet.size()];
        for (int i = 0; i < nodes.size(); ++i) {
            int featMatchInd;
            ConllDependencyNode hypNegNode = nodes.get(i);
            DependencyPath path = DependencyUtility.getPath(nodes, (ConllDependencyNode)hypNegNode, (ConllDependencyNode)focus);
            if (path == null || (featMatchInd = this.findPathMatches(path)) == -1) continue;
            feats[featMatchInd] = true;
        }
        return feats;
    }

    private int findPathMatches(DependencyPath path) {
        for (int i = 0; i < this.regexes.regexSet.size(); ++i) {
            String pathString = path.toString();
            if (!this.regexes.regexSet.get(i).matches(pathString)) continue;
            return i;
        }
        return -1;
    }

    public int getNumFeatures() {
        return this.regexes.regexSet.size();
    }

    public String getRegexName(int i) {
        return this.regexes.regexSet.get(i).getName();
    }
}

