/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.pipelines;

import com.google.common.base.Function;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import org.apache.ctakes.assertion.cr.I2B2Challenge2010CollectionReader;
import org.apache.ctakes.assertion.cr.MiPACQKnowtatorXMLReader;
import org.apache.ctakes.assertion.cr.NegExCorpusReader;
import org.apache.ctakes.assertion.pipelines.SharpCorpusSplit;
import org.apache.ctakes.core.ae.SHARPKnowtatorXMLReader;
import org.apache.ctakes.core.cc.XmiWriterCasConsumerCtakes;
import org.apache.ctakes.core.cr.FilesInDirectoryCollectionReader;
import org.apache.log4j.Logger;
import org.apache.uima.UIMAException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.collection.CollectionReaderDescription;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.CollectionReaderFactory;
import org.apache.uima.fit.factory.TypeSystemDescriptionFactory;
import org.apache.uima.fit.pipeline.SimplePipeline;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.metadata.TypeSystemDescription;

public class GoldEntityAndAttributeReaderPipelineForSeedCorpus {
    static final Logger logger = Logger.getLogger((String)GoldEntityAndAttributeReaderPipelineForSeedCorpus.class.getName());

    public static void main(String[] args) throws UIMAException, IOException {
        logger.warn((Object)"This should be run with one command-line argument that is the parent UMLS_CEM directory.");
        logger.warn((Object)"Also, make sure each ss1_batch* directory has both a Knowtator/text directory and a Knowtator_XML directory (not the underscore in the xml directory, not a space)");
        if (args.length != 1) {
            System.out.println("Requires one parameter that is the UMLS_CEM main directory (e.g. the \"Seed_Corpus/Mayo/UMLS_CEM\" or \"Seattle Group Health/UMLS_CEM\"). The path should be fully specified.");
        }
        String parentDirectoryString = args[0];
        File parentDirectory = new File(parentDirectoryString);
        GoldEntityAndAttributeReaderPipelineForSeedCorpus.readSharpSeedUmlsCem(parentDirectory);
    }

    public static void readSharpSeedUmlsCem(File parentDirectory) throws ResourceInitializationException, UIMAException, IOException {
        GoldEntityAndAttributeReaderPipelineForSeedCorpus.readSharpSeedUmlsCem(parentDirectory, null, null, null);
    }

    public static void readSharpSeedUmlsCem(File parentDirectory, File trainDirectory, File testDirectory, File devDirectory) throws ResourceInitializationException, UIMAException, IOException {
        File[] batchDirectories;
        if (!parentDirectory.exists()) {
            logger.fatal((Object)String.format("parent directory %s does not exist! exiting!", parentDirectory.getAbsolutePath()));
            return;
        }
        for (File currentBatchDirectory : batchDirectories = parentDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        })) {
            logger.info((Object)("current batch directory: " + currentBatchDirectory.getName()));
            if (!currentBatchDirectory.exists()) {
                logger.fatal((Object)String.format("current batch directory does not exist! exiting! [\"%s\"]", currentBatchDirectory.toString()));
                continue;
            }
            File knowtatorDirectory = new File(currentBatchDirectory, "Knowtator");
            File textDirectory = new File(knowtatorDirectory, "text");
            File xmlDirectory = new File(currentBatchDirectory, "Knowtator_XML");
            File xmiDirectory = new File(currentBatchDirectory, "Knowtator_XMI");
            if (!xmlDirectory.exists()) {
                xmlDirectory = new File(currentBatchDirectory, "Knowtator XML");
                xmiDirectory = new File(currentBatchDirectory, "Knowtator XMI");
            }
            if (!(knowtatorDirectory.isDirectory() && textDirectory.isDirectory() && xmlDirectory.isDirectory())) {
                logger.error((Object)"one of the directories does not exist! skipping...");
                continue;
            }
            if (!xmiDirectory.isDirectory()) {
                xmiDirectory.mkdir();
            }
            TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
            AggregateBuilder aggregate = new AggregateBuilder();
            CollectionReaderDescription collectionReader = CollectionReaderFactory.createReaderDescription(FilesInDirectoryCollectionReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"InputDirectory", textDirectory.toString()});
            AnalysisEngineDescription goldAnnotator = AnalysisEngineFactory.createEngineDescription(SHARPKnowtatorXMLReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"TextDirectory", textDirectory.toString() + "/"});
            aggregate.add(goldAnnotator, new String[0]);
            AnalysisEngineDescription xWriter = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"OutputDirectory", xmiDirectory.toString()});
            aggregate.add(xWriter, new String[0]);
            AnalysisEngineDescription preprocessAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/analysis_engine/AttributeDiscoveryPreprocessor", (Object[])new Object[0]);
            aggregate.add(preprocessAnnotator, new String[0]);
            if (trainDirectory != null && testDirectory != null && devDirectory != null) {
                File subcorpusDirectory;
                switch (SharpCorpusSplit.splitSeed(currentBatchDirectory)) {
                    case TRAIN: {
                        subcorpusDirectory = trainDirectory;
                        break;
                    }
                    case TEST: {
                        subcorpusDirectory = testDirectory;
                        break;
                    }
                    case DEV: {
                        subcorpusDirectory = devDirectory;
                        break;
                    }
                    case CROSSVAL: {
                        subcorpusDirectory = trainDirectory;
                        break;
                    }
                    default: {
                        subcorpusDirectory = trainDirectory;
                    }
                }
                AnalysisEngineDescription xWriter2 = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"OutputDirectory", subcorpusDirectory});
                aggregate.add(xWriter2, new String[0]);
            }
            SimplePipeline.runPipeline((CollectionReaderDescription)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aggregate.createAggregateDescription()});
        }
        logger.info((Object)"Finished!");
    }

    public static void readSharpStratifiedUmls(File releaseDirectory, File trainDirectory, File testDirectory, File devDirectory) throws UIMAException, IOException {
        File mayoStrat = new File(releaseDirectory, "SHARP/MayoStrat/by-batch/umls");
        GoldEntityAndAttributeReaderPipelineForSeedCorpus.readSharpUmls(new File[]{mayoStrat}, trainDirectory, testDirectory, devDirectory, new Function<File, SharpCorpusSplit.Subcorpus>(){

            public SharpCorpusSplit.Subcorpus apply(File f) {
                return SharpCorpusSplit.splitStratified(f);
            }
        });
    }

    public static void readSharpSeedUmls(File releaseDirectory, File trainDirectory, File testDirectory, File devDirectory) throws UIMAException, IOException {
        File seed1 = new File(releaseDirectory, "SHARP/SeedSet1/by-batch/umls");
        GoldEntityAndAttributeReaderPipelineForSeedCorpus.readSharpUmls(new File[]{seed1}, trainDirectory, testDirectory, devDirectory, new Function<File, SharpCorpusSplit.Subcorpus>(){

            public SharpCorpusSplit.Subcorpus apply(File f) {
                return SharpCorpusSplit.splitSeed(f);
            }
        });
    }

    public static void readSharpUmls(File[] sections, File trainDirectory, File testDirectory, File devDirectory, Function<File, SharpCorpusSplit.Subcorpus> splitFunction) throws UIMAException, IOException {
        for (File section : sections) {
            File[] batches;
            for (File batchDir : batches = section.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            })) {
                TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
                File textDirectory = new File(batchDir, "text");
                AggregateBuilder aggregate = new AggregateBuilder();
                CollectionReaderDescription collectionReader = CollectionReaderFactory.createReaderDescription(FilesInDirectoryCollectionReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"InputDirectory", textDirectory.toString()});
                AnalysisEngineDescription goldAnnotator = AnalysisEngineFactory.createEngineDescription(SHARPKnowtatorXMLReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"TextDirectory", textDirectory.toString() + "/", "SetDefaults", true});
                aggregate.add(goldAnnotator, new String[0]);
                AnalysisEngineDescription preprocessAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/analysis_engine/AttributeDiscoveryPreprocessor", (Object[])new Object[0]);
                aggregate.add(preprocessAnnotator, new String[0]);
                File subcorpusDir = null;
                SharpCorpusSplit.Subcorpus subcorpus = (SharpCorpusSplit.Subcorpus)((Object)splitFunction.apply((Object)batchDir));
                switch (subcorpus) {
                    case TRAIN: {
                        subcorpusDir = trainDirectory;
                        break;
                    }
                    case DEV: {
                        subcorpusDir = devDirectory;
                        break;
                    }
                    case TEST: {
                        subcorpusDir = testDirectory;
                        break;
                    }
                    default: {
                        subcorpusDir = trainDirectory;
                    }
                }
                AnalysisEngineDescription xWriter = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"OutputDirectory", subcorpusDir});
                aggregate.add(xWriter, new String[0]);
                SimplePipeline.runPipeline((CollectionReaderDescription)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aggregate.createAggregateDescription()});
            }
        }
    }

    public static void readI2B2Challenge2010(File parentDirectory, File preprocessedDirectory) throws ResourceInitializationException, UIMAException, IOException {
        TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
        AggregateBuilder aggregate = new AggregateBuilder();
        CollectionReaderDescription collectionReader = CollectionReaderFactory.createReaderDescription(I2B2Challenge2010CollectionReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"inputDir", parentDirectory});
        AnalysisEngineDescription preprocessAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/analysis_engine/AttributeDiscoveryPreprocessor", (Object[])new Object[0]);
        aggregate.add(preprocessAnnotator, new String[0]);
        if (preprocessedDirectory != null) {
            AnalysisEngineDescription xWriter2 = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"OutputDirectory", preprocessedDirectory});
            aggregate.add(xWriter2, new String[0]);
        }
        SimplePipeline.runPipeline((CollectionReaderDescription)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aggregate.createAggregateDescription()});
        logger.info((Object)"Finished!");
    }

    public static void readNegexTestSet(File inputFile, File preprocessedDirectory) throws ResourceInitializationException, UIMAException, IOException {
        TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
        AggregateBuilder aggregate = new AggregateBuilder();
        CollectionReaderDescription collectionReader = CollectionReaderFactory.createReaderDescription(NegExCorpusReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[0]);
        AnalysisEngineDescription preprocessAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/analysis_engine/AttributeDiscoveryPreprocessor", (Object[])new Object[0]);
        aggregate.add(preprocessAnnotator, new String[0]);
        if (preprocessedDirectory != null) {
            AnalysisEngineDescription xWriter2 = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"OutputDirectory", preprocessedDirectory});
            aggregate.add(xWriter2, new String[0]);
        }
        SimplePipeline.runPipeline((CollectionReaderDescription)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aggregate.createAggregateDescription()});
        logger.info((Object)"Finished!");
    }

    public static void readMiPACQ(File inputDirectory, File preprocessedDirectory, File testDirectory, File devDirectory) throws ResourceInitializationException, UIMAException, IOException {
        TypeSystemDescription typeSystemDescription = TypeSystemDescriptionFactory.createTypeSystemDescription();
        HashMap<File, File> splitMipacq = new HashMap<File, File>();
        splitMipacq.put(new File(inputDirectory + "/text/train"), preprocessedDirectory);
        splitMipacq.put(new File(inputDirectory + "/text/test"), testDirectory);
        splitMipacq.put(new File(inputDirectory + "/text/dev"), devDirectory);
        for (File inDir : splitMipacq.keySet()) {
            AggregateBuilder aggregate = new AggregateBuilder();
            CollectionReaderDescription collectionReader = CollectionReaderFactory.createReaderDescription(FilesInDirectoryCollectionReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"InputDirectory", inDir});
            AnalysisEngineDescription goldAnnotator = AnalysisEngineFactory.createEngineDescription(MiPACQKnowtatorXMLReader.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"TextDirectory", inDir});
            aggregate.add(goldAnnotator, new String[0]);
            AnalysisEngineDescription preprocessAnnotator = AnalysisEngineFactory.createEngineDescription((String)"desc/analysis_engine/AttributeDiscoveryPreprocessor", (Object[])new Object[0]);
            aggregate.add(preprocessAnnotator, new String[0]);
            if (preprocessedDirectory != null) {
                AnalysisEngineDescription xWriter2 = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)typeSystemDescription, (Object[])new Object[]{"OutputDirectory", splitMipacq.get(inDir)});
                aggregate.add(xWriter2, new String[0]);
            }
            SimplePipeline.runPipeline((CollectionReaderDescription)collectionReader, (AnalysisEngineDescription[])new AnalysisEngineDescription[]{aggregate.createAggregateDescription()});
        }
        logger.info((Object)"Finished!");
    }
}

