/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk.extractors;

import com.google.common.collect.Maps;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.ctakes.core.resource.FileLocator;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Feature;
import org.cleartk.ml.feature.function.FeatureFunction;

public class BrownClusterFeatureFunction
implements FeatureFunction {
    public static final String DEFAULT_NAME = "BrownCluster";
    public static final Pattern linePatt = Pattern.compile("^(\\d+)\\s+(\\S+)\\s+(\\d+)");
    private HashMap<String, String> word2class = Maps.newHashMap();

    public BrownClusterFeatureFunction() throws ResourceInitializationException {
        try {
            Scanner scanner = new Scanner(FileLocator.getAsStream((String)"org/apache/ctakes/assertion/models/brown_clusters.txt"));
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine().trim();
                Matcher m = linePatt.matcher(line);
                if (!m.matches()) continue;
                this.word2class.put(m.group(2), m.group(1));
            }
        }
        catch (FileNotFoundException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
    }

    public List<Feature> apply(@Nullable Feature input) {
        String featureName = Feature.createName((String[])new String[]{DEFAULT_NAME, input.getName()});
        Object featureValue = input.getValue();
        if (featureValue instanceof String) {
            return Collections.singletonList(new Feature(featureName, (Object)(this.word2class.containsKey(featureValue) ? this.word2class.get(featureValue) : "NoCluster")));
        }
        return Collections.emptyList();
    }
}

