/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import org.apache.ctakes.assertion.attributes.features.selection.Chi2FeatureSelection;
import org.apache.ctakes.assertion.attributes.features.selection.FeatureSelection;
import org.apache.ctakes.assertion.medfacts.cleartk.PolarityCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.AboveLeftFragmentExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.ContextWordWindowExtractor;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.ExtractorListFeatureFunctionConverter;
import org.apache.ctakes.assertion.medfacts.cleartk.extractors.NegationDependencyFeatureExtractor;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.textsem.IdentifiedAnnotation;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.resource.ResourceInitializationException;
import org.cleartk.ml.Instance;
import org.cleartk.ml.feature.extractor.FeatureExtractor1;
import org.cleartk.ml.feature.function.FeatureFunction;
import org.cleartk.ml.feature.function.FeatureFunctionExtractor;

@PipeBitInfo(name="Negation Annotator (Feda)", description="Annotates negation property.", dependencies={PipeBitInfo.TypeProduct.SENTENCE, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class PolarityFedaCleartkAnalysisEngine
extends PolarityCleartkAnalysisEngine {
    @Override
    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.probabilityOfKeepingADefaultExample = 1.0;
        if (this.entityFeatureExtractors == null) {
            this.entityFeatureExtractors = new ArrayList();
        }
        this.entityFeatureExtractors.add(new NegationDependencyFeatureExtractor());
        this.entityFeatureExtractors.add(new ContextWordWindowExtractor("org/apache/ctakes/assertion/models/polarity.txt"));
        this.entityFeatureExtractors.add(new AboveLeftFragmentExtractor("AL_Polarity", "org/apache/ctakes/assertion/models/sharpPolarityFrags.txt"));
        this.initializeDomainAdaptation();
        this.initializeFeatureSelection();
    }

    @Override
    public void setClassLabel(IdentifiedAnnotation entityOrEventMention, Instance<String> instance) throws AnalysisEngineProcessException {
        if (this.isTraining()) {
            String polarity;
            this.lastLabel = polarity = entityOrEventMention.getPolarity() == -1 ? "NEGATED" : "NOT_NEGATED";
            if ("NEGATED".equals(polarity)) {
                this.logger.debug((Object)("TRAINING: " + polarity));
            }
            if ("NOT_NEGATED".equals(polarity) && coin.nextDouble() >= this.probabilityOfKeepingADefaultExample) {
                return;
            }
            instance.setOutcome((Object)polarity);
        } else {
            String label;
            this.lastLabel = label = (String)this.classifier.classify(instance.getFeatures());
            int polarity = 1;
            if ("NOT_NEGATED".equals(label)) {
                polarity = 1;
            } else if ("NEGATED".equals(label)) {
                polarity = -1;
                this.logger.debug((Object)String.format("DECODING/EVAL: %s//%s [%d-%d] (%s)", label, polarity, entityOrEventMention.getBegin(), entityOrEventMention.getEnd(), entityOrEventMention.getClass().getName()));
            }
            entityOrEventMention.setPolarity(polarity);
        }
    }

    public static FeatureSelection<String> createFeatureSelection(double threshold) {
        return new Chi2FeatureSelection<String>("SelectNeighborFeatures", threshold, false);
    }

    public static URI createFeatureSelectionURI(File outputDirectoryName) {
        return new File(outputDirectoryName, "SelectNeighborFeatures_Chi2_extractor.dat").toURI();
    }

    private void initializeDomainAdaptation() {
        this.featureFunctionExtractors = new ArrayList();
        this.featureFunctionExtractors.addAll(ExtractorListFeatureFunctionConverter.convert(this.contextFeatureExtractors, this.ffDomainAdaptor));
        this.featureFunctionExtractors.addAll(ExtractorListFeatureFunctionConverter.convert(this.tokenContextFeatureExtractors, this.ffDomainAdaptor));
        this.featureFunctionExtractors.addAll(ExtractorListFeatureFunctionConverter.convert(this.tokenCleartkExtractors, this.ffDomainAdaptor));
        this.featureFunctionExtractors.addAll(ExtractorListFeatureFunctionConverter.convert(this.entityFeatureExtractors, this.ffDomainAdaptor));
        this.featureFunctionExtractors.add(new FeatureFunctionExtractor((FeatureExtractor1)this.cuePhraseInWindowExtractor, new FeatureFunction[]{this.ffDomainAdaptor}));
    }

    @Override
    protected void initializeFeatureSelection() throws ResourceInitializationException {
        this.featureSelection = this.featureSelectionThreshold.floatValue() == 0.0f ? null : PolarityFedaCleartkAnalysisEngine.createFeatureSelection(this.featureSelectionThreshold.floatValue());
    }
}

