/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts.cleartk;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.ctakes.assertion.eval.AssertionEvaluation;
import org.apache.ctakes.assertion.medfacts.cleartk.AssertionComponents;
import org.apache.ctakes.assertion.medfacts.cleartk.ConditionalCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.GenericCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.PolarityCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.SubjectCleartkAnalysisEngine;
import org.apache.ctakes.assertion.medfacts.cleartk.UncertaintyCleartkAnalysisEngine;
import org.apache.ctakes.core.cc.XmiWriterCasConsumerCtakes;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.fit.factory.AggregateBuilder;
import org.apache.uima.fit.factory.AnalysisEngineFactory;
import org.apache.uima.fit.factory.ConfigurationParameterFactory;
import org.apache.uima.resource.ResourceCreationSpecifier;
import org.apache.uima.resource.metadata.TypeSystemDescription;

public class CreateAssertionDescriptor {
    public static void main(String[] args) throws Exception {
        CreateAssertionDescriptor creator = new CreateAssertionDescriptor();
        creator.execute();
    }

    public void execute() throws Exception {
        this.createTrainDescriptor();
        this.createTestDescriptor();
    }

    public void createTrainDescriptor() throws Exception {
        File trainDirectory;
        File directory = trainDirectory = new File("/tmp/assertion_data/train");
        AggregateBuilder builder = new AggregateBuilder();
        AnalysisEngineDescription goldCopierIdentifiedAnnotsAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionEvaluation.ReferenceIdentifiedAnnotationsSystemToGoldCopier.class, (Object[])new Object[0]);
        builder.add(goldCopierIdentifiedAnnotsAnnotator, new String[0]);
        AnalysisEngineDescription goldCopierSupportingAnnotsAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionEvaluation.ReferenceSupportingAnnotationsSystemToGoldCopier.class, (Object[])new Object[0]);
        builder.add(goldCopierSupportingAnnotsAnnotator, new String[0]);
        AnalysisEngineDescription assertionAttributeClearerAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionEvaluation.ReferenceAnnotationsSystemAssertionClearer.class, (Object[])new Object[0]);
        builder.add(assertionAttributeClearerAnnotator, new String[0]);
        AnalysisEngineDescription polarityAnnotator = AnalysisEngineFactory.createEngineDescription(PolarityCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)polarityAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "outputDirectory", new File(directory, "polarity").getPath()});
        builder.add(polarityAnnotator, new String[0]);
        AnalysisEngineDescription conditionalAnnotator = AnalysisEngineFactory.createEngineDescription(ConditionalCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)conditionalAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "outputDirectory", new File(directory, "conditional").getPath()});
        builder.add(conditionalAnnotator, new String[0]);
        AnalysisEngineDescription uncertaintyAnnotator = AnalysisEngineFactory.createEngineDescription(UncertaintyCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)uncertaintyAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "outputDirectory", new File(directory, "uncertainty").getPath()});
        builder.add(uncertaintyAnnotator, new String[0]);
        AnalysisEngineDescription subjectAnnotator = AnalysisEngineFactory.createEngineDescription(SubjectCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)subjectAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "dataWriterFactoryClassName", new File(directory, "subject").getPath()});
        builder.add(subjectAnnotator, new String[0]);
        AnalysisEngineDescription genericAnnotator = AnalysisEngineFactory.createEngineDescription(GenericCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)genericAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "outputDirectory", new File(directory, "generic").getPath()});
        builder.add(genericAnnotator, new String[0]);
        FileOutputStream outputStream = new FileOutputStream("desc/analysis_engine/assertion_train.xml");
        AnalysisEngineDescription description = builder.createAggregateDescription();
        description.toXML((OutputStream)outputStream);
    }

    public void createTestDescriptor() throws Exception {
        File testDirectory;
        File directory = testDirectory = new File("/tmp/assertion_data/test");
        File testOutputDirectory = new File("/tmp/assertion_data/test_output");
        AggregateBuilder builder = new AggregateBuilder();
        AnalysisEngineDescription goldCopierAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionEvaluation.ReferenceIdentifiedAnnotationsSystemToGoldCopier.class, (Object[])new Object[0]);
        builder.add(goldCopierAnnotator, new String[0]);
        AnalysisEngineDescription assertionAttributeClearerAnnotator = AnalysisEngineFactory.createEngineDescription(AssertionEvaluation.ReferenceAnnotationsSystemAssertionClearer.class, (Object[])new Object[0]);
        builder.add(assertionAttributeClearerAnnotator, new String[0]);
        AnalysisEngineDescription polarityAnnotator = AnalysisEngineFactory.createEngineDescription(PolarityCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)polarityAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "classifierJarPath", new File(new File(directory, "polarity"), "model.jar").getPath()});
        builder.add(polarityAnnotator, new String[0]);
        AnalysisEngineDescription conditionalAnnotator = AnalysisEngineFactory.createEngineDescription(ConditionalCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)conditionalAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "classifierJarPath", new File(new File(directory, "conditional"), "model.jar").getPath()});
        builder.add(conditionalAnnotator, new String[0]);
        AnalysisEngineDescription uncertaintyAnnotator = AnalysisEngineFactory.createEngineDescription(UncertaintyCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)uncertaintyAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "classifierJarPath", new File(new File(directory, "uncertainty"), "model.jar").getPath()});
        builder.add(uncertaintyAnnotator, new String[0]);
        AnalysisEngineDescription subjectAnnotator = AnalysisEngineFactory.createEngineDescription(SubjectCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)subjectAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "classifierJarPath", new File(new File(directory, "subject"), "model.jar").getPath()});
        builder.add(subjectAnnotator, new String[0]);
        AnalysisEngineDescription genericAnnotator = AnalysisEngineFactory.createEngineDescription(GenericCleartkAnalysisEngine.class, (Object[])new Object[0]);
        ConfigurationParameterFactory.addConfigurationParameters((ResourceCreationSpecifier)genericAnnotator, (Object[])new Object[]{"GoldViewName", "GoldView", "classifierJarPath", new File(new File(directory, "generic"), "model.jar").getPath()});
        builder.add(genericAnnotator, new String[0]);
        AnalysisEngineDescription xwriter = AnalysisEngineFactory.createEngineDescription(XmiWriterCasConsumerCtakes.class, (TypeSystemDescription)AssertionComponents.CTAKES_CTS_TYPE_SYSTEM_DESCRIPTION, (Object[])new Object[]{"OutputDirectory", testOutputDirectory});
        builder.add(xwriter, new String[0]);
        FileOutputStream outputStream = new FileOutputStream("desc/analysis_engine/assertion_test.xml");
        AnalysisEngineDescription description = builder.createAggregateDescription();
        description.toXML((OutputStream)outputStream);
    }
}

