/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.medfacts;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.ctakes.assertion.medfacts.ConceptConverterAnalysisEngine;
import org.apache.ctakes.assertion.stub.ConceptType;
import org.apache.ctakes.typesystem.type.refsem.OntologyConcept;
import org.apache.ctakes.typesystem.type.refsem.UmlsConcept;
import org.apache.log4j.Logger;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.cas.FSArray;

public class ConceptLookup {
    public static final Logger logger = Logger.getLogger((String)ConceptConverterAnalysisEngine.class.getName());
    protected static HashSet<String> problemSet = new HashSet();
    protected static HashSet<String> testSet = new HashSet();
    protected static HashSet<String> treatmentSet = new HashSet();
    protected static HashSet<String> ignoredSet = new HashSet();
    public static final String REVERSE_LOOKUP_PROBLEM_TUI = "T019";
    public static final String REVERSE_LOOKUP_TEST_TUI = "T059";
    public static final String REVERSE_LOOKUP_TREATMENT_TUI = "T116";

    public static ConceptType lookupConceptType(FSArray ontologyConceptArray) {
        boolean hasConcept;
        FeatureStructure firstConceptFS = null;
        boolean bl = hasConcept = ontologyConceptArray != null && ontologyConceptArray.size() >= 1 && ontologyConceptArray.get(0) instanceof OntologyConcept;
        if (hasConcept) {
            firstConceptFS = ontologyConceptArray.get(0);
        }
        OntologyConcept ontologyConcept = (OntologyConcept)firstConceptFS;
        boolean isRxnorm = false;
        boolean isUmls = false;
        UmlsConcept umlsConcept = null;
        if (ontologyConcept == null) {
            return null;
        }
        if (ontologyConcept instanceof UmlsConcept) {
            isUmls = true;
            umlsConcept = (UmlsConcept)firstConceptFS;
        } else {
            isRxnorm = "RXNORM".equalsIgnoreCase(ontologyConcept.getCodingScheme());
        }
        if (isRxnorm) {
            return ConceptType.TREATMENT;
        }
        if (!isUmls) {
            return null;
        }
        String tui = umlsConcept.getTui();
        ConceptType conceptType = null;
        conceptType = problemSet.contains(tui) ? ConceptType.PROBLEM : (testSet.contains(tui) ? ConceptType.TEST : (treatmentSet.contains(tui) ? ConceptType.TREATMENT : null));
        return conceptType;
    }

    public static FSArray reverseLookup(ConceptType conceptType, JCas jcas) {
        if (conceptType == null) {
            return null;
        }
        FSArray ontologyConceptArray = new FSArray(jcas, 1);
        OntologyConcept ontologyConcept = new OntologyConcept(jcas);
        String codingScheme = null;
        String code = null;
        if (conceptType.equals(ConceptType.TREATMENT)) {
            codingScheme = "RXNORM";
            code = REVERSE_LOOKUP_TREATMENT_TUI;
        } else if (conceptType.equals(ConceptType.PROBLEM)) {
            codingScheme = "SNOMEDCT";
            code = REVERSE_LOOKUP_PROBLEM_TUI;
        } else if (conceptType.equals(ConceptType.TEST)) {
            codingScheme = "SNOMEDCT";
            code = REVERSE_LOOKUP_TEST_TUI;
        } else {
            codingScheme = null;
            code = null;
        }
        ontologyConcept.setCode(code);
        ontologyConcept.setCodingScheme(codingScheme);
        ontologyConceptArray.set(0, (FeatureStructure)ontologyConcept);
        return ontologyConceptArray;
    }

    static {
        String[] diseasesAndDisordersTuis = new String[]{REVERSE_LOOKUP_PROBLEM_TUI, "T020", "T037", "T046", "T047", "T048", "T049", "T050", "T190", "T191", "T033", "T_DD"};
        String[] signAndSymptomTuis = new String[]{"T184", "T_SS"};
        String[] anatomicalSitesTuis = new String[]{"T017", "T029", "T023", "T030", "T031", "T022", "T025", "T026", "T018", "T021", "T024", "T_AS"};
        String[] medicationsAndDrugsTuis = new String[]{REVERSE_LOOKUP_TREATMENT_TUI, "T195", "T123", "T122", "T118", "T103", "T120", "T104", "T200", "T111", "T196", "T126", "T131", "T125", "T129", "T130", "T197", "T119", "T124", "T114", "T109", "T115", "T121", "T192", "T110", "T127"};
        String[] proceduresTuis = new String[]{"T060", "T065", "T058", REVERSE_LOOKUP_TEST_TUI, "T063", "T062", "T061", "T_PR"};
        String[] deviceTuis = new String[]{"T074", "T075"};
        String[] laboratoryTuis = new String[]{REVERSE_LOOKUP_TEST_TUI};
        HashSet<String> problemSet = new HashSet<String>();
        HashSet<String> testSet = new HashSet<String>();
        HashSet<String> treatmentSet = new HashSet<String>();
        HashSet<String> ignoredSet = new HashSet<String>();
        problemSet.addAll(Arrays.asList(diseasesAndDisordersTuis));
        problemSet.addAll(Arrays.asList(signAndSymptomTuis));
        ignoredSet.addAll(Arrays.asList(anatomicalSitesTuis));
        treatmentSet.addAll(Arrays.asList(medicationsAndDrugsTuis));
        testSet.addAll(Arrays.asList(proceduresTuis));
        treatmentSet.addAll(Arrays.asList(deviceTuis));
        testSet.addAll(Arrays.asList(laboratoryTuis));
        ConceptLookup.problemSet = problemSet;
        ConceptLookup.testSet = testSet;
        ConceptLookup.treatmentSet = treatmentSet;
        ConceptLookup.ignoredSet = ignoredSet;
    }
}

