/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ctakes.assertion.cr;

import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Scanner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ctakes.core.pipeline.PipeBitInfo;
import org.apache.ctakes.typesystem.type.structured.DocumentID;
import org.apache.ctakes.typesystem.type.textsem.EventMention;
import org.apache.log4j.Logger;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.CASException;
import org.apache.uima.collection.CollectionException;
import org.apache.uima.collection.CollectionReader_ImplBase;
import org.apache.uima.jcas.JCas;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Progress;
import org.apache.uima.util.ProgressImpl;

@PipeBitInfo(name="I2B2 Challenge Reader", description="Reads entities and their properties from file. ", role=PipeBitInfo.Role.SPECIAL, products={PipeBitInfo.TypeProduct.DOCUMENT_ID, PipeBitInfo.TypeProduct.IDENTIFIED_ANNOTATION})
public class I2B2Challenge2010CollectionReader
extends CollectionReader_ImplBase {
    public static final String PARAM_INPUTDIR = "inputDir";
    public static final String PARAM_FNMATCH = "fnMatch";
    File[] docs = null;
    private String astDir = null;
    private String match = null;
    private boolean fnMatch = false;
    int index = 0;
    private String mEncoding = null;
    Pattern astPatt = Pattern.compile("c=\"(.*)\" (\\d+):(\\d+) (\\d+):(\\d+)\\|\\|t=\"(.*)\"\\|\\|a=\"(.*)\"");
    Logger logger = Logger.getLogger(((Object)((Object)this)).getClass());
    HashMap<String, String> conLocs = new HashMap();

    public void initialize() throws ResourceInitializationException {
        String inputDir = (String)this.getConfigParameterValue(PARAM_INPUTDIR);
        File docDir = new File(inputDir + File.separator + "txt");
        this.match = (String)this.getConfigParameterValue(PARAM_FNMATCH);
        if (this.match != null) {
            this.fnMatch = true;
        }
        if (!docDir.exists() || !docDir.isDirectory()) {
            throw new ResourceInitializationException((Throwable)new RuntimeException("Unable to get list of files within " + docDir.getAbsolutePath()));
        }
        this.docs = docDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith("txt") && (!I2B2Challenge2010CollectionReader.this.fnMatch || name.contains(I2B2Challenge2010CollectionReader.this.match));
            }
        });
        this.astDir = new String(inputDir + File.separator + "ast");
    }

    public void getNext(CAS aCAS) throws IOException, CollectionException {
        JCas jcas;
        Scanner scanner = null;
        try {
            jcas = aCAS.getJCas();
        }
        catch (CASException e) {
            throw new CollectionException((Throwable)e);
        }
        HashMap<Point, Integer> word2char = new HashMap<Point, Integer>();
        File file = this.docs[this.index];
        String fn = file.getName();
        this.logger.info((Object)("Reading file: " + fn));
        fn = fn.substring(0, fn.lastIndexOf(46));
        DocumentID docId = new DocumentID(jcas);
        docId.setDocumentID(fn);
        docId.addToIndexes();
        scanner = new Scanner(file);
        int lineNum = 1;
        int charNum = 0;
        while (scanner.hasNextLine()) {
            int i;
            String line = scanner.nextLine();
            String[] tokens = line.split(" ");
            for (i = 0; i < tokens.length; ++i) {
                Point pair = new Point(lineNum, i);
                word2char.put(pair, charNum);
                charNum += tokens[i].length() + 1;
            }
            if (line.length() > 0) {
                for (i = 1; i < line.length() && line.charAt(line.length() - i) == ' '; ++i) {
                    ++charNum;
                    if (i <= 1) continue;
                    System.err.println(fn + "contains some weird lines.");
                }
            }
            ++lineNum;
        }
        FileInputStream fis = new FileInputStream(file);
        byte[] contents = new byte[(int)file.length()];
        fis.read(contents);
        jcas.setDocumentText(new String(contents));
        File astFile = new File(this.astDir + File.separator + fn + ".ast");
        if (astFile.exists()) {
            scanner = new Scanner(astFile);
            while (scanner.hasNextLine()) {
                Point pair;
                String line = scanner.nextLine().trim();
                Matcher m = this.astPatt.matcher(line);
                if (!m.matches() || !word2char.containsKey(pair = new Point(Integer.parseInt(m.group(2)), Integer.parseInt(m.group(3))))) continue;
                int charOffset = (Integer)word2char.get(pair);
                int end = charOffset + m.group(1).length();
                EventMention mention = new EventMention(jcas, charOffset, end);
                mention.setPolarity(1);
                mention.setConditional(false);
                mention.setUncertainty(0);
                mention.setGeneric(false);
                mention.setSubject("patient");
                if (m.group(7).equals("absent")) {
                    mention.setPolarity(-1);
                } else if (m.group(7).equals("hypothetical")) {
                    mention.setConditional(true);
                } else if (m.group(7).equals("possible")) {
                    mention.setUncertainty(1);
                } else if (m.group(7).equals("associated_with_someone_else")) {
                    mention.setSubject("family_member");
                } else if (m.group(7).equals("conditional")) {
                    // empty if block
                }
                mention.addToIndexes();
            }
        }
        ++this.index;
        this.logger.info((Object)("Done reading file: " + fn));
    }

    public boolean hasNext() throws IOException, CollectionException {
        if (this.docs == null) {
            throw new RuntimeException("docs == null");
        }
        return this.index < this.docs.length;
    }

    public Progress[] getProgress() {
        ProgressImpl p = new ProgressImpl(this.index, this.docs.length, "entities");
        return new Progress[]{p};
    }

    public void close() throws IOException {
    }
}

