/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTInput;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.args4j.Option;

public class DEPEvaluate
extends AbstractRun {
    @Option(name="-g", usage="gold-standard file (required)", required=true, metaVar="<filename>")
    private String s_goldFile;
    @Option(name="-s", usage="system-generated file (required)", required=true, metaVar="<filename>")
    private String s_autoFile;
    @Option(name="-gh", usage="column index of gold head ID (required)", required=true, metaVar="<integer>")
    private int i_goldHeadId;
    @Option(name="-gd", usage="column index of gold dependency label (required)", required=true, metaVar="<integer>")
    private int i_goldDeprel;
    @Option(name="-sh", usage="column index of system head ID (required)", required=true, metaVar="<integer>")
    private int i_autoHeadId;
    @Option(name="-sd", usage="column index of system dependency label (required)", required=true, metaVar="<integer>")
    private int i_autoDeprel;
    private Map<String, int[]> m_labels;

    public DEPEvaluate() {
    }

    public DEPEvaluate(String[] args) {
        this.initArgs(args);
        this.run(this.s_goldFile, this.s_autoFile, this.i_goldHeadId - 1, this.i_goldDeprel - 1, this.i_autoHeadId - 1, this.i_autoDeprel - 1);
    }

    public void run(String goldFile, String autoFile, int goldHeadId, int goldDeprel, int autoHeadId, int autoDeprel) {
        BufferedReader fGold = UTInput.createBufferedFileReader(goldFile);
        BufferedReader fAuto = UTInput.createBufferedFileReader(autoFile);
        this.m_labels = new HashMap<String, int[]>();
        try {
            String line;
            while ((line = fGold.readLine()) != null) {
                String[] gold = line.split("\t");
                String[] auto = fAuto.readLine().split("\t");
                if ((line = line.trim()).isEmpty()) continue;
                int[] counts = this.getCounts(gold[goldDeprel]);
                if (gold[goldDeprel].equals(auto[autoDeprel])) {
                    counts[2] = counts[2] + 1;
                    if (gold[goldHeadId].equals(auto[autoHeadId])) {
                        counts[0] = counts[0] + 1;
                    }
                }
                if (gold[goldHeadId].equals(auto[autoHeadId])) {
                    counts[1] = counts[1] + 1;
                }
                counts[3] = counts[3] + 1;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.print();
    }

    private void print() {
        String hline = "------------------------------------------------------------";
        System.out.println(hline);
        System.out.printf("%10s%10s%10s%10s%10s%10s\n", "Label", "Count", "Dist.", "LAS", "UAS", "LS");
        System.out.println(hline);
        int[] counts = this.getTotalCounts();
        int total = counts[3];
        this.printAccuracy("ALL", total, counts);
        System.out.println(hline);
        ArrayList<String> tags = new ArrayList<String>(this.m_labels.keySet());
        Collections.sort(tags);
        for (String tag : tags) {
            this.printAccuracy(tag, total, this.m_labels.get(tag));
        }
        System.out.println(hline);
    }

    private void printAccuracy(String label, int total, int[] counts) {
        int t = counts[3];
        System.out.printf("%10s%10d%10.2f%10.2f%10.2f%10.2f\n", label, t, 100.0 * (double)t / (double)total, 100.0 * (double)counts[0] / (double)t, 100.0 * (double)counts[1] / (double)t, 100.0 * (double)counts[2] / (double)t);
    }

    private int[] getCounts(String tag) {
        int[] counts;
        if (this.m_labels.containsKey(tag)) {
            counts = this.m_labels.get(tag);
        } else {
            counts = new int[4];
            this.m_labels.put(tag, counts);
        }
        return counts;
    }

    private int[] getTotalCounts() {
        int[] gCounts = null;
        for (String tag : this.m_labels.keySet()) {
            int[] lCounts = this.m_labels.get(tag);
            if (gCounts == null) {
                gCounts = Arrays.copyOf(lCounts, lCounts.length);
                continue;
            }
            for (int i = 0; i < gCounts.length; ++i) {
                int n = i;
                gCounts[n] = gCounts[n] + lCounts[i];
            }
        }
        return gCounts;
    }

    public static void main(String[] args) {
        new DEPEvaluate(args);
    }
}

