/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.run;

import com.carrotsearch.hppc.IntObjectOpenHashMap;
import com.carrotsearch.hppc.IntOpenHashSet;
import com.googlecode.clearnlp.constituent.CTLibEn;
import com.googlecode.clearnlp.constituent.CTNode;
import com.googlecode.clearnlp.constituent.CTReader;
import com.googlecode.clearnlp.constituent.CTTree;
import com.googlecode.clearnlp.conversion.AbstractC2DConverter;
import com.googlecode.clearnlp.dependency.DEPArc;
import com.googlecode.clearnlp.dependency.DEPFeat;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.engine.EngineGetter;
import com.googlecode.clearnlp.morphology.AbstractMPAnalyzer;
import com.googlecode.clearnlp.propbank.PBArg;
import com.googlecode.clearnlp.propbank.PBInstance;
import com.googlecode.clearnlp.propbank.PBLib;
import com.googlecode.clearnlp.propbank.PBLoc;
import com.googlecode.clearnlp.run.AbstractRun;
import com.googlecode.clearnlp.util.UTFile;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.pair.StringIntPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.kohsuke.args4j.Option;

public class C2DConvertMulti
extends AbstractRun {
    @Option(name="-i", usage="input path (required)", required=true, metaVar="<filepath>")
    private String s_inputPath;
    @Option(name="-h", usage="name of a headrule file (required)", required=true, metaVar="<filename>")
    private String s_headruleFile;
    @Option(name="-d", usage="name of a dictionary file", required=true, metaVar="<filename>")
    private String s_dictFile;
    @Option(name="-et", usage="parse-file extension (default: parse)", required=false, metaVar="<extension>")
    private String s_parseExt = "parse";
    @Option(name="-ep", usage="prop-file extension (default: prop)", required=false, metaVar="<extension>")
    private String s_propExt = "prop";
    @Option(name="-es", usage="sense-file extension (default: sense)", required=false, metaVar="<extension>")
    private String s_senseExt = "sense";
    @Option(name="-ev", usage="vclass-file extension (default: sl)", required=false, metaVar="<extension>")
    private String s_vclassExt = "sl";
    @Option(name="-en", usage="name-file extension (default: name)", required=false, metaVar="<extension>")
    private String s_nameExt = "name";
    @Option(name="-ed", usage="output-file extension (default: dep)", required=false, metaVar="<extension>")
    private String s_outputExt = "dep";
    @Option(name="-l", usage="language (default: en)", required=false, metaVar="<language>")
    private String s_language = "en";
    @Option(name="-m", usage="merge specified labels", required=false, metaVar="<string>")
    private String s_mergeLabels = null;
    @Option(name="-v", usage="if set, add only verb predicates in PropBank", required=false, metaVar="<boolean>")
    private boolean b_verbs_only = false;
    final Pattern P_SPACE = Pattern.compile(" ");
    final Pattern P_HYPHEN = Pattern.compile("-");
    final Pattern P_COLON = Pattern.compile(":");

    public C2DConvertMulti(String[] args) {
        this.initArgs(args);
        this.convert(this.s_headruleFile, this.s_dictFile, this.s_language, this.s_mergeLabels, this.s_inputPath, this.s_parseExt, this.s_propExt, this.s_senseExt, this.s_vclassExt, this.s_nameExt, this.s_outputExt);
    }

    public void convert(String headruleFile, String dictFile, String language, String mergeLabels, String inputPath, String parseExt, String propExt, String senseExt, String vclassExt, String nameExt, String outputExt) {
        AbstractMPAnalyzer morph = EngineGetter.getMPAnalyzer(this.s_language, this.s_dictFile);
        AbstractC2DConverter c2d = EngineGetter.getC2DConverter(this.s_language, this.s_headruleFile, this.s_mergeLabels);
        this.convertRec(c2d, morph, language, inputPath, parseExt, propExt, senseExt, vclassExt, nameExt, outputExt);
    }

    private void convertRec(AbstractC2DConverter c2d, AbstractMPAnalyzer morph, String language, String inputPath, String parseExt, String propExt, String senseExt, String vclassExt, String nameExt, String outputExt) {
        File file = new File(inputPath);
        if (file.isDirectory()) {
            for (String filePath : file.list()) {
                this.convertRec(c2d, morph, language, inputPath + File.separator + filePath, parseExt, propExt, senseExt, vclassExt, nameExt, outputExt);
            }
        } else if (inputPath.endsWith(parseExt)) {
            CTTree cTree;
            System.out.println(inputPath);
            IntObjectOpenHashMap<List<PBInstance>> mProp = null;
            IntObjectOpenHashMap<List<StringIntPair>> mSense = null;
            IntObjectOpenHashMap<List<StringIntPair>> mVclass = null;
            IntObjectOpenHashMap<List<String>> mName = null;
            try {
                mProp = this.getPBInstances(UTFile.replaceExtension(inputPath, propExt));
                mSense = this.getWordSenses(UTFile.replaceExtension(inputPath, senseExt));
                mVclass = this.getVerbClasses(UTFile.replaceExtension(inputPath, vclassExt));
                mName = this.getNames(UTFile.replaceExtension(inputPath, nameExt));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            PrintStream fout = UTOutput.createPrintBufferedFileStream(UTFile.replaceExtension(inputPath, outputExt));
            CTReader reader = new CTReader(UTInput.createBufferedFileReader(inputPath));
            List instances = null;
            int n = 0;
            while ((cTree = reader.nextTree()) != null) {
                DEPTree dTree;
                if (language.equals("en")) {
                    CTLibEn.preprocessTree(cTree);
                }
                if (mProp != null) {
                    instances = (List)mProp.get(n);
                    this.addPBInstances(cTree, instances);
                }
                if ((dTree = c2d.toDEPTree(cTree)) != null) {
                    if (morph != null) {
                        morph.lemmatize(dTree);
                    }
                    if (mProp != null) {
                        this.addRolesets(cTree, dTree, instances);
                    }
                    if (mSense != null) {
                        this.addWordSenses(cTree, dTree, (List)mSense.get(n), "ws");
                    }
                    if (mVclass != null) {
                        this.addWordSenses(cTree, dTree, (List)mVclass.get(n), "vn");
                    }
                    if (mName != null) {
                        this.addNames(cTree, dTree, (List)mName.get(n));
                    }
                    dTree = this.getDEPTreeWithoutEdited(cTree, dTree);
                    fout.println(dTree + "\n");
                }
                ++n;
            }
            fout.close();
            reader.close();
        }
    }

    public DEPTree getDEPTreeWithoutEdited(CTTree cTree, DEPTree dTree) {
        IntOpenHashSet set = new IntOpenHashSet();
        this.addEditedTokensAux(cTree.getRoot(), set);
        int size = dTree.size();
        DEPTree tree = new DEPTree();
        int j = 1;
        for (int i = 1; i < size; ++i) {
            if (set.contains(i)) continue;
            DEPNode node = dTree.get(i);
            node.id = j++;
            this.removeEditedHeads(node.getXHeads(), set);
            this.removeEditedHeads(node.getSHeads(), set);
            tree.add(node);
        }
        return tree.size() == 1 ? null : tree;
    }

    private void addEditedTokensAux(CTNode curr, IntOpenHashSet set) {
        for (CTNode child : curr.getChildren()) {
            if (child.isPTag("EDITED") || child.getChildrenSize() == 1 && child.getChild(0).isPTag("EDITED")) {
                for (CTNode sub : child.getSubTokens()) {
                    set.add(sub.getTokenId() + 1);
                }
                continue;
            }
            if (!child.isPhrase()) continue;
            this.addEditedTokensAux(child, set);
        }
    }

    private void removeEditedHeads(List<DEPArc> heads, IntOpenHashSet set) {
        ArrayList<DEPArc> remove = new ArrayList<DEPArc>();
        for (DEPArc arc : heads) {
            if (!set.contains(arc.getNode().id)) continue;
            remove.add(arc);
        }
        heads.removeAll(remove);
    }

    private IntObjectOpenHashMap<List<PBInstance>> getPBInstances(String propFile) {
        if (!new File(propFile).isFile()) {
            return null;
        }
        IntObjectOpenHashMap map = new IntObjectOpenHashMap();
        for (PBInstance inst : PBLib.getPBInstanceList(propFile)) {
            List<PBInstance> list;
            if (map.containsKey(inst.treeId)) {
                list = (List)map.get(inst.treeId);
            } else {
                list = new ArrayList();
                map.put(inst.treeId, list);
            }
            list.add(inst);
        }
        return map;
    }

    private void addPBInstances(CTTree cTree, List<PBInstance> instances) {
        if (instances == null) {
            return;
        }
        this.initPBArgs(cTree.getRoot());
        for (PBInstance instance : instances) {
            if (this.isPBSkip(instance, cTree)) continue;
            int predTokenId = cTree.getTerminal(instance.predId).getTokenId() + 1;
            for (PBArg arg : instance.getArgs()) {
                if (arg.label.startsWith("LINK") || arg.label.endsWith("UNDEF")) continue;
                String label = arg.isLabel("rel") ? "C-V" : "A" + arg.label.substring(3);
                for (PBLoc loc : arg.getLocs()) {
                    CTNode cNode;
                    if (arg.isLabel("rel") && loc.terminalId == instance.predId || (cNode = cTree.getNode(loc)).isEmptyCategoryRec()) continue;
                    cNode.pbArgs.add(new StringIntPair(label, predTokenId));
                }
            }
        }
    }

    private boolean isPBSkip(PBInstance instance, CTTree cTree) {
        if (PBLib.ILLEGAL_ROLESET.matcher(instance.roleset).find()) {
            return true;
        }
        return this.b_verbs_only && !instance.isVerbPredicate() && !instance.isLVNounPredicate(cTree);
    }

    private void initPBArgs(CTNode node) {
        node.pbArgs = new ArrayList<StringIntPair>();
        for (CTNode child : node.getChildren()) {
            this.initPBArgs(child);
        }
    }

    private IntObjectOpenHashMap<List<StringIntPair>> getWordSenses(String senseFile) throws Exception {
        String line;
        if (!new File(senseFile).isFile()) {
            return null;
        }
        IntObjectOpenHashMap map = new IntObjectOpenHashMap();
        BufferedReader fin = UTInput.createBufferedFileReader(senseFile);
        while ((line = fin.readLine()) != null) {
            List<StringIntPair> list;
            String[] tmp = this.P_SPACE.split(line);
            int treeId = Integer.parseInt(tmp[1]);
            int wordId = Integer.parseInt(tmp[2]);
            String sense = tmp[3].substring(0, tmp[3].length() - 2) + "." + tmp[4];
            if (map.containsKey(treeId)) {
                list = (List)map.get(treeId);
            } else {
                list = new ArrayList();
                map.put(treeId, list);
            }
            list.add(new StringIntPair(sense, wordId));
        }
        fin.close();
        return map;
    }

    private IntObjectOpenHashMap<List<StringIntPair>> getVerbClasses(String vclassFile) throws Exception {
        String line;
        if (!new File(vclassFile).isFile()) {
            return null;
        }
        IntObjectOpenHashMap map = new IntObjectOpenHashMap();
        BufferedReader fin = UTInput.createBufferedFileReader(vclassFile);
        while ((line = fin.readLine()) != null) {
            List<StringIntPair> list;
            String[] tmp = this.P_SPACE.split(line);
            int treeId = Integer.parseInt(tmp[1]);
            int wordId = Integer.parseInt(tmp[2]);
            String vclass = tmp[5];
            if (map.containsKey(treeId)) {
                list = (List)map.get(treeId);
            } else {
                list = new ArrayList();
                map.put(treeId, list);
            }
            list.add(new StringIntPair(vclass, wordId));
        }
        fin.close();
        return map;
    }

    private IntObjectOpenHashMap<List<String>> getNames(String nameFile) throws Exception {
        String line;
        if (!new File(nameFile).isFile()) {
            return null;
        }
        IntObjectOpenHashMap map = new IntObjectOpenHashMap();
        BufferedReader fin = UTInput.createBufferedFileReader(nameFile);
        while ((line = fin.readLine()) != null) {
            String[] tmp = this.P_SPACE.split(line);
            int treeId = Integer.parseInt(tmp[1]);
            ArrayList<String> list = new ArrayList<String>();
            for (int i = 2; i < tmp.length; ++i) {
                list.add(tmp[i]);
            }
            map.put(treeId, list);
        }
        fin.close();
        return map;
    }

    private void addRolesets(CTTree cTree, DEPTree dTree, List<PBInstance> instances) {
        if (instances == null) {
            return;
        }
        for (PBInstance inst : instances) {
            if (this.isPBSkip(inst, cTree)) continue;
            DEPNode pred = dTree.get(cTree.getTerminal(inst.predId).getTokenId() + 1);
            pred.addFeat("pb", inst.roleset);
            if (!this.s_language.equals("en")) continue;
            pred.lemma = inst.roleset.substring(0, inst.roleset.lastIndexOf("."));
        }
    }

    private void addWordSenses(CTTree cTree, DEPTree dTree, List<StringIntPair> p, String key) {
        if (p == null) {
            return;
        }
        for (StringIntPair sense : p) {
            DEPNode node = dTree.get(cTree.getTerminal(sense.i).getTokenId() + 1);
            node.addFeat(key, sense.s);
        }
    }

    private void addNames(CTTree cTree, DEPTree dTree, List<String> names) {
        int i;
        if (names == null) {
            return;
        }
        int size = dTree.size();
        for (i = 1; i < size; ++i) {
            dTree.get((int)i).nament = "O";
        }
        for (String name : names) {
            DEPNode node;
            int eIdx;
            String[] t0 = this.P_HYPHEN.split(name);
            String[] t1 = this.P_COLON.split(t0[0]);
            String ent = t0[1];
            int bIdx = Integer.parseInt(t1[0]);
            if (bIdx == (eIdx = Integer.parseInt(t1[1]))) {
                node = dTree.get(cTree.getTerminal(bIdx).getTokenId() + 1);
                node.nament = "U-" + ent;
                continue;
            }
            node = dTree.get(cTree.getTerminal(bIdx).getTokenId() + 1);
            node.nament = "B-" + ent;
            for (i = bIdx + 1; i < eIdx; ++i) {
                node = dTree.get(cTree.getTerminal(i).getTokenId() + 1);
                node.nament = "I-" + ent;
            }
            node = dTree.get(cTree.getTerminal(eIdx).getTokenId() + 1);
            node.nament = "L-" + ent;
        }
    }

    public DEPTree getNullTree() {
        DEPTree tree = new DEPTree();
        DEPNode dummy = new DEPNode(1, "NULL", "NULL", "NULL", new DEPFeat());
        dummy.setHead(tree.get(0), "NULL");
        tree.add(dummy);
        tree.initXHeads();
        tree.initSHeads();
        return tree;
    }

    public static void main(String[] args) {
        new C2DConvertMulti(args);
    }
}

