/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.propbank.verbnet;

import com.googlecode.clearnlp.propbank.verbnet.PVRoles;
import com.googlecode.clearnlp.util.UTXml;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PVRoleset
extends HashMap<String, PVRoles> {
    public static final String ATTR_ID = "id";
    String s_rolesetId;

    public PVRoleset(Element eRoleset, String rolesetId, boolean fromMap) {
        this.s_rolesetId = rolesetId;
        if (fromMap) {
            this.initRolesFromMap(eRoleset);
        } else {
            this.initRolesFromFrameset(eRoleset);
        }
    }

    private void initRolesFromMap(Element eRoleset) {
        NodeList list = eRoleset.getElementsByTagName("roles");
        int size = list.getLength();
        for (int i = 0; i < size; ++i) {
            Element eRoles = (Element)list.item(i);
            String vncls = UTXml.getTrimmedAttribute(eRoles, "vncls");
            this.put(vncls, new PVRoles(eRoles, vncls));
        }
    }

    private void initRolesFromFrameset(Element eRoleset) {
        String[] vnclses = UTXml.getTrimmedAttribute(eRoleset, "vncls").split(" ");
        NodeList nRoles = eRoleset.getElementsByTagName("role");
        for (String vncls : vnclses) {
            if (vncls.isEmpty() || vncls.equals("-")) continue;
            PVRoles pvRoles = new PVRoles(nRoles, vncls);
            if (pvRoles.isEmpty()) {
                System.err.println("Mismatch: " + this.s_rolesetId + " " + vncls);
                continue;
            }
            this.put(vncls, pvRoles);
        }
    }

    public PVRoles getSubVNRoles(String superVNClass) {
        for (String vncls : this.keySet()) {
            if (!vncls.startsWith(superVNClass)) continue;
            return (PVRoles)this.get(vncls);
        }
        return null;
    }

    public PVRoles getSuperVNRoles(String subVNClass) {
        for (String vncls : this.keySet()) {
            if (!subVNClass.startsWith(vncls)) continue;
            return (PVRoles)this.get(vncls);
        }
        return null;
    }

    @Override
    public String toString() {
        ArrayList vnclses = new ArrayList(this.keySet());
        Collections.sort(vnclses);
        StringBuilder build = new StringBuilder();
        for (String vncls : vnclses) {
            build.append("\n");
            build.append(this.get(vncls));
        }
        return UTXml.getTemplate("roleset", build.substring(1), "  ", ATTR_ID, this.s_rolesetId);
    }
}

