/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.morphology;

import com.googlecode.clearnlp.morphology.MPLib;
import java.util.regex.Pattern;

public class MPLibEn
extends MPLib {
    public static Pattern RE_BE = Pattern.compile("^(be|been|being|am|is|was|are|were|'m|'s|'re)$");
    public static Pattern RE_BECOME = Pattern.compile("^(become|becomes|became|becoming)$");
    public static Pattern RE_GET = Pattern.compile("^(get|gets|got|gotten|getting)$");
    public static Pattern RE_HAVE = Pattern.compile("^(have|has|had|having|'ve|'d)$");
    public static Pattern RE_DO = Pattern.compile("^(do|does|did|done|doing)$");

    public static boolean isBe(String form) {
        return RE_BE.matcher(form.toLowerCase()).find();
    }

    public static boolean isGet(String form) {
        return RE_GET.matcher(form.toLowerCase()).find();
    }

    public static boolean isBecome(String form) {
        return RE_BECOME.matcher(form.toLowerCase()).find();
    }

    public static boolean isHave(String form) {
        return RE_HAVE.matcher(form.toLowerCase()).find();
    }

    public static boolean isDo(String form) {
        return RE_DO.matcher(form.toLowerCase()).find();
    }

    public static boolean isNoun(String pos) {
        return pos.startsWith("NN") || pos.equals("PRP") || pos.equals("WP");
    }

    public static boolean isVerb(String pos) {
        return pos.startsWith("VB");
    }

    public static boolean isAdjective(String pos) {
        return pos.startsWith("JJ");
    }

    public static boolean isAdverb(String pos) {
        return pos.startsWith("RB") || pos.equals("WRB");
    }
}

