/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.morphology;

import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.pos.POSNode;
import java.util.Set;

public abstract class AbstractMPAnalyzer {
    public abstract String getLemma(String var1, String var2);

    public abstract Set<String> getPOSTags(String var1);

    public void lemmatize(POSNode[] nodes) {
        for (POSNode node : nodes) {
            node.lemma = this.getLemma(node.form, node.pos);
        }
    }

    public void lemmatize(DEPTree tree) {
        int size = tree.size();
        for (int i = 1; i < size; ++i) {
            DEPNode node = tree.get(i);
            node.lemma = this.getLemma(node.form, node.pos);
        }
    }
}

