/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.headrule;

import com.googlecode.clearnlp.constituent.CTNode;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

public class HeadTagSet {
    public static final String DELIM_TAGS = "|";
    public static final char PREFIX_FTAG = '-';
    private Pattern p_tags;
    private Set<String> f_tags;

    public HeadTagSet(String[] tags) {
        StringBuilder pTags = new StringBuilder();
        this.f_tags = new HashSet<String>();
        for (String tag : tags) {
            if (tag.charAt(0) == '-') {
                this.f_tags.add(tag.substring(1));
                continue;
            }
            pTags.append(DELIM_TAGS);
            pTags.append(tag);
        }
        this.p_tags = pTags.length() != 0 ? Pattern.compile("^(" + pTags.substring(1) + ")$") : null;
    }

    public boolean matches(CTNode node) {
        if (node != null && this.p_tags != null && this.p_tags.matcher(node.pTag).find()) {
            return true;
        }
        return node.hasFTagAny(this.f_tags);
    }

    public String toString() {
        StringBuilder build = new StringBuilder();
        if (this.p_tags != null) {
            String tags = this.p_tags.pattern().substring(2);
            build.append(DELIM_TAGS);
            build.append(tags.substring(0, tags.length() - 2));
        }
        for (String fTag : this.f_tags) {
            build.append(DELIM_TAGS);
            build.append('-');
            build.append(fTag);
        }
        return build.substring(DELIM_TAGS.length());
    }
}

