/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.feature.xml;

import com.googlecode.clearnlp.feature.xml.FtrTemplate;
import com.googlecode.clearnlp.feature.xml.FtrToken;
import com.googlecode.clearnlp.util.pair.IntIntPair;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractFtrXml {
    protected static final String XML_TEMPLATE = "feature_template";
    protected static final String XML_CUTOFF = "cutoff";
    protected static final String XML_LABEL = "label";
    protected static final String XML_TYPE = "type";
    protected static final String XML_FEATURE = "feature";
    protected static final String XML_LEXICA = "lexica";
    protected static final String XML_FEATURE_T = "t";
    protected static final String XML_FEATURE_N = "n";
    protected static final String XML_FEATURE_F = "f";
    protected static final String XML_FEATURE_VISIBLE = "visible";
    protected static final String XML_FEATURE_NOTE = "note";
    protected static final String DELIM_F = ":";
    protected static final String DELIM_R = "_";
    protected FtrTemplate[] f_templates;
    protected boolean b_skipInvisible;
    protected int[] cutoff_label;
    protected int[] cutoff_feature;
    private Document xml_doc;

    public AbstractFtrXml(InputStream fin) {
        this.init(fin, true);
    }

    public AbstractFtrXml(InputStream fin, boolean skipInvisible) {
        this.init(fin, skipInvisible);
    }

    protected void init(InputStream fin, boolean skipInvisible) {
        DocumentBuilderFactory dFactory = DocumentBuilderFactory.newInstance();
        this.b_skipInvisible = skipInvisible;
        try {
            DocumentBuilder builder = dFactory.newDocumentBuilder();
            this.xml_doc = builder.parse(fin);
            this.initCutoffs(this.xml_doc);
            this.initFeatures(this.xml_doc);
            this.initMore(this.xml_doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    protected void initCutoffs(Document doc) throws Exception {
        NodeList eList = doc.getElementsByTagName(XML_CUTOFF);
        int size = eList.getLength();
        this.cutoff_label = new int[size];
        this.cutoff_feature = new int[size];
        for (int i = 0; i < size; ++i) {
            Element eCutoff = (Element)eList.item(i);
            this.cutoff_label[i] = eCutoff.hasAttribute(XML_LABEL) ? Integer.parseInt(eCutoff.getAttribute(XML_LABEL)) : 0;
            this.cutoff_feature[i] = eCutoff.hasAttribute(XML_FEATURE) ? Integer.parseInt(eCutoff.getAttribute(XML_FEATURE)) : 0;
        }
        this.initCutoffMore(eList);
    }

    protected abstract void initMore(Document var1) throws Exception;

    protected void initFeatures(Document doc) throws Exception {
        NodeList eList = doc.getElementsByTagName(XML_FEATURE);
        int n = eList.getLength();
        ArrayList<FtrTemplate> list = new ArrayList<FtrTemplate>();
        int j = 0;
        for (int i = 0; i < n; ++i) {
            Element eFeature = (Element)eList.item(i);
            FtrTemplate template = this.getFtrTemplate(eFeature);
            if (template == null) continue;
            list.add(template);
            if (template.isBooleanFeature()) continue;
            template.type = template.type + j++;
        }
        this.f_templates = new FtrTemplate[list.size()];
        list.toArray(this.f_templates);
    }

    protected FtrTemplate getFtrTemplate(Element eFeature) {
        boolean visible;
        String tmp = eFeature.getAttribute(XML_FEATURE_VISIBLE).trim();
        boolean bl = visible = tmp.isEmpty() ? true : Boolean.parseBoolean(tmp);
        if (this.b_skipInvisible && !visible) {
            return null;
        }
        String type = eFeature.getAttribute(XML_FEATURE_T).trim();
        int n = Integer.parseInt(eFeature.getAttribute(XML_FEATURE_N));
        String note = eFeature.getAttribute(XML_FEATURE_NOTE).trim();
        FtrTemplate ftr = new FtrTemplate(type, n, visible, note);
        for (int i = 0; i < n; ++i) {
            ftr.setFtrToken(i, this.getFtrToken(eFeature.getAttribute(XML_FEATURE_F + i)));
        }
        return ftr;
    }

    protected FtrToken getFtrToken(String ftr) {
        String field;
        String[] aField = ftr.split(DELIM_F);
        String[] aRelation = aField[0].split(DELIM_R);
        char source = aRelation[0].charAt(0);
        if (!this.validSource(source)) {
            this.xmlError(ftr);
        }
        int offset = 0;
        if (aRelation[0].length() >= 2) {
            offset = aRelation[0].charAt(1) == '+' ? Integer.parseInt(aRelation[0].substring(2)) : Integer.parseInt(aRelation[0].substring(1));
        }
        String relation = null;
        if (aRelation.length > 1 && !this.validRelation(relation = aRelation[1])) {
            this.xmlError(ftr);
        }
        if (!this.validField(field = aField[1])) {
            this.xmlError(ftr);
        }
        return new FtrToken(source, offset, relation, field);
    }

    protected void xmlError(String error) {
        System.err.println("Invalid feature: " + error);
        System.exit(1);
    }

    public IntIntPair getSourceWindow(char source) {
        int min = 0;
        int max = 0;
        for (FtrTemplate template : this.f_templates) {
            for (FtrToken token : template.tokens) {
                if (token.source != source) continue;
                if (token.offset < min) {
                    min = token.offset;
                    continue;
                }
                if (token.offset <= max) continue;
                max = token.offset;
            }
        }
        return new IntIntPair(min, max);
    }

    public FtrTemplate[] getFtrTemplates() {
        return this.f_templates;
    }

    public int getLabelCutoff(int index) {
        return index < this.cutoff_label.length ? this.cutoff_label[index] : 0;
    }

    public int getFeatureCutoff(int index) {
        return index < this.cutoff_feature.length ? this.cutoff_feature[index] : 0;
    }

    public String toString() {
        String s = null;
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            StringWriter writer = new StringWriter();
            transformer.transform(new DOMSource(this.xml_doc), new StreamResult(writer));
            s = writer.getBuffer().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return s;
    }

    protected abstract void initCutoffMore(NodeList var1);

    protected abstract boolean validSource(char var1);

    protected abstract boolean validRelation(String var1);

    protected abstract boolean validField(String var1);
}

