/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.dependency;

import com.googlecode.clearnlp.classification.model.StringModel;
import com.googlecode.clearnlp.classification.prediction.StringPrediction;
import com.googlecode.clearnlp.classification.train.StringTrainSpace;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.dependency.AbstractDEPParser;
import com.googlecode.clearnlp.dependency.DEPNode;
import com.googlecode.clearnlp.feature.xml.DEPFtrXml;
import com.googlecode.clearnlp.util.UTArray;
import com.googlecode.clearnlp.util.UTInput;
import com.googlecode.clearnlp.util.UTOutput;
import com.googlecode.clearnlp.util.triple.Triple;
import java.io.BufferedReader;
import java.io.PrintStream;
import java.util.List;
import java.util.Set;

public class DEPParser
extends AbstractDEPParser {
    protected DEPFtrXml f_xml;
    protected StringTrainSpace s_space;
    protected StringModel s_model;

    public DEPParser(DEPFtrXml xml, Set<String> sPunc, StringTrainSpace space) {
        super((byte)1);
        this.f_xml = xml;
        this.s_punc = sPunc;
        this.s_space = space;
    }

    public DEPParser(DEPFtrXml xml, Set<String> sPunc, StringModel model) {
        super((byte)2);
        this.f_xml = xml;
        this.s_punc = sPunc;
        this.s_model = model;
    }

    public DEPParser(DEPFtrXml xml, BufferedReader fin) {
        super((byte)2);
        this.f_xml = xml;
        this.loadModel(fin);
    }

    public DEPParser(DEPFtrXml xml, Set<String> sPunc, StringModel model, StringTrainSpace space) {
        super((byte)3);
        this.f_xml = xml;
        this.s_punc = sPunc;
        this.s_model = model;
        this.s_space = space;
    }

    public DEPParser(PrintStream fout) {
        super((byte)4);
        this.f_trans = fout;
    }

    @Override
    public void loadModel(BufferedReader fin) {
        try {
            this.s_punc = UTInput.getStringSet(fin);
            this.s_model = new StringModel(fin);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void saveModel(PrintStream fout) {
        UTOutput.printSet(fout, this.s_punc);
        this.s_model.save(fout);
    }

    public StringModel getModel() {
        return this.s_model;
    }

    @Override
    protected String[] getLabels() {
        if (this.i_flag == 4) {
            return this.getGoldLabels();
        }
        StringFeatureVector vector = this.getFeatureVector(this.f_xml);
        Object[] labels = null;
        if (this.i_flag == 1) {
            labels = this.getGoldLabels();
            this.s_space.addInstance(UTArray.join(labels, "_"), vector);
        } else if (this.i_flag == 2) {
            labels = this.getAutoLabels(vector);
        } else if (this.i_flag == 3) {
            Object[] gLabels = this.getGoldLabels();
            labels = this.getAutoLabels(vector);
            this.s_space.addInstance(UTArray.join(gLabels, "_"), vector);
        }
        return labels;
    }

    protected boolean isSameLabels(String[] gLabels, String[] aLabels) {
        int size = aLabels.length;
        for (int i = 0; i < size; ++i) {
            if (aLabels[i].equals(gLabels[i])) continue;
            return false;
        }
        return true;
    }

    private String[] getAutoLabels(StringFeatureVector vector) {
        StringPrediction p = this.s_model.predictBest(vector);
        return this.P_LABELS.split(p.label);
    }

    @Override
    protected void postProcessAux(DEPNode node, int dir, Triple<DEPNode, String, Double> max) {
        int size = this.d_tree.size();
        if (dir < 0) {
            this.i_beta = node.id;
        } else {
            this.i_lambda = node.id;
        }
        block0: for (int i = node.id + dir; 0 <= i && i < size; i += dir) {
            DEPNode head = this.d_tree.get(i);
            if (head.isDescendentOf(node)) continue;
            if (dir < 0) {
                this.i_lambda = i;
            } else {
                this.i_beta = i;
            }
            StringFeatureVector vector = this.getFeatureVector(this.f_xml);
            List<StringPrediction> ps = this.s_model.predictAll(vector);
            this.s_model.normalizeScores(ps);
            for (StringPrediction p : ps) {
                if (p.score <= (Double)max.o3) continue block0;
                if ((dir >= 0 || !p.label.startsWith("R")) && (dir <= 0 || !p.label.startsWith("L"))) continue;
                String deprel = this.P_LABELS.split(p.label)[2];
                max.set(head, deprel, p.score);
                continue block0;
            }
        }
    }
}

