/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.clearnlp.component.pos;

import com.googlecode.clearnlp.classification.model.ONStringModel;
import com.googlecode.clearnlp.classification.vector.StringFeatureVector;
import com.googlecode.clearnlp.component.pos.CPOSTagger;
import com.googlecode.clearnlp.dependency.DEPTree;
import com.googlecode.clearnlp.feature.xml.JointFtrXml;
import com.googlecode.clearnlp.util.pair.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ONPOSTagger
extends CPOSTagger {
    ONStringModel o_model;

    public ONPOSTagger(JointFtrXml[] xmls, Object[] lexica, double alpha, double rho) {
        this.f_xmls = xmls;
        this.s_models = new ONStringModel[]{new ONStringModel(alpha, rho)};
        this.initLexia(lexica);
        this.initOnline();
    }

    public ONPOSTagger(ZipInputStream zin, double alpha, double rho) {
        this.loadModels(zin, alpha, rho);
        this.initOnline();
    }

    private void initOnline() {
        this.i_flag = (byte)2;
        this.o_model = (ONStringModel)this.s_models[0];
    }

    public void loadModels(ZipInputStream zin, double alpha, double rho) {
        int fLen = "pos_FEATURE".length();
        int mLen = "pos_MODEL".length();
        this.f_xmls = new JointFtrXml[1];
        this.s_models = null;
        try {
            ZipEntry zEntry;
            while ((zEntry = zin.getNextEntry()) != null) {
                String entry = zEntry.getName();
                if (entry.equals("pos_CONFIGURATION")) {
                    this.loadDefaultConfiguration(zin);
                    continue;
                }
                if (entry.startsWith("pos_FEATURE")) {
                    this.loadFeatureTemplates(zin, Integer.parseInt(entry.substring(fLen)));
                    continue;
                }
                if (entry.startsWith("pos_MODEL")) {
                    this.loadOnlineModels(zin, Integer.parseInt(entry.substring(mLen)), alpha, rho);
                    continue;
                }
                if (!entry.equals("pos_LEXICA")) continue;
                this.loadLexica(zin);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void trainHard(DEPTree tree, int maxIter) {
        int[] counts = new int[2];
        byte flag = this.i_flag;
        this.i_flag = (byte)3;
        this.init(tree);
        for (int i = 0; i < maxIter; ++i) {
            tree.clearPOSTags();
            Arrays.fill(counts, 0);
            List<Pair<String, StringFeatureVector>> insts = this.tag();
            this.countAccuracy(counts);
            if (counts[0] == counts[1]) break;
            this.o_model.updateWeights(insts);
        }
        this.i_flag = flag;
    }

    public void train(List<DEPTree> trees, int bIdx, int eIdx) {
        ArrayList<Pair<String, StringFeatureVector>> insts = new ArrayList<Pair<String, StringFeatureVector>>();
        byte flag = this.i_flag;
        this.i_flag = 1;
        for (int i = bIdx; i < eIdx; ++i) {
            this.init(trees.get(i));
            insts.addAll(this.tag());
        }
        this.o_model.updateWeights(insts);
        this.i_flag = flag;
    }

    public void train(DEPTree tree) {
        byte flag = this.i_flag;
        this.i_flag = (byte)3;
        this.init(tree);
        this.o_model.updateWeights(this.tag());
        this.i_flag = flag;
    }

    public void develop(DEPTree tree) {
        byte flag = this.i_flag;
        this.i_flag = (byte)4;
        this.process(tree);
        this.i_flag = flag;
    }

    public void resetGold() {
        for (int i = 1; i < this.t_size; ++i) {
            this.d_tree.get((int)i).pos = this.g_tags[i];
        }
    }
}

